/**ABDB**/CREATE TABLE `#__action_log_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `id_holder` varchar(255) DEFAULT NULL,
  `title_holder` varchar(255) DEFAULT NULL,
  `table_name` varchar(255) DEFAULT NULL,
  `text_prefix` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('1', 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('2', 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('3', 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
('4', 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
('5', 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('6', 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
('7', 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
('8', 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
('9', 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
('10', 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
('11', 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
('12', 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
('13', 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
('14', 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('15', 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
('16', 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
('17', 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
('18', 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
('19', 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('20', 'task', 'com_scheduler.task', 'id', 'title', '#__scheduler_tasks', 'PLG_ACTIONLOG_JOOMLA'),
('21', 'field', 'com_fields.field', 'id', 'title', '#__fields', 'PLG_ACTIONLOG_JOOMLA'),
('22', 'guidedtour', 'com_guidedtours.state', 'id', 'title', '#__guidedtours', 'PLG_ACTIONLOG_JOOMLA'),
('24', 'contact', 'com_contact.form', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/CREATE TABLE `#__action_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `ip_address` varchar(40) NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8826 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__action_logs_extensions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_extensions`  VALUES 
('1', 'com_banners'),
('2', 'com_cache'),
('3', 'com_categories'),
('4', 'com_config'),
('5', 'com_contact'),
('6', 'com_content'),
('7', 'com_installer'),
('8', 'com_media'),
('9', 'com_menus'),
('10', 'com_messages'),
('11', 'com_modules'),
('12', 'com_newsfeeds'),
('13', 'com_plugins'),
('14', 'com_redirect'),
('15', 'com_tags'),
('16', 'com_templates'),
('17', 'com_users'),
('18', 'com_checkin'),
('19', 'com_scheduler'),
('20', 'com_fields'),
('21', 'com_guidedtours');
/**ABDB**/CREATE TABLE `#__action_logs_users` (
  `user_id` int(10) unsigned NOT NULL,
  `notify` tinyint(3) unsigned NOT NULL,
  `extensions` text NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_users`  VALUES 
('308', '0', '[\"com_content\"]'),
('309', '0', '[\"com_content\"]');
/**ABDB**/CREATE TABLE `#__advancedmodules` (
  `module_id` int(10) unsigned NOT NULL DEFAULT 0,
  `category` varchar(50) NOT NULL,
  `color` varchar(8) DEFAULT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__advancedmodules`  VALUES 
('1', '', NULL, '{}'),
('16', '', NULL, '{}'),
('17', '', NULL, '{}'),
('87', '', NULL, '{}'),
('90', '', NULL, '{}'),
('91', '', NULL, '{}'),
('92', '', NULL, '{}'),
('93', '', NULL, '{}'),
('115', '', NULL, '{}'),
('116', '', '', '{\"hideempty\":\"0\",\"notes\":\"\"}');
/**ABDB**/CREATE TABLE `#__akeeba_common` (
  `key` varchar(190) NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`key`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeeba_common`  VALUES 
('stats_lastrun', '1768135836'),
('stats_siteid', '05741fa98b8cb1ace3e0669bc37ba3c14c377791'),
('stats_siteurl', '27e0c9bf03dced29acc157d8a0705f1d');
/**ABDB**/CREATE TABLE `#__akeebabackup_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `comment` longtext DEFAULT NULL,
  `backupstart` timestamp NULL DEFAULT NULL,
  `backupend` timestamp NULL DEFAULT NULL,
  `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',
  `origin` varchar(30) NOT NULL DEFAULT 'backend',
  `type` varchar(30) NOT NULL DEFAULT 'full',
  `profile_id` bigint(20) NOT NULL DEFAULT 1,
  `archivename` longtext DEFAULT NULL,
  `absolute_path` longtext DEFAULT NULL,
  `multipart` int(11) NOT NULL DEFAULT 0,
  `tag` varchar(255) DEFAULT NULL,
  `backupid` varchar(255) DEFAULT NULL,
  `filesexist` tinyint(3) NOT NULL DEFAULT 1,
  `remote_filename` varchar(1000) DEFAULT NULL,
  `total_size` bigint(20) NOT NULL DEFAULT 0,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  `instep` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_backups`  VALUES 
('27', 'Backup taken on Thursday, 15 January 2026 13:54 EET', '', '2026-01-15 11:54:44', '2026-01-15 11:54:54', 'complete', 'backend', 'full', '1', 'site-psyholistic.top-20260115-135444eet-GOB-B3msBggW6SUc.zip', '/var/www/h50387i/data/www/psyholistic.top/administrator/components/com_akeebabackup/backup/site-psyholistic.top-20260115-135444eet-GOB-B3msBggW6SUc.zip', '0', 'backend', 'id-20260115-115444-563606', '1', NULL, '0', '0', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_profiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `configuration` longtext DEFAULT NULL,
  `filters` longtext DEFAULT NULL,
  `quickicon` tinyint(3) NOT NULL DEFAULT 1,
  `access` int(11) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_profiles`  VALUES 
('1', 'Default Backup Profile', '###AES128###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', '', '1', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_storage` (
  `tag` varchar(255) NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`tag`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=245 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__assets`  VALUES 
('1', '0', '0', '461', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'),
('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'),
('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('8', '1', '17', '262', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
('9', '1', '263', '264', '1', 'com_cpanel', 'com_cpanel', '{}'),
('10', '1', '265', '266', '1', 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
('11', '1', '267', '276', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
('12', '1', '277', '278', '1', 'com_login', 'com_login', '{}'),
('13', '1', '279', '280', '1', 'com_mailto', 'com_mailto', '{}'),
('14', '1', '281', '282', '1', 'com_massmail', 'com_massmail', '{}'),
('15', '1', '283', '284', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
('16', '1', '285', '292', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
('17', '1', '293', '294', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('18', '1', '295', '404', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
('19', '1', '405', '408', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('20', '1', '409', '410', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
('21', '1', '411', '412', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
('22', '1', '413', '414', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('23', '1', '415', '416', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
('24', '1', '417', '420', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
('26', '1', '421', '422', '1', 'com_wrapper', 'com_wrapper', '{}'),
('27', '8', '18', '31', '2', 'com_content.category.2', 'About Psyholistic', '{}'),
('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{}'),
('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{}'),
('30', '19', '406', '407', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
('32', '24', '418', '419', '2', 'com_users.category.7', 'Uncategorised', '{}'),
('33', '1', '423', '424', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('34', '1', '425', '426', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
('35', '1', '427', '428', '1', 'com_tags', 'com_tags', '{}'),
('36', '1', '429', '430', '1', 'com_contenthistory', 'com_contenthistory', '{}'),
('37', '1', '431', '432', '1', 'com_ajax', 'com_ajax', '{}'),
('38', '1', '433', '434', '1', 'com_postinstall', 'com_postinstall', '{}'),
('39', '18', '296', '297', '2', 'com_modules.module.1', 'Main Menu', '{}'),
('40', '18', '298', '299', '2', 'com_modules.module.2', 'Login', '{}'),
('41', '18', '300', '301', '2', 'com_modules.module.3', 'Popular Articles', '{}'),
('42', '18', '302', '303', '2', 'com_modules.module.4', 'Recently Added Articles', '{}'),
('43', '18', '304', '305', '2', 'com_modules.module.8', 'Toolbar', '{}'),
('44', '18', '306', '307', '2', 'com_modules.module.9', 'Quick Icons', '{}'),
('45', '18', '308', '309', '2', 'com_modules.module.10', 'Logged-in Users', '{}'),
('46', '18', '310', '311', '2', 'com_modules.module.12', 'Admin Menu', '{}'),
('47', '18', '312', '313', '2', 'com_modules.module.13', 'Admin Submenu', '{}'),
('48', '18', '314', '315', '2', 'com_modules.module.14', 'User Status', '{}'),
('49', '18', '316', '317', '2', 'com_modules.module.15', 'Title', '{}'),
('50', '18', '318', '319', '2', 'com_modules.module.16', 'Login Form', '{}'),
('51', '18', '320', '321', '2', 'com_modules.module.17', 'Breadcrumbs', '{}'),
('52', '18', '322', '323', '2', 'com_modules.module.79', 'Multilanguage status', '{}'),
('53', '18', '324', '325', '2', 'com_modules.module.86', 'Joomla Version', '{}'),
('54', '18', '326', '327', '2', 'com_modules.module.87', 'Popular Tags', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('55', '18', '328', '329', '2', 'com_modules.module.88', 'Site Information', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('56', '18', '330', '331', '2', 'com_modules.module.89', 'Release News', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('57', '18', '332', '333', '2', 'com_modules.module.90', 'Latest Articles', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('58', '18', '334', '335', '2', 'com_modules.module.91', 'User Menu', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('59', '18', '336', '337', '2', 'com_modules.module.92', 'Image Module', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('60', '18', '338', '339', '2', 'com_modules.module.93', 'Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('61', '27', '19', '20', '3', 'com_content.article.1', 'Home Page', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
('63', '1', '435', '436', '1', 'com_privacy', 'com_privacy', '{\"core.admin\":{\"7\":1}}'),
('64', '1', '437', '438', '1', 'com_actionlogs', 'com_actionlogs', '{\"core.admin\":{\"7\":1}}'),
('65', '1', '439', '440', '1', 'com_fields', 'com_fields', '{}'),
('66', '1', '441', '442', '1', 'com_associations', 'com_associations', '{}'),
('67', '18', '340', '341', '2', 'com_modules.module.114', 'Import Content', '{}'),
('68', '18', '342', '343', '2', 'com_modules.module.115', 'JD Simple Contact Form', '{\"core.delete\":{\"1\":1,\"9\":1},\"core.edit\":{\"9\":1},\"core.edit.state\":{\"9\":1},\"module.edit.frontend\":{\"9\":1}}'),
('69', '1', '443', '444', '1', 'com_akeebabackup', 'com_akeebabackup', '{}'),
('71', '18', '344', '345', '2', 'com_modules.module.116', 'InstrumentalHitsRadioMainPage', '{}'),
('72', '27', '21', '22', '3', 'com_content.article.2', 'Instrumental & Orchestral Hits Radio', '{}'),
('75', '8', '32', '187', '2', 'com_content.category.8', 'Educational Programs', '{}'),
('76', '75', '33', '82', '3', 'com_content.category.9', 'Level 1', '{}'),
('77', '75', '83', '132', '3', 'com_content.category.10', 'Level 2', '{}'),
('78', '75', '133', '186', '3', 'com_content.category.11', 'Level 3', '{}'),
('79', '76', '34', '49', '4', 'com_content.category.12', 'Course 1', '{}'),
('81', '18', '346', '347', '2', 'com_modules.module.117', 'Psyholistic Approach', '{}'),
('82', '18', '348', '349', '2', 'com_modules.module.118', 'Instrumental Hits Radio', '{}'),
('84', '8', '188', '195', '2', 'com_content.category.13', 'Blog', '{}'),
('85', '84', '189', '190', '3', 'com_content.article.3', 'Post 1. About Psyholistic Approach to the Human Psyche', '{}'),
('86', '84', '191', '192', '3', 'com_content.article.4', 'Post 2. About Typosynthesis as a Synthesis of Typologies', '{}'),
('87', '18', '350', '351', '2', 'com_modules.module.120', 'Blog', '{}'),
('88', '76', '50', '65', '4', 'com_content.category.14', 'Course 2', '{}'),
('89', '76', '66', '81', '4', 'com_content.category.15', 'Course 3', '{}'),
('90', '79', '35', '36', '5', 'com_content.article.5', 'Course 1 Lesson 1', '{}'),
('91', '79', '37', '38', '5', 'com_content.article.6', 'Course 1 Lesson 2', '{}'),
('92', '79', '39', '40', '5', 'com_content.article.7', 'Course 1 Lesson 3', '{}'),
('93', '79', '41', '42', '5', 'com_content.article.8', 'Course 1 Lesson 4', '{}'),
('94', '79', '43', '44', '5', 'com_content.article.9', 'Course 1 Lesson 5', '{}'),
('95', '79', '45', '46', '5', 'com_content.article.10', 'Course 1 Lesson 6', '{}'),
('96', '79', '47', '48', '5', 'com_content.article.11', 'Course 1 Lesson 7', '{}'),
('97', '88', '51', '52', '5', 'com_content.article.12', 'Course 2 Lesson 1', '{}'),
('98', '88', '53', '54', '5', 'com_content.article.13', 'Course 2 Lesson 2', '{}'),
('99', '88', '55', '56', '5', 'com_content.article.14', 'Course 2 Lesson 3', '{}'),
('100', '88', '57', '58', '5', 'com_content.article.15', 'Course 2 Lesson 4', '{}'),
('101', '88', '59', '60', '5', 'com_content.article.16', 'Course 2 Lesson 5', '{}'),
('102', '88', '61', '62', '5', 'com_content.article.17', 'Course 2 Lesson 6', '{}'),
('103', '88', '63', '64', '5', 'com_content.article.18', 'Course 2 Lesson 7', '{}'),
('104', '89', '67', '68', '5', 'com_content.article.19', 'Course 3 Lesson 1', '{}'),
('105', '89', '69', '70', '5', 'com_content.article.20', 'Course 3 Lesson 2', '{}'),
('106', '89', '71', '72', '5', 'com_content.article.21', 'Course 3 Lesson 3', '{}'),
('107', '89', '73', '74', '5', 'com_content.article.22', 'Course 3 Lesson 4', '{}'),
('108', '89', '75', '76', '5', 'com_content.article.23', 'Course 3 Lesson 5', '{}'),
('109', '89', '77', '78', '5', 'com_content.article.24', 'Course 3 Lesson 6', '{}'),
('110', '89', '79', '80', '5', 'com_content.article.25', 'Course 3 Lesson 7', '{}'),
('111', '77', '84', '99', '4', 'com_content.category.16', 'Course 4', '{}'),
('112', '77', '100', '115', '4', 'com_content.category.17', 'Course 5', '{}'),
('113', '77', '116', '131', '4', 'com_content.category.18', 'Course 6', '{}'),
('114', '111', '85', '86', '5', 'com_content.article.26', 'Course 4 Lesson 1', '{}'),
('115', '111', '87', '88', '5', 'com_content.article.27', 'Course 4 Lesson 2', '{}'),
('116', '111', '89', '90', '5', 'com_content.article.28', 'Course 4 Lesson 3', '{}'),
('117', '111', '91', '92', '5', 'com_content.article.29', 'Course 4 Lesson 4', '{}'),
('118', '111', '93', '94', '5', 'com_content.article.30', 'Course 4 Lesson 5', '{}'),
('119', '111', '95', '96', '5', 'com_content.article.31', 'Course 4 Lesson 6', '{}'),
('120', '111', '97', '98', '5', 'com_content.article.32', 'Course 4 Lesson 7', '{}'),
('121', '112', '101', '102', '5', 'com_content.article.33', 'Course 5 Lesson 1', '{}'),
('122', '112', '103', '104', '5', 'com_content.article.34', 'Course 5 Lesson 2', '{}'),
('123', '112', '105', '106', '5', 'com_content.article.35', 'Course 5 Lesson 3', '{}'),
('124', '112', '107', '108', '5', 'com_content.article.36', 'Course 5 Lesson 4', '{}'),
('125', '112', '109', '110', '5', 'com_content.article.37', 'Course 5 Lesson 5', '{}'),
('126', '112', '111', '112', '5', 'com_content.article.38', 'Course 5 Lesson 6', '{}'),
('127', '112', '113', '114', '5', 'com_content.article.39', 'Course 5 Lesson 7', '{}'),
('128', '113', '117', '118', '5', 'com_content.article.40', 'Course 6 Lesson 1', '{}'),
('129', '113', '119', '120', '5', 'com_content.article.41', 'Course 6 Lesson 2', '{}'),
('130', '113', '121', '122', '5', 'com_content.article.42', 'Course 6 Lesson 3', '{}'),
('131', '113', '123', '124', '5', 'com_content.article.43', 'Course 6 Lesson 4', '{}'),
('132', '113', '125', '126', '5', 'com_content.article.44', 'Course 6 Lesson 5', '{}'),
('133', '113', '127', '128', '5', 'com_content.article.45', 'Course 6 Lesson 6', '{}'),
('134', '113', '129', '130', '5', 'com_content.article.46', 'Course 6 Lesson 7', '{}'),
('135', '78', '134', '149', '4', 'com_content.category.19', 'Course 7', '{}'),
('136', '78', '150', '165', '4', 'com_content.category.20', 'Course 8', '{}'),
('137', '78', '166', '185', '4', 'com_content.category.21', 'Course 9', '{}'),
('138', '135', '135', '136', '5', 'com_content.article.47', 'Course 7 Lesson 1', '{}'),
('139', '135', '137', '138', '5', 'com_content.article.48', 'Course 7 Lesson 2', '{}'),
('140', '135', '139', '140', '5', 'com_content.article.49', 'Course 7 Lesson 3', '{}'),
('141', '135', '141', '142', '5', 'com_content.article.50', 'Course 7 Lesson 4', '{}'),
('142', '135', '143', '144', '5', 'com_content.article.51', 'Course 7 Lesson 5', '{}'),
('143', '135', '145', '146', '5', 'com_content.article.52', 'Course 7 Lesson 6', '{}'),
('144', '135', '147', '148', '5', 'com_content.article.53', 'Course 7 Lesson 7', '{}'),
('145', '136', '151', '152', '5', 'com_content.article.54', 'Course 8 Lesson 1', '{}'),
('146', '136', '153', '154', '5', 'com_content.article.55', 'Course 8 Lesson 2', '{}'),
('147', '136', '155', '156', '5', 'com_content.article.56', 'Course 8 Lesson 3', '{}'),
('148', '136', '157', '158', '5', 'com_content.article.57', 'Course 8 Lesson 4', '{}'),
('149', '136', '159', '160', '5', 'com_content.article.58', 'Course 8 Lesson 5', '{}'),
('150', '136', '161', '162', '5', 'com_content.article.59', 'Course 8 Lesson 6', '{}'),
('151', '136', '163', '164', '5', 'com_content.article.60', 'Course 8 Lesson 7', '{}'),
('152', '137', '167', '168', '5', 'com_content.article.61', 'Course 9 Lesson 1', '{}'),
('153', '137', '169', '170', '5', 'com_content.article.62', 'Course 9 Lesson 2', '{}'),
('154', '137', '171', '172', '5', 'com_content.article.63', 'Course 9 Lesson 3', '{}'),
('155', '137', '173', '174', '5', 'com_content.article.64', 'Course 9 Lesson 4', '{}'),
('156', '137', '175', '176', '5', 'com_content.article.65', 'Course 9 Lesson 5', '{}'),
('157', '137', '177', '178', '5', 'com_content.article.66', 'Course 9 Lesson 6', '{}'),
('158', '137', '179', '180', '5', 'com_content.article.67', 'Course 9 Lesson 7', '{}'),
('159', '137', '181', '182', '5', 'com_content.article.68', 'Course 9 Lesson 8', '{}'),
('160', '137', '183', '184', '5', 'com_content.article.69', 'Course 9 Lesson 9', '{}'),
('161', '18', '352', '353', '2', 'com_modules.module.121', 'Copyprotection', '{}'),
('162', '18', '354', '355', '2', 'com_modules.module.122', 'Moon Calendar', '{}'),
('163', '18', '356', '357', '2', 'com_modules.module.123', 'Blog1Audio', '{}'),
('164', '18', '358', '359', '2', 'com_modules.module.124', 'Blog1Video', '{}'),
('165', '18', '360', '361', '2', 'com_modules.module.108', 'Site', '{}'),
('166', '18', '362', '363', '2', 'com_modules.module.109', 'System', '{}'),
('167', '18', '364', '365', '2', 'com_modules.module.125', 'Course1Lesson1Audio', '{}'),
('168', '18', '366', '367', '2', 'com_modules.module.126', 'Course1Lesson1Video my host', '{}'),
('169', '11', '268', '269', '2', 'com_languages.language.2', 'French (fr-FR)', '{}'),
('170', '11', '270', '271', '2', 'com_languages.language.3', 'Ukrainian (uk-UA)', '{}'),
('171', '11', '272', '273', '2', 'com_languages.language.4', 'Russian (ru-RU)', '{}'),
('172', '84', '193', '194', '3', 'com_content.article.70', 'Blog 3. Intuition Introvertie', '{}'),
('173', '18', '368', '369', '2', 'com_modules.module.127', 'search', '{}'),
('174', '18', '370', '371', '2', 'com_modules.module.128', 'CustomModuleGoogleSearch', '{}'),
('175', '8', '196', '197', '2', 'com_content.field.1', 'TTpageid', '{}'),
('177', '27', '23', '24', '3', 'com_content.article.71', 'Psyholistic Approach', '{}'),
('178', '27', '25', '26', '3', 'com_content.article.72', 'About Us', '{}'),
('179', '27', '27', '28', '3', 'com_content.article.73', 'Contact', '{}'),
('181', '18', '372', '373', '2', 'com_modules.module.129', 'tytytyt-menu', '{}'),
('182', '18', '374', '375', '2', 'com_modules.module.130', 'tt-form-1', '{}'),
('183', '18', '376', '377', '2', 'com_modules.module.131', 'footertext1', '{}'),
('184', '18', '378', '379', '2', 'com_modules.module.132', 'footertext2', '{}'),
('185', '18', '380', '381', '2', 'com_modules.module.133', 'footertext3', '{}'),
('186', '18', '382', '383', '2', 'com_modules.module.134', 'footertext4', '{}'),
('187', '27', '29', '30', '3', 'com_content.article.74', 'dfddfddhdhhdh', '{}'),
('189', '18', '384', '385', '2', 'com_modules.module.135', 'Course1Lesson2 Video youtube', '{}'),
('190', '18', '386', '387', '2', 'com_modules.module.136', 'Courses Breadcrumbs', '{}'),
('191', '1', '445', '446', '1', 'com_jce', 'COM_JCE', '{}'),
('192', '18', '388', '389', '2', 'com_modules.module.110', '3rd Party', '{}'),
('194', '18', '390', '391', '2', 'com_modules.module.139', 'EB Ajax Search', '{}'),
('195', '16', '286', '287', '2', 'com_menus.menu.5', 'Short Addresses', '{}'),
('196', '8', '198', '247', '2', 'com_content.category.23', 'Typosynthesis', '{}'),
('197', '196', '199', '200', '3', 'com_content.category.24', 'About Typosynthesis', '{}'),
('198', '196', '201', '204', '3', 'com_content.category.25', '4 Styles', '{}'),
('199', '196', '205', '234', '3', 'com_content.category.26', '8 Types', '{}'),
('200', '16', '288', '289', '2', 'com_menus.menu.6', 'Typosynthesis Menu', '{}'),
('201', '18', '392', '393', '2', 'com_modules.module.140', 'Typosynthesis Menu', '{}'),
('202', '8', '248', '261', '2', 'com_content.category.27', 'Typosynthese', '{}'),
('203', '202', '249', '250', '3', 'com_content.category.28', 'A propos de typosynthese', '{}'),
('204', '202', '251', '254', '3', 'com_content.category.29', '4 Styles', '{}'),
('205', '202', '255', '258', '3', 'com_content.category.30', '8 Types', '{}'),
('206', '16', '290', '291', '2', 'com_menus.menu.7', 'Typosynthese Menu', '{}'),
('207', '18', '394', '395', '2', 'com_modules.module.141', 'Typosynthese fr', '{}'),
('208', '18', '396', '397', '2', 'com_modules.module.142', 'Language Switcher', '{}'),
('209', '11', '274', '275', '2', 'com_languages.language.1', 'English (en-GB)', '{}'),
('210', '204', '252', '253', '4', 'com_content.article.75', 'ratio-irratio_fr', '{}'),
('211', '198', '202', '203', '4', 'com_content.article.76', 'ratio-irratio_en', '{}'),
('212', '18', '398', '399', '2', 'com_modules.module.143', 'Clocks booked.net', '{}'),
('213', '18', '400', '401', '2', 'com_modules.module.144', 'EB Ajax Search Typo', '{}'),
('214', '202', '259', '260', '3', 'com_content.article.77', 'contact fr', '{}'),
('215', '196', '235', '236', '3', 'com_content.article.78', 'contact en', '{}'),
('216', '199', '206', '207', '4', 'com_content.article.79', 'Dualities in Jungian typology', '{}'),
('217', '199', '208', '213', '4', 'com_content.category.31', 'Sensation Extraverted', '{}'),
('218', '217', '209', '210', '5', 'com_content.article.80', 'Se in different typological models', '{}'),
('219', '199', '214', '215', '4', 'com_content.article.81', 'levels of harmony ', '{}'),
('220', '199', '216', '217', '4', 'com_content.article.82', 'jungian typology levels of harmony', '{}'),
('221', '1', '447', '448', '1', 'com_guidedtours', 'com_guidedtours', '{}'),
('222', '1', '449', '450', '1', 'com_mails', 'com_mails', '{}'),
('223', '1', '451', '452', '1', 'com_scheduler', 'com_scheduler', '{}'),
('224', '1', '453', '454', '1', 'com_workflow', 'com_workflow', '{}'),
('225', '1', '455', '456', '1', 'com_scheduler.task.1', 'com_scheduler.task.1', '{}'),
('226', '1', '457', '458', '1', 'com_scheduler.task.2', 'com_scheduler.task.2', '{}'),
('227', '1', '459', '460', '1', 'com_scheduler.task.3', 'com_scheduler.task.3', '{}'),
('228', '217', '211', '212', '5', 'com_content.article.83', 'se female portrait ', '{}'),
('229', '199', '218', '221', '4', 'com_content.category.32', 'Sensation Introverted ', '{}'),
('230', '229', '219', '220', '5', 'com_content.article.84', 'Si in different typological models', '{}'),
('231', '199', '222', '223', '4', 'com_content.article.85', 'Social roles', '{}'),
('232', '199', '224', '227', '4', 'com_content.category.33', 'Intuition Extraverted  ', '{}'),
('233', '232', '225', '226', '5', 'com_content.article.86', 'Ne in different typological models', '{}'),
('234', '199', '228', '233', '4', 'com_content.category.34', 'Intuition Introverted', '{}'),
('235', '234', '229', '230', '5', 'com_content.article.87', 'Ni in different typological models ', '{}'),
('236', '205', '256', '257', '4', 'com_content.article.88', 'roles sociaux', '{}'),
('238', '234', '231', '232', '5', 'com_content.article.90', 'Ni male portrait', '{}'),
('239', '196', '237', '244', '3', 'com_content.category.36', 'Intertype relationships', '{}'),
('240', '239', '238', '239', '4', 'com_content.article.91', 'Anima as function', '{}'),
('241', '239', '240', '241', '4', 'com_content.article.92', 'Comparison of relationships', '{}'),
('242', '196', '245', '246', '3', 'com_content.article.93', 'Eight-function model ', '{}'),
('243', '239', '242', '243', '4', 'com_content.article.94', 'Kinds of intertype relationships', '{}'),
('244', '18', '402', '403', '2', 'com_modules.module.146', 'Super Users Log In', '{}');
/**ABDB**/CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__associations`  VALUES 
('204', 'com_menus.item', '533ada5cd6fc5c3377558fd7bd14b92a'),
('208', 'com_menus.item', '533ada5cd6fc5c3377558fd7bd14b92a'),
('203', 'com_menus.item', '8b9f49f39f9ddd94f373691dda7f8304'),
('207', 'com_menus.item', '8b9f49f39f9ddd94f373691dda7f8304'),
('202', 'com_menus.item', 'ad9ec78da13529ac4b7d468808820043'),
('206', 'com_menus.item', 'ad9ec78da13529ac4b7d468808820043');
/**ABDB**/CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text DEFAULT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(400) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT 0,
  `impmade` int(11) NOT NULL DEFAULT 0,
  `clicks` int(11) NOT NULL DEFAULT 0,
  `clickurl` varchar(2048) NOT NULL DEFAULT '',
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `description` text NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` text DEFAULT NULL,
  `params` text NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(400) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100)),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `metadesc` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__categories`  VALUES 
('1', '0', '0', '0', '65', '0', '', 'system', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '308', '2022-03-24 11:45:52', '308', '2022-03-24 11:45:52', '0', '*', '1'),
('2', '27', '1', '1', '2', '1', 'about-psyholistic', 'com_content', 'About Psyholistic', 'about-psyholistic', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-24 11:45:52', '308', '2022-09-23 11:44:08', '0', 'en-GB', '1'),
('3', '28', '1', '29', '30', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-24 11:45:52', '308', '2022-03-24 11:45:52', '0', '*', '1'),
('4', '29', '1', '31', '32', '1', 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-24 11:45:52', '308', '2022-03-24 11:45:52', '0', '*', '1'),
('5', '30', '1', '33', '34', '1', 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-24 11:45:52', '308', '2022-03-24 11:45:52', '0', '*', '1'),
('7', '32', '1', '35', '36', '1', 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-24 11:45:52', '308', '2022-03-24 11:45:52', '0', '*', '1'),
('8', '75', '1', '3', '28', '1', 'educational-programs', 'com_content', 'Educational Programs', 'educational-programs', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-27 18:45:50', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('9', '76', '8', '4', '11', '2', 'educational-programs/level-1', 'com_content', 'Level 1', 'level-1', '', '<p><span style=\"background-color: #c2e0f4;\">Level 1 Description before line</span></p>\r\n<p> </p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-28 15:50:12', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('10', '77', '8', '12', '19', '2', 'educational-programs/level-2', 'com_content', 'Level 2', 'level-2', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-28 15:52:57', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('11', '78', '8', '20', '27', '2', 'educational-programs/level-3', 'com_content', 'Level 3', 'level-3', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-28 15:54:17', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('12', '79', '9', '5', '6', '3', 'educational-programs/level-1/course-1', 'com_content', 'Course 1', 'course-1', '', '<p>Course 1 description</p>\r\n<p>Here there is no page break</p>\r\n<p> </p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-28 15:59:00', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('13', '84', '1', '37', '38', '1', 'blog', 'com_content', 'Blog', 'blog', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-28 21:11:50', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('14', '88', '9', '7', '8', '3', 'educational-programs/level-1/course-2', 'com_content', 'Course 2', 'course-2', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-29 09:35:31', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('15', '89', '9', '9', '10', '3', 'educational-programs/level-1/course-3', 'com_content', 'Course 3', 'course-3', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-29 09:36:29', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('16', '111', '10', '13', '14', '3', 'educational-programs/level-2/course-4', 'com_content', 'Course 4', 'course-4', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-29 12:38:58', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('17', '112', '10', '15', '16', '3', 'educational-programs/level-2/course-5', 'com_content', 'Course 5', 'course-5', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-29 12:39:23', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('18', '113', '10', '17', '18', '3', 'educational-programs/level-2/course-6', 'com_content', 'Course 6', 'course-6', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-29 12:39:42', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('19', '135', '11', '21', '22', '3', 'educational-programs/level-3/course-7', 'com_content', 'Course 7', 'course-7', '', '<p>dsffsfsfsf</p>\r\n<p>dfsfsfdsf</p>\r\n<p>fsfsdfsdfs</p>\r\n<p>cxvxcvxcvxvxcv xcvxvxcv gfdhhhh fsfsdgdgdg cnhdgdhdfh gdgfdgdfgdfg dfhdfhhd</p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-29 14:33:46', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('20', '136', '11', '23', '24', '3', 'educational-programs/level-3/course-8', 'com_content', 'Course 8', 'course-8', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-29 14:36:01', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('21', '137', '11', '25', '26', '3', 'educational-programs/level-3/course-9', 'com_content', 'Course 9', 'course-9', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2022-03-29 14:37:16', '308', '2022-04-21 20:08:39', '0', 'en-GB', '1'),
('23', '196', '1', '39', '56', '1', 'typosynthesis', 'com_content', 'Typosynthesis', 'typosynthesis', '', '', '1', '309', '2025-03-11 08:10:22', '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2023-08-10 14:00:16', '309', '2024-06-03 05:50:45', '0', 'en-GB', '1'),
('24', '197', '23', '40', '41', '2', 'typosynthesis/about-typosynthesis', 'com_content', 'About Typosynthesis', 'about-typosynthesis', '', '<h2 style=\"text-align: center;\"><strong>About TYPO-SYNTHESIS</strong></h2>\r\n<p><span>Typosynthesis&nbsp;is an integrative approach of holistic psychology that helps individuals to find underlying&nbsp;root issues, discover&nbsp;their deep resources and to walk the path of personal change for improvement in various areas of life: personal, social, professional.</span></p>\r\n<p><span>Typosynthesis unites Jungian, Enneagram, Planetary, Homeopathic and other typologies with traditional and spiritual psychologies.</span></p>\r\n<p>There are many typological models that divide humanity into eight types (or approximately eight types). It can be assumed that they all describe similar types of people. Different typological models have their own useful experience&nbsp;and practice, and can enrich each other. One of the goals of the Typosynthesis project is dialogue between specialists in different typologies and a synthesis of typologies.</p>\r\n<p style=\"text-align: center;\"><strong>Eight-component typological models (and models close to 8)</strong></p>\r\n<p>* Jung\'s typology has 8 psychological types. (<em>more on this here <a href=\"en/8-types/79-dualities-in-jungian-typology\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em>)<br />* The Enneagram typology has 9 types. If one looks at the Enneagram through the lens of Jung\'s typology, one can see that the Intuitive type in the Enneagram is divided into two types: Thinking Intuitive and Feeling Intuitive.<br />* Planetary typology has a different number of types depending on the author: from 6 to 10.<br />* The Seven Rays typology has 7 types.<br />* The Chinese Bagua model has 8 trigrams, which representing both eight kinds of energy and eight character traits.</p>\r\n<p>Homeopaths have made a significant contribution to the development of typology.&nbsp;In homeopathy, treatment is prescribed based on the constitution of a person. Constitutional type includes both physical and psychological characteristics, every constitutional type has a corresponding personality profile. Therefore, in homeopathy, there are many psychological profiles of people — about 20 basic profiles and plenty of others corresponding to the characteristics of various medicines.<br />Several attempts have been made to systematize all homeopathic types. In 1930, the famous French homeopath Leon Vannier published a book entitled \"Typology in Homeopathy,\" in which he traced all psychological types back to eight prototypes, giving them the names of planets. Combinations of the eight prototypes form different types.<br />In 1996, Dutch homeopath Jan Scholten published his book, \"Homeopathy and the Elements,\" in which he systematized various psychological types associated with chemical elements using two scales: vertical and horizontal. The horizontal scale (‘series’) corresponds to the horizontal rows of the periodic table and the level of development of different types. The vertical scale (‘stages’) corresponds to the vertical groups of the periodic table and describes different types of people. In other words, the vertical column describes a type of person, and the horizontal row indicates the their level of development. In the expanded form used today, the periodic table has 18 groups (i.e., 18 vertical columns). In the short form, previously used in the United States and post-Soviet countries, the periodic table has 8 main groups (s-&nbsp;and&nbsp;p-block) and 10 subgroups (d-block). Using the short form of the periodic table, we get eight basic types. According to psychological characteristics, the 8 main types in Scholten\'s system correspond to the eight types of Jung\'s typology.</p>\r\n<p>&nbsp;</p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2023-08-10 14:00:48', '309', '2026-01-05 12:35:18', '0', 'en-GB', '1'),
('25', '198', '23', '42', '43', '2', 'typosynthesis/4-styles', 'com_content', '4 Styles', '4-styles', '', '<h2> </h2>\r\n<h2 style=\"text-align: center;\"><strong>FOUR INTERACTION STYLES</strong></h2>\r\n<p>Since childhood, we all have certain patterns of behavior, certain preferences and, in general, a certain attitude towards life. We all express ourselves in different ways and influence others in different ways. Often we cannot understand the behavior of other people, and they cannot understand ours. Moreover, sometimes we cannot understand what is driving our own behavior.</p>\r\n<p>In order for individual characteristics to be used with benefit, and not to become a barrier in relationships between people, it is worth understanding what goals, motivations and beliefs underlie people\'s behavior. Understanding your own interaction style and the style of other people contributes to more effective communication and helps to avoid many misunderstandings.</p>\r\n<p>There are four interaction styles</p>\r\n<p><img src=\"images/typo/En/4styles/4_styles_main_en.jpg\" alt=\"\" width=\"500\" style=\"display: block; margin-left: auto; margin-right: auto;\" loading=\"lazy\"></p>\r\n<p>Different styles are characterized by different <strong>aims</strong>, and different <strong>strategies</strong> are applied to achieve these aims.</p>\r\n<p><strong>• Ordering style. </strong><img src=\"images/typo/4_styles/Vpor_s.jpg\" alt=\"\" width=\"80\" style=\"float: left;\">People with the Ordering style are driven to ensure order and stability. They order chaotic activity, structure, create a system, develop rules and monitor their observance.</p>\r\n<p>They usually look serious and considered, keep psychological distance in communication, often retain impassible countenance. </p>\r\n<p><strong>• Engaging style. </strong><img src=\"images/typo/4_styles/Zaly4_s.jpg\" alt=\"\" width=\"90\" style=\"float: left;\">People with the Engaging style are driven to organize collaborative activities. They know how to draw others\' attention to a particular issue and engage them in a joint discussion and activity. They can easily interact with strangers and they are actively using social networks.</p>\r\n<p>Engagers are usually quick-moving, impatient, tense, and expressive, they talk much and quickly and don’t keep a distance in communication.</p>\r\n<p><strong>• Changing style. </strong><img src=\"images/typo/4_styles/Zmin_s.jpg\" alt=\"\" width=\"85\" style=\"float: left;\">People with the Changing style are driven to implement changes. They destroy old systems and patterns, initiate changes, act decisively and confidently, quickly orient themselves in a new situation, pave the way in a new field.</p>\r\n<p>They are proactive, independent, courageous, energetic, creative, open-minded, they have a laid-back manner and flexibly react to changes.</p>\r\n<p><strong>• Integrating style. </strong><img src=\"images/typo/4_styles/Integr_s.jpg\" alt=\"\" width=\"95\" style=\"float: left;\">People with the Integrating style are driven to create unity and harmony. They smooth out conflicts, help find consensus, create a harmonious environment. They show diplomacy, avoid being direct and categorical in their statements, so as not to offend anyone.</p>\r\n<p>They are pliant, accommodating and tolerant in nature, condescending to other people’s weaknesses, respecting the personal space of others, they are great listeners. They are not in a hurry, move smoothly, appear relaxed.</p>\r\n<p style=\"text-align: center;\">Each style is associated with a specific way of <strong>making decisions</strong>.</p>\r\n<p><strong>Integrating </strong>– consults with others, tries to take into account all factors and opinions, hesitates, delaying the decision for as long as possible; waiting for support or boost from others.</p>\r\n<p><strong>Changing </strong>– makes decisions quickly and independently, without detailed planning and deliberation, takes a non-standard approach in solving problems, willing to take risks, easily changes decisions when circumstances change.</p>\r\n<p><strong>Engaging </strong>– develops a clear plan of action before acting. Focused on achieving rapid results, can\'t relax until the job is completed. Can adjust plans according to the expectations of others.</p>\r\n<p><strong>Ordering </strong>– carefully consider one’s decision, gathering additional information, delving into details, ponders possible consequences. Moves towards the goal slowly and methodically. Usually does not change one’s decisions.</p>\r\n<p>Here’s an example of how people of different styles behave on vacation:</p>\r\n<p><em><strong>Lily </strong>: Makes a detailed itinerary months in advance. Wants to spend her vacation with benefit: go to the museum or bookstore. On each excursion corrects the guide, if he does not speak accurately enough, which irritates the latter.</em></p>\r\n<p><em><strong>Henry </strong>: Suggests a lot of options of vacation and articulates these to the people around. Plans the route and coordinates the actions of the participants. During the holidays engages everybody in joint activity: cooking, playing, hiking. Prevents Lily from quietly reading the book.</em></p>\r\n<p><em><strong>Grace </strong>: Changes plans at the last moment. Doesn’t care what anyone thinks. Throws spontaneous vacation with 8 people she just met. Refuses to sleep because there is so much to do! </em></p>\r\n<p><em><strong>Teddy </strong>: Doesn’t go where he really wants to because he can\'t say no to Grace. Enjoys nature in a quiet place alone. Sometimes participates in Grace’s crazy activities, tries to create a harmonious environment in the company and smooth out conflicts.</em></p>\r\n<p>Try to identify the interaction style of each of them.</p>\r\n<p style=\"text-align: center;\"><strong>Attitude towards rules and restrictions </strong></p>\r\n<p>Attitude to rules and restrictions is closely related to <a href=\"en/4-styles/76-ratio-irratio-en\" target=\"_blank\" rel=\"noopener\">planned and spontaneous</a> approaches to life. The more a <em>planned </em>approach prevails in a person, the more important the rules are for him, the easier he perceives restrictions. The more a <em>spontaneous </em>approach prevails in a person, the less he is inclined to follow rules and limit himself in anything.</p>\r\n<p><img src=\"images/typo/En/4styles/4_styles_color_en.jpg\" alt=\"\" width=\"300\" style=\"display: block; margin-left: auto; margin-right: auto;\"></p>\r\n<p>People with <em>Ordering </em>and <em>Engaging </em>style have a planned approach to life, they tend to keep agreements, easily tune in to established rules and procedures, abide by them, and expect others to do the same. Rules, laws and order provide them with a sense of security and stability.</p>\r\n<p>People with <em>Changing </em>and <em>Integrating </em>style have a spontaneous approach to life, they try not to bind themselves with obligations and agreements, value a sense of freedom and the ability to act spontaneously, rules and restrictions limit their creativity.</p>\r\n<p>Rules and reasonable restrictions are the most appreciated by people with a predominant Ordering style, while people who like rules the least are those with a predominant Changing style.</p>\r\n<p> </p>\r\n<p><img src=\"images/typo/En/4styles/4_styles_rules_en.jpg\" alt=\"\" width=\"500\" style=\"display: block; margin-left: auto; margin-right: auto;\"></p>\r\n<p style=\"text-indent: 1px; text-align: left;\"><strong>Ordering</strong>: Shares the view that the rules and laws are the same for everyone. Can establish the rules himself and ensure that others follow them. Believes we should stop at red lights when there is no other traffic, signal when turning even if there\'s no one to signal to. Ordering style is prone to self-discipline and limitation of one\'s needs, saving and asceticism.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\"><strong>Engaging</strong>: Needs certain rules and a structured environment for a sense of stability, but may break the rules if it does not cause a negative reaction from others. Openly expresses disagreement with unclear or ridiculous restrictions and rules.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\"><strong>Integrating</strong>: Rules are not important to him. Follows established rules so as not to be rude to anyone. Easily breaks rules when no one is looking. Never openly opposes anything. If he doesn\'t want to follow the rules, he passively resists and discreetly sabotages.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\"><strong>Changing</strong>: Perceives rules and obligations as restriction of freedom, easily violates them, reacts negatively to any restrictions. There are no authorities for him, he is not swayed by the opinion of others, does not succumb to the pressure of social conventions or patterns and is prone to open dissent and rebellion.</p>\r\n<p>We use different styles in different circumstances. A person can show one style at home, a second with friends, and a third at work.</p>\r\n<p>The nature of the job strongly influences the style of interaction. For example, for such a monotonous job as accounting or programming, the Ordering style is most suitable, while for such dynamic job as a firefighter or actor, the Changing style is most suitable. A person with an Ordering style would find it difficult to work as a firefighter, and for a person with a Changing style it would be a real punishment to work as an accountant.</p>\r\n<p>People can change their interaction style depending on the situation. However, everyone has one’s own natural style in which he or she feels most comfortable and resourceful. Other styles may be too energy-consuming for a person, especially when he is forced to use a style unusual for him for a long time.</p>\r\n<p style=\"text-align: center;\">Interaction styles in different countries</p>\r\n<p>A person\'s interaction style is also influenced by the interaction style of the country in which he lives. People from different countries have different interaction styles.</p>\r\n<p>This is how Richard Lewis describes the differences in behavior in his book “When Cultures Collide”:</p>\r\n<p><em>“I was once in charge of an English language summer course in North Wales for adult students from three countries—Italy, Japan, and Finland. Intensive instruction was relieved by entertainment in the evenings and by day excursions to places of scenic or historical interest. We had scheduled a trip up Mount Snowdon on a particular Wednesday, but on the Tuesday evening it rained heavily. Around 10 o’clock that night, during the after-dinner dancing, a dozen or so Finns approached me and suggested that we cancel the excursion, as it would be no fun climbing the muddy slopes of Snowdon in heavy rain. I, of course, agreed and announced the cancellation. </em><br><em>Immediately I was surrounded by protesting Italians disputing the decision. Why cancel the trip—they had been looking forward to it (escape from lessons), they had paid for it in their all-inclusive fee, a little rain would not hurt anyone and what was the matter with the Finns anyway—weren’t they supposed to be tough people? A little embarrassed, I consulted the Japanese contingent. They were very, very nice. If the Italians wanted to go, they would go, too. If, on the other hand, we cancelled the trip they would be quite happy to stay in and take more lessons. The Italians jeered at the Finns, the Finns mumbled and scowled, and eventually, in order not to lose face, agreed they would go. The excursion was declared on. It rained torrentially all night and also while I took a quick breakfast. The bus was scheduled to leave at half past eight, and at twenty-five past, taking my umbrella in the downpour, I ran to the vehicle. Inside were 18 scowling Finns, 12 smiling Japanese, and no Italians. We left on time and had a terrible day. The rain never let up, we lunched in cloud at the summit, and returned covered in mud at 5 o’clock, in time to see the Italians taking tea and chocolate biscuits. They had sensibly stayed in bed. When the Finns asked them why, they said because it was raining...”</em> (<a href=\"#lewis\">1</a>)</p>\r\n<p>In many countries, one style of interaction predominates over others.</p>\r\n<p>The <strong>Ordering </strong>style is clearly expressed in Germany. It is also predominant in China.</p>\r\n<p>An example of a somewhat hyperbolized Ordering style is the Amish settlements, where strong restrictions and ascetic lifestyle are practiced.</p>\r\n<p>The <strong>Engaging </strong>style is characteristic of the United States.</p>\r\n<p>The <strong>Integrating </strong>style is characteristic of Japan, and is also expressed in some Scandinavian countries.</p>\r\n<p>The <strong>Changing </strong>style can be observed in countries such as Greece, India and Israel (<a href=\"#adizes\">2</a>). The Changing style is also prevalent among Roma (gypsies).</p>\r\n<p>No one style is better or worse than others. A certain style may be more efficient in a certain situation.</p>\r\n<p>Knowing the typology allows not only to avoid many misunderstandings that can arise between people with different styles, but also to improve interaction with them.</p>\r\n<p style=\"text-align: center;\">*       *       *       </p>\r\n<p style=\"text-align: left;\"><a id=\"lewis\"></a>1 - Richard D. Lewis. When Cultures Collide: Managing successfully across cultures. London 1996. Copyright Richard D Lewis. <a href=\"https://www.crossculture.com/\" target=\"_blank\" rel=\"noopener\">www.crossculture.com</a></p>\r\n<p style=\"text-align: left;\"><a id=\"adizes\"></a>2 - According to Dr. Adizes, the E role is prevalent in Greece, India and Israel. (Adizes, I. The ideal executive: why you cannot be one and what to do about it. 2004. Chapter 3: What Causes Mismanagement?) Typosynthesis connects the E role with the Changing style.</p>\r\n<p style=\"text-align: right;\"><em>Original text in Ukrainian here <a href=\"https://7promeniv.com.ua/4-styli-vzaiemodii\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></p>\r\n<p style=\"text-align: left;\"><em>Last updating 17.03.2024</em></p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2023-08-10 14:01:15', '308', '2026-01-15 11:23:15', '0', 'en-GB', '1'),
('26', '199', '23', '44', '53', '2', 'typosynthesis/8-types', 'com_content', '8 Types', '8-types', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2023-08-10 14:01:34', '308', '2023-08-10 14:02:55', '0', 'en-GB', '1'),
('27', '202', '1', '57', '64', '1', 'typosynthese', 'com_content', 'Typosynthese', 'typosynthese', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2023-08-14 13:59:54', '308', '2023-08-14 13:59:54', '0', 'fr-FR', '1'),
('28', '203', '27', '58', '59', '2', 'typosynthese/a-propos-de-typosynthese', 'com_content', 'A propos de typosynthese', 'a-propos-de-typosynthese', '', '<h2 style=\"text-align: center;\"><strong>A propos de TYPO-SYNTHESE&nbsp;</strong></h2>\r\n<p><span>Typosynthèse est une approche intégrative de la psychologie holistique qui aide les individus à découvrir les problèmes fondamentaux sous-jacents qui sont à l\'origine de leurs défis et à suivre le chemin des changements personnels pour s\'améliorer dans divers domaines de la vie : personnel, social, professionnel.</span></p>\r\n<p>Typosynthèse réunit les typologies jungienne, ennéagramme, planétaire, homéopathique et autres avec les psychologies traditionnelles et spirituelles.</p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2023-08-14 14:04:19', '309', '2025-03-11 08:11:19', '0', 'fr-FR', '1'),
('29', '204', '27', '60', '61', '2', 'typosynthese/4-styles', 'com_content', '4 Styles', '4-styles', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2023-08-14 14:09:16', '308', '2023-08-14 14:09:16', '0', 'fr-FR', '1'),
('30', '205', '27', '62', '63', '2', 'typosynthese/8-types', 'com_content', '8 Types', '8-types', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2023-08-14 14:09:57', '308', '2023-08-14 14:09:57', '0', 'fr-FR', '1'),
('31', '217', '26', '45', '46', '3', 'typosynthesis/8-types/sensation-extraverted', 'com_content', 'Sensation Extraverted', 'sensation-extraverted', '', '<h1 style=\"text-align: center;\"><strong>SE - SENSATION EXTRAVERTED TYPE</strong>&nbsp;</h1>\r\n<p>&nbsp;</p>\r\n<p>SENSATION Extraverted type focuses on physical reality, is well versed in the world of material objects, confidently makes his way in the physical world, is practical and pragmatic, characterized by high physical activity, independence, decisive overcoming of obstacles, ability to confront.</p>\r\n<p><strong><em>Sensation Extraverted type – Se in different typological models<span>&nbsp;</span><a href=\"en/8-types/sensation-extraverted/80-se-in-different-typological-models\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></strong></p>\r\n<p><strong>°&nbsp;Female portrait of Se type <a href=\"en/8-types/sensation-extraverted/83-se-female-portrait\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></strong></p>\r\n<p><strong>°</strong> Se&nbsp;type at different <strong>levels of harmony</strong> <a href=\"en/8-types/levels#se\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p><img src=\"images/typo/En/8types/kolo_sensing_extra.jpg\" alt=\"\" width=\"30%\" style=\"float: right;\" /></p>\r\n<p>update</p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '308', '2024-04-29 14:04:19', '309', '2025-09-22 09:46:05', '0', 'en-GB', '1'),
('32', '229', '26', '47', '48', '3', 'typosynthesis/8-types/sensation-introverted', 'com_content', 'Sensation Introverted ', 'sensation-introverted', '', '<h1 style=\"text-align: center;\"><strong>SI - SENSATION INTROVERTED TYPE</strong></h1>\r\n<p>SENSATION&nbsp;(or SENSING) Introverted type - <strong>Si type</strong></p>\r\n<p style=\"text-align: center;\">Socionics-based description of Si type</p>\r\n<p><em>The type of person is determined by the main (dominant) psychic function. All eight functions are present in the psyche of each person, but they have different degrees of development. SENSATION Introverted (Si) function is the leading function in the Si types.</em></p>\r\n<p>Calm and unhurried, Si types are strongly connected to their body and able to recognize the smallest variations in physical state. They derive pleasure from subtle physical sensations and slow down to touch, hear, taste, see and smell the physical world, they love the feel of things, sand underfoot, the texture of tree trunk, the breeze on the skin. They typically appreciate the beauty of the world around them, and they often have a strong aesthetic sense. They are able to visualize the best possible arrangement of objects, harmonious combination of shapes and colors and are sensitive to any disharmony. How they physically appear in the world matter to them, they know what clothes suits them.</p>\r\n<p>Above all else, Si types value inner tranquility, peace and harmony. They have an innate ability to create a warm, calming and welcoming atmosphere, peaceful and conflict-free space. People with this type of personality are nonjudgmental listeners, laidback and patient, they are difficult to aggravate. They have the ability to remain calm and composed in difficult situations.&nbsp;The daily lifestyle of Si type people is spontaneous, flexible, and spur-of-the-moment, they are at ease in the unpredictable, are able to go with the flow and adapt to changes, provided it’s not too fast and too abrupt.</p>\r\n<p>Their reputation for being a homebody, married to the couch comes from their need to decompress and relax. Si types prefer comfortable surroundings. They designate cozy nooks in their home where they can relax and unwind. They are stable and grounded, and given to rootedness in a particular place. They like children, are fond of animals, enjoys gardening. Home and matters of the family are very important to Si types. Generous and loyal, they have a drive to provide for their loved ones.&nbsp;Recognizing their physical states allows them to understand and respond to the needs of others. They are able to create a safe and supportive environment, to provide comfort and support for others so they can heal and grow. They believe each person should be afforded his or her own space. Those around the Si type enjoy a high level of personal freedom. Si type people offer their support staying in the background.&nbsp;They love to host and cook for friends. They strive to create a sense of equality, community and belonging and desire that everyone should get along with one another.</p>\r\n<p>Relationship. Si type’s signature leisurely pace shows up also in the bedroom. They need to feel loved, comforted, and, above all, stable in a relationship. They\'re not ones for drama. Si types do not like conflict and will often back down or make compromises in the face of an argument, to keep the peace.</p>\r\n<p>Career. Si type people aren’t afraid to roll up their sleeves and work hard to earn big rewards. They work well alone but will pull together as part of a team when necessary. In the workplace they make friends with everyone. Si types don’t like hurry, the working environment needs to allow for personal freedom and flexibility.</p>\r\n<p>Si type can be an excellent cook, gardener, interior or fashion designer, and artist. They love working with their hands and they thrive with hands-on tasks like farming, botany and agriculture. They are also good at nonverbal forms of communication, such as art, instrumental music, dance, sports, or work with animals and nature.</p>\r\n<p><img src=\"images/typo/En/8types/kolo_sensing_intro.jpg\" alt=\"\" width=\"30%\" style=\"float: right;\" /></p>\r\n<p><em>In Jung\'s model of typology, the psychical functions are represented as dualities: SENSATION Introverted (Si) is strongly connected with INTUITION Extraverted (Ne). To maintain psychological balance, these functions must remain in a certain ratio to each other in the psyche of a person. If Si function displaces Ne function, this leads to psychological imbalance: inertia of a person, over-focusing on comfort and under-estimating one’s true potential.</em></p>\r\n<p><strong>Unbalanced</strong> Si-types are characterized by an excessively earth-bound attitude, a lack of imagination and a loss of openness to the unexpected and to the intangible. They are overly worried about a lack of physical comfort and see everyone and everything as threatening to their peace.</p>\r\n<p>With the <strong>one-sided development</strong> of the Si function, a person ignores life’s opportunities and has difficulty in understanding one’s own potentialities, he is blind to himself and indecisive. Such people are slow to switch course or accept new ideas, can\'t keep up with the times and resist change. They are excessively attached to the familiar, to the group norms or \"how things are done.\" They tend to stay in situations that no longer serve them, like a job they’ve outgrown or a toxic friendship. That might cause them to get caught in a rut and not know how to get out.</p>\r\n<p>They perceive the intense movements and changes of everyday life as exhausting.&nbsp;They tend to get caught up in nonessential activities and small tasks to avoid dealing more critical problems. They desire to be alone and to laze about to wait out periods of conflict. Their pursuit of this, leads to a life of gluttony, excess, and in many cases, addiction.&nbsp;</p>\r\n<p>Since the dual Ne function balances the Si function, <strong>Socionics recommends</strong> that Si types, when they are out of balance, communicate more with Ne types.</p>\r\n<p>Ne-types provide the stimulation to inert Si-types, thanks to their developed imagination they are able to interest Si-types in something besides the obvious, physical and comfortable. Curious and proactive, Ne type encourages Si types people to search for something new and unexplored, prompts to explore more options and possibilities, broadens their outlook, reveals hidden talents, finds new ways to solving their problems, helps realize their potential, brings the fun and sense of adventure to their monotonous life.</p>\r\n<p>Interaction with the dual type has the effect of calming and balance, and prevents extremes and one-sidedness.</p>\r\n<p>&nbsp;</p>\r\n<p><strong><em>Sensation Introverted type – Si in different typological models <a href=\"en/8-types/sensation-introverted/84-si-in-different-typological-models\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></strong></p>\r\n<p>* Si type at different <strong>levels of harmony</strong> <a href=\"en/8-types/levels#si\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p style=\"text-align: right;\"><em>Українською тут <a href=\"https://7promeniv.com.ua/korotki-opysy-typiv/2-sensoryka-introvertna.html\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a><span></span></em></p>\r\n<p><em>Last updating 16.10.2024</em></p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '309', '2024-07-01 05:57:13', '309', '2025-09-22 09:47:15', '0', 'en-GB', '1'),
('33', '232', '26', '49', '50', '3', 'typosynthesis/8-types/intuition-extraverted', 'com_content', 'Intuition Extraverted  ', 'intuition-extraverted', '', '<p>NE – &nbsp;INTUITION EXTRAVERTED TYPE</p>\r\n<p><strong><em>Intuition Extraverted type – Ne – in different typological models&nbsp;<a href=\"en/8-types/intuition-extraverted/86-ne-in-different-typological-models\">&gt;&gt;&gt;</a></em></strong></p>\r\n<p>Ne type at different levels of harmony <a href=\"en/8-types/levels#ne\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '309', '2024-10-31 09:56:20', '309', '2025-09-22 09:44:55', '0', 'en-GB', '1'),
('34', '234', '26', '51', '52', '3', 'typosynthesis/8-types/intuition-introverted', 'com_content', 'Intuition Introverted', 'intuition-introverted', '', '<h2 style=\"text-align: center;\"><strong>NI - INTUITION INTROVERTED TYPE</strong></h2>\r\n<p style=\"text-align: left;\">INTUITION (or INTUITING) Introverted type - <strong>Ni type</strong></p>\r\n<p style=\"text-align: center;\">Socionics-based description of Ni type</p>\r\n<p style=\"text-align: left;\"><em>The type of person is determined by the main (dominant) psychic function. All eight functions are present in the psyche of each person, but they have different degrees of development. INTUITION Introverted (Ni) function is the leading function in the Ni types.</em></p>\r\n<p>Creative and deeply intuitive, Ni types are perceptive of underlying, hidden meanings and mystical aspects of life. Having an active imagination they naturally spend hours daydreaming. They are often focused on the past or the future. Time for Ni type people is not fixed, but relative, since it is created by events. The events create their own period of time, unfolding across their own temporal interval. When Ni types look at a situation, they want to know what its implications might be, imagining all the possible scenarios. They often know which way the wind will blow and predict how things will play out or what problems will occur without much data or experience.</p>\r\n<p>Ni types naturally read between the lines and understand the hidden dynamics of the human psyche. They can sometimes \"feel\" your mood, even if you don\'t voice what you\'re feeling or thinking. They have an inner awareness of when people are being authentic or phony and are skilled at sniffing out hidden motives.</p>\r\n<p>Their intuition guides them well, helping them make creative or intellectual leaps other people might not be able to see. “My Intuition leads me where I need to be”. Learning to let go, let things flow, and that nothing can be guaranteed can allow them to change course mid-stream, try new avenues.&nbsp;All thoughts, ideas, and plans, however final they seem, are subject to last-minute changes when “new data” become available.</p>\r\n<p>Ni types get along well in small groups of people where they are likely to share jokes, ideas, whimsical thought, and many inventive theories. They have a strong need for privacy and may feel exhausted by large gatherings. They can sometimes seem chilly and reserved. Many have an inconspicuous look and don’t want to attract attention. They prefer to remain in the background and do not actively look for recognition.&nbsp;Ni type people respect other\'s space, they leave others free to do what they want. They have a \"live and let live\" approach, and are accepting and nonjudgmental of all. What other people do is their business, but Ni types will always take the time to listen to them and offer their thoughts and opinions — but only if asked. They don’t like to waste time on superficial small talk. They are the perfect person to have deep conversations with. They intuitively understand what you\'re going through, they\'re the longtime friends whose shoulder you can sob on without any fear of judgment. They\'ll let you go to the depths of despair, staying by your side the whole time.</p>\r\n<p>Ni types value imagination, and tend to daydream, fantasize, theorize. This process, may go on for hours, days, even weeks. The real world is less interesting to them than the inner landscapes they create for themselves. Developing ideas and drawing plans often seems more exciting, and stimulating to them than actually doing whatever needs to be done.&nbsp;People with this type of personality may lack rootedness in the tangible, physical reality and feel unequipped for the physical world.&nbsp;They may see everyone as stable and normal while feeling that they are sensitive, vulnerable, indecisive, and flawed. They come to believe that they do not possess the internal resources to handle life’s challenges alone, that they are unable to care properly for themselves and physically defend themselves. Ni types are often filled with a nameless anxiety. They imagine scenes of disaster, their imagination races out of control.</p>\r\n<p>They can move forward with confidence if they feel that they have sufficient backup. They realize that people are weak alone, but together they are a great force. Therefore, Ni type people tend to join together with others and seek safety. They create or maintain alliances and associations to achieve a common goal: survival, defense, realization of the idea.</p>\r\n<p>People with this type of personality often are a bundle of opposites. They are both strong and weak, fearful and courageous, defenders and provokers, group people and soloists. Moods carry them from one extreme to another, from childish expectation to depression, from impulsive displays of defiance to dependency, from persistent action to despair, from brilliant conversations to gloomy silences. They can be tough to figure out. These contrasting forces in the nature can make life one perpetual warfare and unrest for Ni type.</p>\r\n<p>Some representatives of the Ni type see themselves as rebellious outsiders. They are fierce protector of the vulnerable and rebel against fundamental injustice.</p>\r\n<p style=\"text-align: center;\">* &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>\r\n<p><strong>° Male portrait </strong>of Ni type<strong>&nbsp;</strong><a href=\"en/8-types/intuition-introverted/90-ni-male-portrait\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p><strong>°&nbsp;</strong>Intuition Introverted type (Ni) in <strong>different typological models</strong> <a href=\"en/8-types/intuition-introverted/87-ni-in-different-typological-models\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p><strong>°&nbsp;</strong>Ni type at different <strong>levels of harmony</strong> <a href=\"en/8-types/levels#ni\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p><em>Last updating 04.03.2025</em></p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '309', '2025-02-23 09:31:03', '309', '2025-12-01 11:15:38', '0', 'en-GB', '1'),
('36', '239', '23', '54', '55', '2', 'typosynthesis/relationships', 'com_content', 'Intertype relationships', 'relationships', '', '<h2 style=\"text-align: center;\"><strong>Intertype relationships</strong></h2>\r\n<p>Kinds of intertype relationships <a href=\"en/relationships/94-kinds-of-intertype-relationships\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p>Comparison of relationships between types <a href=\"en/relationships/92-comparison-of-relationships\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p>Anima/animus as functions of the psyche <a href=\"en/relationships/91-anima-as-function\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p>&nbsp;Typology considers only the typological aspect of relationships. Other factors also influence relationships, such as the partners\' level of development, traumatic experiences, upbringing, culture, and religion.</p>', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '309', '2025-12-22 17:46:45', '309', '2026-01-11 07:22:01', '0', 'en-GB', '1');
/**ABDB**/CREATE TABLE `#__conditions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `category` varchar(50) NOT NULL DEFAULT '',
  `color` varchar(8) DEFAULT NULL,
  `match_all` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `hash` varchar(32) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__conditions`  VALUES 
('1', 'for-module-jd-simple-contact-form', 'For Module: JD Simple Contact Form', '', '', NULL, '0', '1', 'aaf93578984b075d5a82be8935c30b7d', NULL, NULL);
/**ABDB**/CREATE TABLE `#__conditions_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `condition_id` int(10) unsigned NOT NULL,
  `match_all` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `ordering` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `condition_id` (`condition_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__conditions_groups`  VALUES 
('1', '1', '0', '0');
/**ABDB**/CREATE TABLE `#__conditions_map` (
  `condition_id` int(10) unsigned NOT NULL,
  `extension` varchar(50) NOT NULL,
  `item_id` int(10) unsigned NOT NULL,
  `table` varchar(50) NOT NULL,
  `name_column` varchar(50) NOT NULL,
  UNIQUE KEY `condition_id` (`condition_id`,`item_id`,`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__conditions_map`  VALUES 
('1', 'com_advancedmodules', '115', 'modules', 'title');
/**ABDB**/CREATE TABLE `#__conditions_rules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `type` varchar(50) NOT NULL,
  `exclude` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `ordering` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__conditions_rules`  VALUES 
('1', '1', 'menu__menu_item', '0', '{\"selection\":[],\"include_children\":0,\"include_no_itemid\":0}', '0');
/**ABDB**/CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `catid` int(11) NOT NULL DEFAULT 0,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL DEFAULT '',
  `sortname2` varchar(255) NOT NULL DEFAULT '',
  `sortname3` varchar(255) NOT NULL DEFAULT '',
  `language` varchar(7) NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `metakey` text DEFAULT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if contact is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` text DEFAULT NULL,
  `metadesc` text NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content`  VALUES 
('1', '61', 'Home Page', 'home-page', '<div style=\"line-height: 1.3;\">hghf</div>\r\n<div style=\"line-height: 1.3;\"></div>\r\n<div style=\"line-height: 1.3;\">\r\n<p style=\"line-height: 1.3;\"><strong>Type Ni.  </strong>L\'INTUITION introvertie est la plus mystérieuse des huit fonctions psychiques, elle perçoit les images, les symboles et les archétypes qui composent le contenu de l\'inconscient. De ce fait, le TYPE Ni, dans lequel cette fonction est la principale, est surtout enclin à observer son monde intérieur profond et peut ressentir le monde intérieur des autres. Dans son essence profonde, le TYPE Ni est lié à l\'archétype du VOYANT, car il est capable de voir l\'essence de la nature humaine dans sa dynamique et son changement constant et de percevoir le contenu de l\'inconscient collectif. Il peut prédire le développement des événements et le comportement des personnes, voir les principes sous-jacents aux événements et phénomènes, ressentir subtilement le rythme et l\'écoulement du temps, voir la relation des événements dans le temps.</p>\r\n<p></p>\r\n<p><span>🌈 Selon le niveau de développement personnel d\'une personne, son INTUITION résonne avec les couches correspondantes de son monde intérieur : la couche Supérieure (supraconscient) est le monde de l\'amour et de l\'unité cosmiques, des images lumineuses du futur. La couche intermédiaire (émotions et pensées) est un sentiment du monde intérieur des personnes, leurs intentions cachées, sur la base desquelles le comportement humain est prédit dans le futur et les événements sont prédits. La couche inférieure (subconscient, inconscient inférieur) est le monde de l\'expérience passée, non traitée, à la fois individuelle et collective. Ici, une personne est à l\'écoute des scénarios archaïques, du destin, du côté obscur de la psyché humaine, intéressée par la divination.</span></p>\r\n<p><span> </span></p>\r\n</div>\r\n<div style=\"line-height: 1.3;\"></div>\r\n<div style=\"line-height: 1.3;\">It\'s easy to get started creating your website. Knowing some of the basics will help.</div>\r\n<div style=\"line-height: 1.3;\">What is a Content Management System?</div>\r\n<div style=\"line-height: 1.3;\">     A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.</div>\r\n<div style=\"line-height: 1.3;\">In this site, the content is stored in a <em>database</em>. The look and <a href=\"#n1\">feel </a>are created by a <em>template</em>. Joomla! brings together the template and your content to create web pages.</div>\r\n<p style=\"line-height: 1.3;\">Logging in</p>\r\n<div style=\"line-height: 1.3;\"> </div>\r\n<div style=\"line-height: 1.3;\">To login to your site use the user name and password that were created as part of the installation process. Once logged-in you will be able to create and edit articles and modify some settings.</div>\r\n<div style=\"line-height: 1.3;\">Creating an article</div>\r\n<div style=\"line-height: 1.3;\">Once you are logged-in, a new menu will be visible. To create a new article, click on the \"Submit Article\" link on that menu.</div>\r\n<div style=\"line-height: 1.3;\">The new article interface gives you a lot of options, but all you need to do is add a title and put something in the content area. To make it easy to find, set the state to published.</div>\r\n<div style=\"line-height: 1.3;\">You can edit an existing article by clicking on the edit icon (this only displays to users who have the right to edit).</div>\r\n<div style=\"line-height: 1.3;\">Template, site settings, and modules</div>\r\n<div style=\"line-height: 1.3;\">The look and feel of your site is controlled by a template. You can change the site name, background colour, highlights colour and more by editing the template settings. Click the \"Template Settings\" in the user menu.</div>\r\n<div style=\"line-height: 1.3;\">The boxes around the main content of the site are called modules. You can modify modules on the current page by moving your cursor to the module and clicking the edit link. Always be sure to save and close any module you edit.</div>\r\n<div style=\"line-height: 1.3;\">You can change some site settings such as the site name and description by clicking on the \"Site Settings\" link.</div>\r\n<div style=\"line-height: 1.3;\">More advanced options for templates, site settings, modules, and more are available in the site administrator.</div>\r\n<div style=\"line-height: 1.3;\"> </div>\r\n<div style=\"line-height: 1.3;\">{loadmoduleid 115}</div>\r\n<div style=\"line-height: 1.3;\"> </div>\r\n<div style=\"line-height: 1.3;\">Site and Administrator</div>\r\n<div style=\"line-height: 1.3;\">Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see. The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the \"Site Administrator\" link on the \"User Menu\" menu (visible once you login) or by adding /administrator to the end of your domain name. The same user name and password are used for both sites.</div>\r\n<div style=\"line-height: 1.3;\">Learn more</div>\r\n<div style=\"line-height: 1.3;\">There is much more to learn about how to use Joomla! to create the website you envision. You can learn much more at the <a href=\"https://docs.joomla.org/\" target=\"_blank\" rel=\"noopener\">Joomla! documentation site</a> and on the<a href=\"https://forum.joomla.org/\" target=\"_blank\" rel=\"noopener\"> Joomla! forums</a>.</div>\r\n<div style=\"line-height: 1.3;\">----------------------------------------------------------------------------------------------</div>\r\n<div style=\"line-height: 1.3;\">feel feel feel<a id=\"n1\"></a></div>', '', '1', '2', '2022-03-24 11:45:52', '308', '', '2023-02-17 16:17:23', '308', NULL, NULL, '2022-03-24 11:45:52', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"float_intro\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\",\"float_fulltext\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '13', '5', '', '', '1', '427', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('2', '72', 'Instrumental & Orchestral Hits Radio', 'radio-instrumental-orchestral-hits', '<p></p>\r\n<table style=\"width: 500px; margin-left: auto; margin-right: auto;\">\r\n<tbody>\r\n<tr>\r\n<td style=\"width: 500px; text-align: center; vertical-align: top;\">\r\n<p style=\"text-align: center;\">{loadmoduleid 116}</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p> </p>\r\n<p style=\"text-align: center;\"> </p>\r\n<p> </p>', '', '1', '2', '2022-03-26 18:11:50', '308', '', '2023-09-28 14:47:55', '308', NULL, NULL, '2022-03-26 18:11:50', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '29', '3', '', '', '6', '18', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('3', '85', 'Post 1. About Psyholistic Approach to the Human Psyche', 'post-1-about-psyholistic-approach-to-the-human-psyche', '<p><strong>About Psyholistic Approach to the Human Psyche</strong></p>\r\n<p>dsafsfff</p>\r\n<p>{loadmoduleid 123}</p>\r\n<p>sfsafasf</p>\r\n<p>&nbsp;</p>\r\n<p>{loadmoduleid 124}</p>\r\n<p>ssdsd</p>\r\n<p>dsdsf</p>\r\n<p>&nbsp;</p>', '', '1', '13', '2022-03-28 21:33:18', '308', '', '2025-03-08 00:50:55', '308', NULL, NULL, '2022-03-28 21:33:18', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"float_intro\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\",\"float_fulltext\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '9', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('4', '86', 'Post 2. About Typosynthesis as a Synthesis of Typologies', 'post-2-about-typosynthesis-as-a-synthesis-of-typologies', '<p><strong>About Typosynthesis as a Synthesis of Typologies</strong></p>\r\n<p>Enneagrama</p>\r\n<p>Here we show and explain the features of different types of people, study the diversity between them and learn the practical basics of typing.</p>\r\n<p>{loadmoduleid 116}</p>\r\n<p>Here we show and explain the features of different types of people, study the diversity between them and learn the practical basics of typing.</p>\r\n<p></p>', '', '1', '13', '2022-03-28 21:34:44', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-28 21:34:44', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '5', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('5', '90', 'Course 1 Lesson 1', 'course-1-lesson-1', '<p>C1 L1</p>\r\n', '\r\n<p>ggfgf</p>\r\n<p>gfgggf</p>\r\n<p>gfgfggg fgdfgfgfdgtyre</p>\r\n<p>{loadmoduleid 126}</p>\r\n<p>xxcdddg</p>\r\n<p><a href=\"https://jhgjjjk.cvg\" target=\"_blank\" rel=\"noopener\">ffhhhg</a></p>\r\n<p>&nbsp;</p>\r\n<p>{loadmoduleid 125}</p>\r\n<p>&nbsp;</p>\r\n<p>Цілком можна [143] було б вважати смішним, щоб хтось узявся читати лекцію про космічну еволюцію, тому що, звичайно, це предмет, про який ні я, ні будь-який інший смертний нічого не знаємо, і, отже, ми абсолютно не в змозі висловитися з цього приводу. Тим не менш, ми можемо зробити певні висновки за законом аналогії, які можуть привести нас до дуже цікавих сфер думки.</p>\r\n<article>\r\n<p>Протягом кількох тижнів ми розглядали еволюцію атома від стадії до стадії, поки не включили всю Сонячну систему під термін «атом». Спочатку ми вивчали атом речовини, потім ми вивчали атом людини, а пізніше ми застосували те, що знали про обидва ці атоми, до ще більшої сфери, або атома, планети, яку ми назвали планетарним атомом; потім ми поширили цю ідею ще далі на атом сонячної системи, вказавши, що він має місце в ще більшому цілому.</p>\r\n<p>Type&nbsp;Ni.&nbsp;&nbsp;L\'INTUITION introvertie est la plus mystérieuse des huit fonctions&nbsp;psychiques,&nbsp;elle&nbsp;perçoit les images,&nbsp;les symboles et les archétypes qui composent le contenu de l\'inconscient.&nbsp;De ce fait, le TYPE Ni,&nbsp;dans lequel cette fonction est la principale, est surtout enclin à observer son monde intérieur profond et peut ressentir le monde intérieur des autres.&nbsp;Dans son essence profonde, le TYPE&nbsp;Ni est lié à l\'archétype du&nbsp;VOYANT,&nbsp;car il est capable de voir l\'essence de la nature humaine dans sa dynamique et son changement constant et de percevoir le contenu de l\'inconscient collectif.&nbsp;Il peut prédire le développement des événements et le comportement des personnes, voir les principes sous-jacents aux événements et phénomènes, ressentir subtilement le rythme et l\'écoulement du temps, voir la relation des événements dans le temps.</p>\r\n<p style=\"padding-left: 30px;\">It might well be considered ridiculous for anyone to undertake to give a lecture on Cosmic Evolution, because, of course, it is a subject which neither I nor any other mortal knows anything about, and consequently we are utterly unable to express ourselves upon it.&nbsp; Nevertheless, there are certain deductions we can make under the law of analogy which may lead us to very interesting realms of thought.</p>\r\n<p>There is a very interesting analogy between the evolution of the atom and of man (and I presume therefore of the planetary Deity and the solar Logos) in the two methods of unfoldment that are followed.&nbsp; We have seen that the atom has its own atomic life, and that every atom of substance in the solar system is likewise a little system in itself, having a positive centre, or central sun, with the electrons, or the negative aspect, revolving in their orbits around it.&nbsp; Such is the internal life of the atom, its self-centred aspect.&nbsp; We noted too, that the atom is now being studied along a newer line, that of radio-activity, and it is becoming apparent in many cases there is an active radiation going on.&nbsp; Just where this discovery is going to lead it is impossible to tell, for the study of radio-active substances is as yet in its infancy, and little is actually known.&nbsp; Much of the earlier teaching of physical science has been revolutionised by the discovery of radium, and the more scientists find out, the more it becomes apparent (as they themselves realise), that we are standing on the threshold of very great discoveries, and are on the eve of profound revelations.</p>\r\n<p>In the human being, as he evolves and develops, these two stages can equally be seen.&nbsp; There is the early or atomic stage, in which a man’s whole centre of interest lies within himself, within his own sphere, where self-centredness is the law of [123] his being, a necessary protective stage of evolution.&nbsp; He is purely selfish, and concerned primarily with his own affairs.&nbsp; This is succeeded by a later stage, in which a man’s consciousness begins to expand, his interests begin to lie outside his own particular sphere, and the period arrives in which he is feeling for the group to which he belongs.&nbsp; This stage might be viewed as corresponding to that of radio-activity.&nbsp; He is now not only a self-centred life, but he is also beginning to have a definite effect upon his surroundings.&nbsp; He is turning his attention from his own personal selfish life, and is seeking his greater centre.&nbsp; From being simply an atom he is, in his turn, becoming an electron, and coming under the influence of the great central Life which holds him within the sphere of Its influence.</p>\r\n<p>Ми вивчали три методи еволюції, або розвитку, у зв\'язку з цією темою. Ми [144] розглянули аспекти, які розвинулися за допомогою цих атомів, їхні якості або психічну природу, і ми побачили, що в атомі субстанції єдиною психічною якістю, яку ми могли постулювати щодо нього, була якість інтелекту. Потім ми перейшли до атомарних форм, форм недолюдських і побачили, як форми в двох царствах природи, рослинному і тваринному, продемонстрували іншу якість Божества, відчуття, почуття або зародкову любов і емоцію; ми також виявили, що в тваринному світі почала проявлятися третя якість, рудиментарний розум, і що, коли ми прийшли до людського атома, ми продемонстрували три аспекти - інтелект, любов і центральну волю. Ми поширили цю концепцію на планету та Сонячну систему і виявили, що, працюючи через форму Сонячної системи, ми маємо великий Інтелект або Розум; що об’єктом Його використання форми була демонстрація іншої якості: &nbsp;любові чи мудрості, вся істота, наповнена енергією великої центральної ВОЛІ. Звідси ми дійшли висновку, що ця центральна Воля може бути проявом Сутності, Яка інформує всю систему, від найнижчого атома субстанції до того великого Життя, Яке живить планетарну схему.</p>\r\n<p>Виклавши ці основи, ми перейшли до розгляду еволюції [145] свідомого життя в атомній формі, виявивши, що вищий тип свідомості послідовно розвивається кожним атомом; що людська свідомість відрізняється від усіх інших нижчих форм тим, що вона самосвідома; що людина - це розумна воля, яка свідомо виконує кожну дію, усвідомлює своє оточення та виробляє певну лінію діяльності з конкретною метою. Самосвідомість людини знову веде до чогось ще ширшого, до свідомості великого планетарного Духу, який, мабуть, найкраще можна виразити терміном «групова свідомість». У міру еволюції людина переходитиме зі стадії самосвідомості. в якому ми з вами зараз перебуваємо, для усвідомлення того, що мається на увазі під груповою свідомістю, є чимось ще практично невідомим, за винятком якогось прекрасного ідеалу та мрії, яка може в якийсь віддалений час матеріалізуватися. Групова свідомість, знову ж таки, логічно призведе до того, що ми, за браком кращого терміну, могли б назвати свідомістю Бога, хоча я засуджую використання слова Бог через численні суперечки, які воно викликає у світі між різними мислителями людська сім\'я. Ці відмінності в основному засновані на відмінностях у фразеології, на термінах, які використовуються для вираження основних ідей, і на різних методах організації. Коли вчений, наприклад, [146] говорить про силу або енергію, а християнин говорить про Бога, а індуїст використовує терміни, аналогічні «Я є те, що я є», або Я, усі вони говорять про одне. і те саме велике життя, але втратили багато часу, намагаючись довести один одному неправоту та продемонструвати точність власної інтерпретації.</p>\r\n</article>', '1', '12', '2022-03-29 09:40:43', '308', '', '2023-06-19 10:32:32', '308', NULL, NULL, '2022-03-29 09:40:43', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"float_intro\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\",\"float_fulltext\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '23', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('6', '91', 'Course 1 Lesson 2', 'course-1-lesson-2', '<p>C1 L2</p>\r\n', '\r\nsgsgsgdgdggd\r\n{loadmoduleid 135}', '1', '12', '2022-03-29 09:41:24', '308', '', '2023-02-18 10:57:51', '308', NULL, NULL, '2022-03-29 09:41:24', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('7', '92', 'Course 1 Lesson 3', 'course-1-lesson-3', '<p>C1 L3</p>', '', '1', '12', '2022-03-29 11:12:52', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:12:52', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('8', '93', 'Course 1 Lesson 4', 'course-1-lesson-4', '<p>C1 L4</p>', '', '1', '12', '2022-03-29 11:13:36', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:13:36', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('9', '94', 'Course 1 Lesson 5', 'course-1-lesson-5', '<p>C1 L5</p>', '', '1', '12', '2022-03-29 11:14:00', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:14:00', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('10', '95', 'Course 1 Lesson 6', 'course-1-lesson-6', '<p>C1 L6</p>', '', '1', '12', '2022-03-29 11:15:23', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:15:23', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('11', '96', 'Course 1 Lesson 7', 'course-1-lesson-7', '<p>C1 L7 before page break</p>\r\n<hr class=\"system-pagebreak\" />\r\n<p>C1 L7 after page break</p>', '', '1', '12', '2022-03-29 11:16:20', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:16:20', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '2', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('12', '97', 'Course 2 Lesson 1', 'course-2-lesson-1', '<p>C2 L1</p>\r\n<p>fgggfg lklkuiuiuy gijbmbjgv hjghhjkhk khkhjkhk</p>\r\n<p>hjhjk gssggdgdgd&nbsp; hfhghhcbvhcv.</p>\r\n<p>\"Legum servi esse debemus, at liberi esse possimus\".</p>\r\n<p>I should like to outline my plan this evening, to lay the groundwork for our future talks, and to touch upon the main lines of evolution.&nbsp; The line that is most apparent is necessarily that which deals with the evolution of substance, with the study of the atom, and the nature of atomic matter.&nbsp; Next week we will touch upon that.&nbsp; Science has much to tell us about the evolution of the atom, [18] and has wandered a long way during the past fifty years from the standpoint of the last century.&nbsp; А якщо рапрпарар рарар рарарра Then the atom was regarded as an indivisible unit of substance; now it is looked upon as a centre of energy, or electric force.&nbsp; From the evolution of substance we are led very naturally to the evolution of forms, or of congeries of atoms, and there will then open up to us the interesting consideration of forms other than the purely material, – forms existing in subtler substance, such as forms of thought, and the racial forms, and the forms of organisations.&nbsp; In this dual study, one of the aspects of deity will be emphasised, should you choose to use the term \"deity,\" or one of the manifestations of nature, should you prefer that less sectarian expression.</p>\r\n<p>Я хочу окреслити план цієї лекції, закласти основу для наших майбутніх лекцій і торкнутися основних ліній еволюції. Лінія, яка є найбільш очевидною, обов’язково стосується еволюції речовини-субстанції, вивчення атома та природи атомної матерії. В наступній лекції ми торкнемося цього. Наука має багато що розповісти нам про еволюцію атома, і за останні п’ятдесят років вона пройшла довгий шлях від позиції минулого (дев’ятнадцятого) століття. Тоді атом розглядався як неподільна одиниця речовини; тепер на нього дивляться як на центр енергії, або електричної сили. Від еволюції субстанції ми дуже природно переходимо до еволюції форм або скупчень атомів, і тоді нам відкривається цікавий розгляд форм, відмінних від суто матеріальних, – форм, що існують у тоншій субстанції, таких як форми мислення, расові форми, форми організацій. У цьому подвійному дослідженні буде наголошено на одному з аспектів божества, якщо ви вирішите використовувати термін «божество», або на одному з проявів природи, якщо ви надаєте перевагу цьому менш сектантському вислову.</p>\r\n<p>&nbsp;</p>', '', '1', '14', '2022-03-29 11:25:18', '308', '', '2023-02-17 17:24:54', '308', NULL, NULL, '2022-03-29 11:25:18', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"float_intro\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\",\"float_fulltext\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '6', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('13', '98', 'Course 2 Lesson 2', 'course-2-lesson-2', '<p>C2 L2</p>', '', '1', '14', '2022-03-29 11:25:51', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:25:51', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('14', '99', 'Course 2 Lesson 3', 'course-2-lesson-3', '<p>C2 L3</p>', '', '1', '14', '2022-03-29 11:45:18', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:45:18', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('15', '100', 'Course 2 Lesson 4', 'course-2-lesson-4', '<p>C2 L4</p>', '', '1', '14', '2022-03-29 11:53:24', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:53:24', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('16', '101', 'Course 2 Lesson 5', 'course-2-lesson-5', '<p>C2 L5</p>', '', '1', '14', '2022-03-29 11:53:48', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:53:48', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('17', '102', 'Course 2 Lesson 6', 'course-2-lesson-6', '<p>C2 L6</p>', '', '1', '14', '2022-03-29 11:54:34', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:54:34', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('18', '103', 'Course 2 Lesson 7', 'course-2-lesson-7', '<p>C2 L7</p>', '', '1', '14', '2022-03-29 11:54:53', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 11:54:53', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('19', '104', 'Course 3 Lesson 1', 'course-3-lesson-1', '<p>C3 L1</p>', '', '1', '15', '2022-03-29 12:20:43', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 12:20:43', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('20', '105', 'Course 3 Lesson 2', 'course-3-lesson-2', '<p>C3 L2</p>', '', '1', '15', '2022-03-29 12:21:06', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 12:21:06', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('21', '106', 'Course 3 Lesson 3', 'course-3-lesson-3', '<p>C3 L3</p>', '', '1', '15', '2022-03-29 12:21:24', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 12:21:24', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('22', '107', 'Course 3 Lesson 4', 'course-3-lesson-4', '<p>C3 L4</p>', '', '1', '15', '2022-03-29 12:21:46', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 12:21:46', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('23', '108', 'Course 3 Lesson 5', 'course-3-lesson-5', '<p>C3 L5</p>', '', '1', '15', '2022-03-29 12:22:05', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 12:22:05', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('24', '109', 'Course 3 Lesson 6', 'course-3-lesson-6', '<p>C3 L6</p>', '', '1', '15', '2022-03-29 12:22:22', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 12:22:22', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('25', '110', 'Course 3 Lesson 7', 'course-3-lesson-7', '<p>C3 L7</p>', '', '1', '15', '2022-03-29 12:22:39', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 12:22:39', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('26', '114', 'Course 4 Lesson 1', 'course-4-lesson-1', '<p>C4 L1&nbsp;</p>\r\n<p>You can&nbsp;use the CSS text-indent property<span>&nbsp;to indent text in any block container, including divs, headings, asides, articles, blockquotes, and list elements. Say you want to indent all div elements containing text on a page to the right by 50px. Then, using the CSS type selector div, set the text-indent property to 50px.</span></p>\r\n<p>Воля до реалізації.</p>\r\n<p><span>fgdfgfg bfhghgf fjjfjggjgj jfjfjfjfjfjf fjfjfjfjfj jdjdjdjjdj jfjffjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjj dddddddddddddddddddddddddddd dddddddddddd ffffffffffffffff ffffffffffffff rrrrrrrrrrrrrr ttttttttt ggggggggg fffffffffffff gggggggggggggg hhhhhhhhhhhh ssssssssss.</span></p>', '', '1', '16', '2022-03-29 14:23:15', '308', '', '2023-06-19 11:14:41', '308', NULL, NULL, '2022-03-29 14:23:15', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"float_intro\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\",\"float_fulltext\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '5', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('27', '115', 'Course 4 Lesson 2', 'course-4-lesson-2', '<p>C4 L2</p>', '', '1', '16', '2022-03-29 14:23:40', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:23:40', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('28', '116', 'Course 4 Lesson 3', 'course-4-lesson-3', '<p>C4 L3</p>', '', '1', '16', '2022-03-29 14:23:54', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:23:54', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('29', '117', 'Course 4 Lesson 4', 'course-4-lesson-4', '<p>C4 L4</p>', '', '1', '16', '2022-03-29 14:24:07', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:24:07', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('30', '118', 'Course 4 Lesson 5', 'course-4-lesson-5', '<p><img src=\"images/psyholistic/Typosynthesis_Eng.jpg\" alt=\"\" width=\"1500\" height=\"964\" loading=\"lazy\" data-path=\"local-images:/psyholistic/Typosynthesis_Eng.jpg\" /></p>\r\n<p>C4 L5</p>', '', '1', '16', '2022-03-29 14:24:23', '308', '', '2023-06-17 16:33:48', '308', NULL, NULL, '2022-03-29 14:24:23', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"float_intro\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\",\"float_fulltext\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('31', '119', 'Course 4 Lesson 6', 'course-4-lesson-6', '<p>C4 L6</p>', '', '1', '16', '2022-03-29 14:24:35', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:24:35', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('32', '120', 'Course 4 Lesson 7', 'course-4-lesson-7', '<p>C4 L7</p>', '', '1', '16', '2022-03-29 14:24:50', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:24:50', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('33', '121', 'Course 5 Lesson 1', 'course-5-lesson-1', '<p>C5 L1</p>', '', '1', '17', '2022-03-29 14:26:25', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:26:25', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '2', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('34', '122', 'Course 5 Lesson 2', 'course-5-lesson-2', '<p>C5 L2</p>', '', '1', '17', '2022-03-29 14:26:40', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:26:40', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('35', '123', 'Course 5 Lesson 3', 'course-5-lesson-3', '<p>C5 L3</p>', '', '1', '17', '2022-03-29 14:27:45', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:27:45', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('36', '124', 'Course 5 Lesson 4', 'course-5-lesson-4', '<p>C5 L4</p>', '', '1', '17', '2022-03-29 14:28:01', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:28:01', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('37', '125', 'Course 5 Lesson 5', 'course-5-lesson-5', '<p>C5 L5</p>', '', '1', '17', '2022-03-29 14:28:15', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:28:15', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('38', '126', 'Course 5 Lesson 6', 'course-5-lesson-6', '<p>C5 L6</p>', '', '1', '17', '2022-03-29 14:28:28', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:28:28', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('39', '127', 'Course 5 Lesson 7', 'course-5-lesson-7', '<p>C5 L7</p>', '', '1', '17', '2022-03-29 14:28:42', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:28:42', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('40', '128', 'Course 6 Lesson 1', 'course-6-lesson-1', '<p>C6 L1</p>', '', '1', '18', '2022-03-29 14:29:14', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:29:14', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('41', '129', 'Course 6 Lesson 2', 'course-6-lesson-2', '<p>C6 L2</p>', '', '1', '18', '2022-03-29 14:29:30', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:29:30', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('42', '130', 'Course 6 Lesson 3', 'course-6-lesson-3', '<p>C6 L3</p>', '', '1', '18', '2022-03-29 14:29:45', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:29:45', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('43', '131', 'Course 6 Lesson 4', 'course-6-lesson-4', '<p>C6 L4</p>', '', '1', '18', '2022-03-29 14:30:00', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:30:00', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('44', '132', 'Course 6 Lesson 5', 'course-6-lesson-5', '<p>C6 L5</p>', '', '1', '18', '2022-03-29 14:30:17', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:30:17', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('45', '133', 'Course 6 Lesson 6', 'course-6-lesson-6', '<p>C6 L6</p>', '', '1', '18', '2022-03-29 14:30:38', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:30:38', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('46', '134', 'Course 6 Lesson 7', 'course-6-lesson-7', '<p>C6 L7</p>', '', '1', '18', '2022-03-29 14:30:52', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:30:52', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('47', '138', 'Course 7 Lesson 1', 'course-7-lesson-1', '<p>C7 L1</p>', '', '1', '19', '2022-03-29 14:53:31', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:53:31', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '2', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('48', '139', 'Course 7 Lesson 2', 'course-7-lesson-2', '<p>C7 L2</p>', '', '1', '19', '2022-03-29 14:54:10', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:54:10', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('49', '140', 'Course 7 Lesson 3', 'course-7-lesson-3', '<p>C7 L3</p>', '', '1', '19', '2022-03-29 14:55:01', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:55:01', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('50', '141', 'Course 7 Lesson 4', 'course-7-lesson-4', '<p>C7 L4</p>', '', '1', '19', '2022-03-29 14:55:15', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:55:15', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('51', '142', 'Course 7 Lesson 5', 'course-7-lesson-5', '<p>C7 L5</p>', '', '1', '19', '2022-03-29 14:55:29', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:55:29', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('52', '143', 'Course 7 Lesson 6', 'course-7-lesson-6', '<p>C7 L6</p>', '', '1', '19', '2022-03-29 14:55:41', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:55:41', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('53', '144', 'Course 7 Lesson 7', 'course-7-lesson-7', '<p>C7 L7</p>', '', '1', '19', '2022-03-29 14:55:55', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 14:55:55', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('54', '145', 'Course 8 Lesson 1', 'course-8-lesson-1', '<p>C8 L1</p>', '', '1', '20', '2022-03-29 15:15:47', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:15:47', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('55', '146', 'Course 8 Lesson 2', 'course-8-lesson-2', '<p>C8 L2</p>', '', '1', '20', '2022-03-29 15:16:01', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:16:01', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('56', '147', 'Course 8 Lesson 3', 'course-8-lesson-3', '<p>C8 L3</p>', '', '1', '20', '2022-03-29 15:16:17', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:16:17', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('57', '148', 'Course 8 Lesson 4', 'course-8-lesson-4', '<p>C8 L4</p>', '', '1', '20', '2022-03-29 15:16:29', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:16:29', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('58', '149', 'Course 8 Lesson 5', 'course-8-lesson-5', '<p>C8 L5</p>', '', '1', '20', '2022-03-29 15:16:41', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:16:41', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('59', '150', 'Course 8 Lesson 6', 'course-8-lesson-6', '<p>C8 L6</p>', '', '1', '20', '2022-03-29 15:16:53', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:16:53', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('60', '151', 'Course 8 Lesson 7', 'course-8-lesson-7', '<p>C8 L7</p>', '', '1', '20', '2022-03-29 15:17:06', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:17:06', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('61', '152', 'Course 9 Lesson 1', 'course-9-lesson-1', '<p>C9 L1</p>', '', '1', '21', '2022-03-29 15:17:56', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:17:56', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '8', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('62', '153', 'Course 9 Lesson 2', 'course-9-lesson-2', '<p>C9 L2</p>', '', '1', '21', '2022-03-29 15:18:10', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:18:10', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '7', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('63', '154', 'Course 9 Lesson 3', 'course-9-lesson-3', '<p>C9 L3</p>', '', '1', '21', '2022-03-29 15:18:23', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:18:23', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('64', '155', 'Course 9 Lesson 4', 'course-9-lesson-4', '<p>C9 L4</p>', '', '1', '21', '2022-03-29 15:19:33', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:19:33', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('65', '156', 'Course 9 Lesson 5', 'course-9-lesson-5', '<p>C9 L5</p>', '', '1', '21', '2022-03-29 15:19:50', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:19:50', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('66', '157', 'Course 9 Lesson 6', 'course-9-lesson-6', '<p>C9 L6</p>', '', '1', '21', '2022-03-29 15:20:05', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:20:05', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('67', '158', 'Course 9 Lesson 7', 'course-9-lesson-7', '<p>C9 L7</p>', '', '1', '21', '2022-03-29 15:20:22', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:20:22', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('68', '159', 'Course 9 Lesson 8', 'course-9-lesson-8', '<p>C9 L8</p>', '', '1', '21', '2022-03-29 15:20:37', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:20:37', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('69', '160', 'Course 9 Lesson 9', 'course-9-lesson-9', '<p>C9 L9</p>', '', '1', '21', '2022-03-29 15:20:49', '308', '', '2022-04-21 20:08:13', '308', NULL, NULL, '2022-03-29 15:20:49', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', '');/**ABDB**/
/**ABDB**/INSERT INTO `#__content`  VALUES 
('70', '172', 'Blog 3. Intuition Introvertie', 'blog-3-intuition-introvertie', '<p style=\"text-align: center;\">Prototypes et archetypes</p>\r\n<p style=\"text-align: right;\"><em>Traduit par Google Translate d\'ukrainien en français.<span> </span><span>Il est à noter que le texte français </span>a<span> encore </span>besoin de correction<span>.</span> Le texte original ukrainien est ici:<span> </span><a href=\"https://7promeniv.com.ua/typy-i-arkhetypy.html\" target=\"_blank\" rel=\"noopener noreferrer\">7promeniv.com.ua/typy-i-arkhetypy</a></em></p>\r\n<p style=\"text-align: center;\"><span style=\"background-color: #fcfabd;\"><strong> Ni - Intuition Introvertie </strong></span></p>\r\n<p><span></span><strong>Type Ni.  </strong>L\'INTUITION introvertie est la plus mystérieuse des huit fonctions psychiques, elle perçoit les images, les symboles et les archétypes qui composent le contenu de l\'inconscient. De ce fait, le TYPE Ni, dans lequel cette fonction est la principale, est surtout enclin à observer son monde intérieur profond et peut ressentir le monde intérieur des autres. Dans son essence profonde, le TYPE Ni est lié à l\'archétype du VOYANT, car il est capable de voir l\'essence de la nature humaine dans sa dynamique et son changement constant et de percevoir le contenu de l\'inconscient collectif. Il peut prédire le développement des événements et le comportement des personnes, voir les principes sous-jacents aux événements et phénomènes, ressentir subtilement le rythme et l\'écoulement du temps, voir la relation des événements dans le temps.</p>\r\n<p><span>🌈 Selon le niveau de développement personnel d\'une personne, son INTUITION résonne avec les couches correspondantes de son monde intérieur : la couche Supérieure (supraconscient) est le monde de l\'amour et de l\'unité cosmiques, des images lumineuses du futur. La couche intermédiaire (émotions et pensées) est un sentiment du monde intérieur des personnes, leurs intentions cachées, sur la base desquelles le comportement humain est prédit dans le futur et les événements sont prédits. La couche inférieure (subconscient, inconscient inférieur) est le monde de l\'expérience passée, non traitée, à la fois individuelle et collective. Ici, une personne est à l\'écoute des scénarios archaïques, du destin, du côté obscur de la psyché humaine, intéressée par la divination.</span></p>\r\n<p><span>L\'archétype de base contient des sous-archétypes plus petits, qui s\'expriment à travers différentes spécialisations et rôles sociaux :</span></p>\r\n<p><span>🧍 PREVISONNISTE (Clairvoyant, Astrologue) - Prospective. Résout bien les tâches stratégiques. Voit l\'opportunité ou l\'inopportunité des actions humaines et le lancement des projets. Remarque les détails, les nuances subtiles, les évolutions et les tendances générales à peine esquissées. Surveille les changements, prédit l\'évolution de la situation dans le temps, avertit d\'un danger imminent. Sent des offres dangereuses et de la tromperie. 🔮 ⏳</span></p>\r\n<p><span>🧍 MYSTIQUE (Ésotérique, Individualiste) - A une vision particulière des choses. Il voit ce qui est caché aux autres. Ne perçoit pas la forme mais le contenu. Il cherche la profondeur de tout, révèle le sens intérieur des phénomènes et des choses de tous les jours. Il s\'intéresse aux secrets de l\'existence. Il semble être au-dessus du temps : il peut ressentir simultanément le passé, le présent et le futur, des ondes temporelles globales. 🧙 🕯</span></p>\r\n<p><span>🧍 TÉLÉPATHE (Psychologue, Confesseur) - Se connaît bien, est conscient de son état intérieur. Comprend la nature humaine, voit les gens à travers, sans masques ni mensonges, reconnaît rapidement l\'artificialité, les peurs, l\'hypocrisie, la dégradation, les motifs et objectifs cachés. Capable d\'entrer en résonance exacte avec l\'humeur d\'une autre personne. Peut prédire le comportement humain dans un avenir proche. Capable d\'interpréter le sens caché des rêves. Aide les gens à transformer leur douleur en compréhension et en croissance spirituelle, ce qui change la direction de la vie humaine. 🎭✨</span></p>\r\n<p><span>🧍 ARTISTE (Compositeur, Poète, Conteur, Acteur, Magicien, Idéaliste) - Peut transmettre des idées sous forme symbolique. Il peut être un artiste qui choisit parfaitement les couleurs, un compositeur qui crée des œuvres musicales profondes, un écrivain ou un poète, avec un langage brillant, lumineux et juteux, bien que le contenu ne soit pas précis, comporte de nombreuses exagérations et soit souvent pessimiste. Capable de transmettre des aspects subtils de la condition humaine afin qu\'elle soit profonde, belle et touchante. 🎵 ✍️</span></p>\r\n<p><span>💙  </span>EMPATHE. Les empathes sont des personnes hypersensibles à l\'état psychologique des autres. La typologie relie le phénomène d\'empathie à INTUITION<span> </span><span>introvertie </span>en combinaison avec de SENTIMENT. Les personnes ayant une forte intuition introvertie ont tendance à ressentir le monde intérieur des autres : émotions, pensées, expériences, douleur, peurs, motivations cachées. Un intuitif peut se connecter à d\'autres personnes à dessein, à volonté, en séparant clairement ses états des autres. Cependant, si une personne a des limites physiques affaiblies, un manque d\'énergie et aucune \"mise à la terre\", elle est involontairement, à contrecœur, infectée par les conditions d\'autres personnes et peut en souffrir si les conditions environnantes ne sont pas harmonieuses. Ce phénomène peut arriver à une personne de n\'importe quel type psychologique, surtout si la personne n\'a pas d\'objectifs propres et évite la réalisation de soi. Les personnes maigres qui n\'ont pas de barrière physique (corporel) pour se protéger des influences environnementales peuvent également être hypersensibles.</p>\r\n<p>Le monde physique peut sembler aux empathes un lieu rugueux et primitif plein de lutte et de séparation. Le phénomène d\'empathie involontaire est souvent causé par un fort attachement à la perception de sentiments subtils et l\'habitude de se détourner de la réalité matérielle. La nature ne tolère pas le développement unilatéral, lorsque l\'accent est mis uniquement sur le subtil et le spirituel, et que le matériel est rejeté. Pour ceux qui souffrent des effets négatifs des autres, il est utile de développer l\'habitude de se distraire des sensations subtiles et de se concentrer sur leurs actions dans le monde physique et sur leurs sensations corporelles.</p>\r\n<p><span>8️⃣ TYPE Ni (INTUITION INTROVERTIE) peut être exprimé par les archétypes suivants : Voyant, Astrologue, Télépathe, Clairvoyant, Mystique, Ésotérique, Visionnaire, Fidèle, Collaborateur, Intégrateur, Idéaliste, Poète, Rêveur, Magicien, Génie méconnu, Mystère, Individualiste, Individualiste Lâche, Masochiste.</span></p>\r\n<p>Qualités de base du type Ni : SENS DE L\'ÉCOULEMENT DU TEMPS, MONDE INTÉRIEUR, IMAGINATION</p>\r\n<p>Nous décrirons plus en détail les archétypes les plus marquants du type Ni à différents NIVEAUX DE MATURITÉ PSYCHOLOGIQUE.</p>\r\n<p><span>🔸 VOYANT - a un lien fort avec le supraconscient. Montre un <span style=\"font-family: georgia, palatino, serif;\">potentiel </span>spirituel élevé dans la vie quotidienne. Plonge dans les profondeurs de la psyché humaine. Aide les autres à comprendre leur monde intérieur, à se sentir connectés à la nature spirituelle et à trouver sa Source. Comprenant le caractère illusoire du facteur temps, il sent bien les cycles du temps et aide une personne au meilleur moment pour qu\'elle connaisse un certain aspect de sa personnalité.</span></p>\r\n<p><span>🔸 INTÉGRATEUR - ressent ce qu\'il a en commun avec toute l\'humanité, veut l\'unité avec tous. Il est inspiré par la recherche de ce qui unit les gens. Il est capable d\'unir les gens pour atteindre un objectif commun : survie, protection, mise en œuvre du projet, mise en œuvre de l\'idée. Protège l\'intégrité du groupe, maintient l\'unité. Rappelle pourquoi tout est fait. Favorise la perspicacité de groupe, renforçant la conscience collective.</span></p>\r\n<p><span>🔸 FATALIST - pas assez confiant pour agir dans le monde physique. Il peut penser à tout dans son esprit, mais ne commence jamais à le faire. Une forte impulsion extérieure l\'aide à agir. A un désir caché de suivre la forte volonté de quelqu\'un d\'autre. A tendance à s\'en remettre aux autres, au destin, aux circonstances. \"Vous ne fuirez pas le destin.\" Anxieux - exagère les menaces du monde physique, croit qu\'il ne pourra pas y faire face.</span></p>\r\n<p><span>🔸 RÊVEUR - crée dans son imagination une pseudo-réalité, un univers parallèle. Les tableaux que peint son imagination, clairs et lumineux, beaucoup plus attrayant que la vie quotidienne. Peut s\'imaginer presque un magicien, pensant à quel point il est différent des autres, absolument unique. Perd le contact avec le monde extérieur, tombe hors de la réalité, se referme sur lui-même. Il peut être seul pendant longtemps, évitant les gens et la vie quotidienne.</span></p>\r\n<p><span>🔸 </span>VICTIME - obsédé par ses expériences, tombe dans le rôle de victime: dramatise, offense, exagère sa souffrance, fait preuve d\'hypersensibilité, blâme les autres pour ses ennuis. Il se souvient longtemps des <span>rancunes, enclin à la paranoïa: cherche un sens caché dans le comportement et les déclarations des autres, croit que les autres veulent lui faire du mal ou le méprisent. Des événements ou des détails mineurs provoquent chez lui une réaction émotionnelle violente, l\'hystérie. \"Personne ne me comprend.\" Il estime que plus sa souffrance est forte, plus il mérite un traitement spécial.</span></p>\r\n<p><span>🔸 MASOCHISTE - perd son individualité, se dissout dans une autre personne plus forte que lui, complètement soumise à elle afin d\'absorber sa force et ses avantages. Se laisse moquer et humilier. Il aime sa propre humiliation et sa souffrance physique. Obéissance au mal et au péché. Ressent de la haine pour lui-même.</span></p>\r\n<figure class=\"image\"><img src=\"images/psyholistic/Typosynthesis_Eng.jpg\" width=\"300\" height=\"193\" />\r\n<figcaption>Caption</figcaption>\r\n</figure>\r\n<p><span></span></p>', '', '1', '13', '2022-04-29 08:56:21', '309', '', '2023-06-16 21:46:23', '308', NULL, NULL, '2022-04-29 08:56:21', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '15', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('71', '177', 'Psyholistic Approach', 'psyholistic-approach', '<div class=\"ttr_home_html_row0 row\" >\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column00\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br /><h2>Title</h2><br /><p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p></div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear:both;width:0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both;width:0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column01\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br /><h2>Title</h2><br /><p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p></div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear:both;width:0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both;width:0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column02\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br /><h2>Title</h2><br /><p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p></div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear:both;width:0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both;width:0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column03\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br /><h2>Title</h2><br /><p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p></div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear:both;width:0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-lg-block d-xl-block d-lg-block visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both;width:0px;\"></div>\r\n</div>\r\n<div class=\"ttr_home_html_row1 row\" >\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column10\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br /><h2>Title</h2><br /><p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p></div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear:both;width:0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both;width:0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column11\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br /><h2>Title</h2><br /><p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p></div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear:both;width:0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both;width:0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column12\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br /><h2>Title</h2><br /><p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p></div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear:both;width:0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both;width:0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column13\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br /><h2>Title</h2><br /><p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p></div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear:both;width:0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-lg-block d-xl-block d-lg-block visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both;width:0px;\"></div>\r\n</div>\r\n', '', '1', '2', '2022-09-23 10:58:09', '308', 'SuperUser', '2022-09-23 14:16:34', '308', NULL, NULL, '2022-09-23 10:58:09', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"0\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('72', '178', 'About Us', 'about-us', '<div class=\"ttr_about-us_html_row0 row\">\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_about-us_html_column00\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br />\r\n<h2><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Title</span></h2>\r\n<br />\r\n<p><span style=\"font-family: georgia, palatino, serif; font-size: 18px;\">Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</span></p>\r\n<div class=\"sppb-panel sppb-panel-default\">\r\n<p class=\"sppb-panel-heading\" id=\"sppb-ac-heading-1519292503968-key-0\" aria-expanded=\"true\" aria-controls=\"sppb-ac-content-1519292503968-key-0\"><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\"><span class=\"sppb-panel-title\" aria-label=\"Mission\">Mission<i> </i></span>Vision Strategies Projects Values Relationships Actions Results</span></p>\r\n</div>\r\n</div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_about-us_html_column01\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br />\r\n<h2><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Title</span></h2>\r\n<br />\r\n<p><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</span></p>\r\n</div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_about-us_html_column02\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br />\r\n<h2><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Title</span></h2>\r\n<br />\r\n<p><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</span></p>\r\n</div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_about-us_html_column03\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-lg-block d-xl-block d-lg-block visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n<div class=\"ttr_about-us_html_row1 row\">\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_about-us_html_column10\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br />\r\n<h2><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Title</span></h2>\r\n<br />\r\n<p><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</span></p>\r\n</div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_about-us_html_column11\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br />\r\n<h2><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Title</span></h2>\r\n<br />\r\n<p><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</span></p>\r\n</div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_about-us_html_column12\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br />\r\n<h2><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Title</span></h2>\r\n<br />\r\n<p><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</span></p>\r\n</div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_about-us_html_column13\">\r\n<div class=\"margin_collapsetop\"></div>\r\n<div class=\"html_content\"><br />\r\n<h2><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Title</span></h2>\r\n<br />\r\n<p><span style=\"font-size: 18px; font-family: georgia, palatino, serif;\">Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</span></p>\r\n</div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-lg-block d-xl-block d-lg-block visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n</div>', '', '1', '2', '2022-09-23 10:58:09', '308', 'SuperUser', '2022-09-26 19:29:03', '308', NULL, NULL, '2022-09-23 10:58:09', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '8', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('73', '179', 'Contact', 'contact', '<div class=\"ttr_contact_html_row0 row\">\r\n<div class=\"post_column col-xl-5 col-lg-5 col-md-5 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_contact_html_column00\">\r\n<div class=\"html_content\">\r\n<p><span style=\"font-size: 24px;\"><strong><em>Let\'s Get in Touch </em></strong></span></p>\r\n<div style=\"width: 100%;\" xmlns=\"contactformparentdiv\">\r\n<div class=\"contactformdiv\" style=\"margin: 0px 0px 0px 0px;\">{loadmoduleid 130}</div>\r\n</div>\r\n<p style=\"margin: 2px 0px 0px 8px;\"><span style=\"font-size: 24px;\"><strong><em></em></strong></span> </p>\r\n<p style=\"margin: 2px 0px 0px 8px;\"> </p>\r\n<p style=\"margin: 2px 0px 0px 8px;\"><span style=\"font-size: 24px;\"><strong><em>Address</em></strong>:</span></p>\r\n<p style=\"margin: 2px 0px 0px 8px;\"><span style=\"font-size: 18px;\">Lazarenka Street, 5</span></p>\r\n<p style=\"margin: 2px 0px 0px 8px;\"><span style=\"font-size: 18px;\">Lviv,</span></p>\r\n<p style=\"margin: 2px 0px 0px 8px;\"><span style=\"font-size: 18px;\">79000, Ukraine</span></p>\r\n<p style=\"margin: 2px 0px 0px 8px;\"><span style=\"font-size: 18px;\"></span></p>\r\n<p style=\"margin: 2px 0px 0px 8px;\"><span style=\"font-size: 18px;\"><span style=\"font-weight: bold;\">Phone:</span> (800) 123-4567-890</span></p>\r\n<p style=\"margin: 2px 0px 0px 8px;\"><span style=\"font-size: 18px;\"></span></p>\r\n<p style=\"margin: 2px 0px 0px 8px;\"><span style=\"font-size: 18px;\"><span style=\"font-weight: bold;\">We Are Open:</span> Mon-Fri: 10:00 AM - 8:00 PM</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\" visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n<div class=\"post_column col-xl-7 col-lg-7 col-md-7 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_contact_html_column01\">\r\n<div class=\"html_content\"><iframe width=\"600\" height=\"450\" style=\"border: 0;\" src=\"https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d1718.2624860459857!2d24.01663630050772!3d49.81454967077481!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1suk!2sua!4v1663948611833!5m2!1suk!2sua\" allowfullscreen=\"allowfullscreen\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>\r\n<div style=\"width: 100%;\" xmlns=\"contactformparentdiv\">\r\n<div class=\"contactformdiv\" style=\"margin: 0px 0px 0px 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\"margin_collapsetop\"></div>\r\n<div style=\"clear: both; width: 0px;\"></div>\r\n</div>\r\n</div>\r\n<div class=\" visible-lg-block d-xl-block d-lg-block visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\"></div>\r\n</div>', '', '1', '2', '2022-09-23 10:58:09', '308', 'SuperUser', '2023-08-10 14:04:54', '308', NULL, NULL, '2022-09-23 10:58:09', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"float_intro\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\",\"float_fulltext\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '10', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('74', '187', 'dfddfddhdhhdh', 'dfddfddhdhhdh', '<div class=\"ttr_home_html_row0 row\">\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column00\">\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div class=\"html_content\"><br />\r\n<h2>Title</h2>\r\n<br />\r\n<p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p>\r\n</div>\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>\r\n</div>\r\n<div class=\"visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column01\">\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div class=\"html_content\"><br />\r\n<h2>Title</h2>\r\n<br />\r\n<p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.<img src=\"images/psyholistic/Typosynthesis_Eng.jpg\" alt=\"\" width=\"1500\" height=\"964\" loading=\"lazy\" data-path=\"local-images:/psyholistic/Typosynthesis_Eng.jpg\" /></p>\r\n</div>\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>\r\n</div>\r\n<div class=\"visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column02\">\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div class=\"html_content\"><br />\r\n<h2>Title</h2>\r\n<br />\r\n<p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p>\r\n</div>\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>\r\n</div>\r\n<div class=\"visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column03\">\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div class=\"html_content\"><br />\r\n<h2>Title</h2>\r\n<br />\r\n<p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p>\r\n</div>\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>\r\n</div>\r\n<div class=\"visible-lg-block d-xl-block d-lg-block visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>\r\n<div class=\"ttr_home_html_row1 row\">\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column10\">\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div class=\"html_content\"><br />\r\n<h2>Title</h2>\r\n<br />\r\n<p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p>\r\n</div>\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>\r\n</div>\r\n<div class=\"visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column11\">\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div class=\"html_content\"><br />\r\n<h2>Title</h2>\r\n<br />\r\n<p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p>\r\n</div>\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>\r\n</div>\r\n<div class=\"visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column12\">\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div class=\"html_content\"><br />\r\n<h2>Title</h2>\r\n<br />\r\n<p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p>\r\n</div>\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>\r\n</div>\r\n<div class=\"visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n<div class=\"post_column col-xl-3 col-lg-3 col-md-6 col-sm-12 col-xs-12 col-12\">\r\n<div class=\"ttr_home_html_column13\">\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div class=\"html_content\"><br />\r\n<h2>Title</h2>\r\n<br />\r\n<p>Lorem ipsum dolor sit amet, test link adipiscing elit.Nullam dignissim convallis est.Quisque aliquam. Donec faucibus. Nunc iaculis suscipit dui.Nam sit amet sem. Aliquam libero nisi, imperdiet at, tincidunt nec, gravida vehicula, nisl.Praesent mattis, massa quis luctus fermentum, turpis mi volutpat justo, eu volutpat enim diam eget metus.Maecenas ornare tortor.</p>\r\n</div>\r\n<div class=\"margin_collapsetop\">&nbsp;</div>\r\n<div style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>\r\n</div>\r\n<div class=\"visible-lg-block d-xl-block d-lg-block visible-md-block d-md-block visible-sm-block d-sm-block visible-xs-block d-block\" style=\"clear: both; width: 0px;\">&nbsp;</div>\r\n</div>', '', '1', '2', '2022-09-26 18:48:08', '308', '', '2023-06-17 16:29:43', '308', NULL, NULL, '2022-09-26 18:48:08', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '2', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('75', '210', 'ratio-irratio_fr', 'ratio-irratio-fr', '<h2 style=\"text-align: center;\"><strong>APPROCHES PLANIFIÉES ET SPONTANÉES</strong></h2>\r\n<p>Il existe deux approches opposées de la vie : planifiée et spontanée.</p>\r\n<p>Les personnes dominées par une approche <strong><em>planifiée</em></strong> de la vie (Planificateurs) préfèrent un environnement ordonné et structuré avec un certain système de réglementations. Elles sont organisées et cohérentes, s’assurent que tout se passe comme prévu. Elles se sentent à l’aise quand tout est connu d’avance. Leur stratégie est PLANIFICATION ET CONTRÔLE.</p>\r\n<p>Les personnes qui ont une approche essentiellement <strong><em>spontanée</em></strong> de la vie se concentrent sur la perception directe. Elles pensent que la vie est changeante et imprévisible. Elles sont ouvertes à de nouvelles informations et expériences et agissent de manière situationnelle, selon les circonstances. Leur stratégie est d’ÊTRE FLEXIBLE ET DE VIVRE DANS LE FLUX.</p>\r\n<p>Le tableau ci-dessous montre les caractéristiques typiques des deux approches.</p>\r\n', '\r\n<p> <a href=\"images/typo/Fr/ratio_irrac_tabl_color_fr.jpg\" class=\"jcepopup\" data-mediabox=\"1\" data-mediabox-width=\"100%\"><img src=\"images/typo/Fr/ratio_irrac_tabl_color_fr.jpg\" alt=\"\" width=\"450\" style=\"display: block; margin-left: auto; margin-right: auto;\" /></a></p>\r\n<p>Les personnes ayant l’approche <strong><em>planifiée</em></strong> ont tendance à avoir un rythme de vie régulier, aiment avoir un plan pour toutes les occasions. Elles ont des objectifs clairs et les abordent de manière cohérente. Elles peuvent se concentrer sur une tâche pendant longtemps en limitant temporairement les autres besoins et sans être distraits.</p>\r\n<p>Les personnes à l’approche <strong><em>spontanée</em></strong> préfèrent un rythme de vie flexible. Elles ont des projets, mais s’y tiennent rarement. Elles ont du mal à rester concentrées sur une chose pendant longtemps, leur attention passant facilement à de nouvelles informations.</p>\r\n<p>En raison de cette tendance de perception du moment, les personnes ayant une approche <strong><em>spontanée</em></strong> s’adaptent facilement aux situations changeantes et adoptent rapidement de nouvelles idées. Les personnes ayant l’approche <strong><em>planifiée</em></strong> aiment aussi les changements, mais les changements doivent être planifiés. Si les circonstances changent, elles ont besoin de temps pour s’y habituer et réorganiser leurs plans.</p>\r\n<p><em>Exemple. Serge et Isabelle ont décidé d’aller au cinéma. Serge (qui a une approche spontanée) est convaincu que les billets peuvent être achetés sur place. Et s’ils n’y arrivent pas, le plan peut être modifié : regarder un autre film ou aller au café. La vie leur proposera la meilleure option. Cependant, Isabelle (qui a une approche planifiée) est sûre que les billets doivent être achetés à l’avance pour que tout se passe comme prévu.</em></p>\r\n<p>Les types <strong><em>Planificateur</em></strong> ont tendance à être catégoriques dans leurs jugements, à rechercher la clarté et ont un besoin de clôture élevé, en éliminant les informations intermédiaires. Leurs déclarations sont sans ambiguïté : « oui » est « oui », et « non » est « non ». A l’inverse, les types <strong><em>Spontanés</em></strong> aiment garder un choix ouvert, ils évitent les situations fermées et les déclarations catégoriques. Par “oui” ou “non”, ils veulent souvent dire “peut-être”.</p>\r\n<p style=\"text-align: center;\">Attitude envers les règles, les restrictions et les obligations</p>\r\n<p>Les personnes ayant une approche <strong><em>Planifiée</em></strong> apprécient l’ordre et les restrictions raisonnables. Elles ont tendance à respecter les accords, à se conformer facilement aux règles et procédures établies, à les respecter et à s’attendre à ce que les autres fassent de même. Les règles, les lois et l’ordre leur procurent un sentiment de sécurité et de stabilité.</p>\r\n<p>Les personnes ayant une approche <strong><em>Spontanée</em></strong> apprécient le sentiment de liberté et la capacité d’agir spontanément. Elles préfèrent un style de vie flexible sans règle ni restriction. Elles essaient de ne pas se lier avec des obligations et des accords. Le strict respect d’un programme limite leur créativité.</p>\r\n<p>Quelle approche vous correspond le plus ?</p>\r\n<p>Exprimez-vous clairement votre position, évitez-vous l’ambiguïté ? Avez-vous tendance à organiser des activités à l’avance ? Rechignez-vous à changer vos décisions (approche <em>planifiée</em>) ? Ou inversement, agissez-vous sans ressentir le besoin de vous organiser au préalable ? Evitez-vous d’être catégorique ? Vos décisions n’étant pas définitives, car les circonstances peuvent changer (approche <em>spontanée</em>).</p>\r\n<p>Dans les relations, préférez-vous respecter les règles et respecter les accords (approche <em>planifiée</em>) ? Ou essayez-vous de ne pas vous lier avec des obligations et des accords ? Un sentiment de liberté est très important pour vous (approche <em>spontanée</em>).</p>\r\n<p style=\"text-align: center;\">Les avantages et les inconvénients</p>\r\n<p>Voici quelques-uns des avantages et des inconvénients des approches spontanées et planifiées. Ni l’une ni l’autre n’est bonne ou mauvaise. Cela dépend du comportement le plus efficace en fonction de la circonstance.</p>\r\n<p>Les personnes avec l’approche PLANIFIÉE.</p>\r\n<p>Avantages:<br />* Peuvent se concentrer sur un objectif pendant longtemps sans être distraites ;<br />* Ordre de valeur, lois et règles, tendance à se conformer aux accords ;<br />* Cohérentes, systématiques, elles ont tendance à accomplir des tâches ;</p>\r\n<p>Pièges potentiels:<br />* Inflexibles, peuvent devenir stressées si les choses ne se passent pas comme prévu ;<br />* Fixation sur une certaine tâche ou émotion, difficulté à passer d’une chose à une autre ;</p>\r\n<p>Les personnes avec l’approche SPONTANÉE.</p>\r\n<p>Avantages:<br />* Répondent avec souplesse et en temps opportun aux changements ;<br />* S’adaptent facilement aux nouvelles circonstances ;<br />* Restent ouvertes aux nouveautés, ne sont pas limitées par des stéréotypes ;<br />* Créativité, approche non conventionnelle;</p>\r\n<p>Pièges potentiels:<br />* Difficulté à finaliser les choses, incohérence, désorganisation ;<br />* Changent souvent leur point de vue, leurs décisions et leurs promesses. Elles ne pensent pas toujours littéralement ce qu’elles disent.</p>\r\n<p>Bien que nous ayons une tendance naturelle à réagir et à fonctionner de certaines manières, nous pouvons adapter notre approche en fonction de notre expérience et des besoins de la situation.</p>\r\n<p style=\"text-align: center;\"><strong>Rationalité et irrationalité</strong></p>\r\n<p>Les approches planifiées et spontanées sont similaires aux concepts de rationalité et d’irrationalité de Carl Jung. Il a été le premier à diviser tous les types de personnes en deux groupes : les rationnels et les irrationnels.</p>\r\n<p>Dans la population générale, les préférences pour la rationalité et l’irrationalité sont probablement partagées à 50/50.</p>\r\n<p>Beaucoup encore pensent que les femmes sont irrationnelles. Pourtant la répartition des attitudes mentales entre les sexes est égale. Effectivement, environ la moitié des femmes est rationnelle (planificatrice) et l’autre moitié est irrationnelle (spontanée). Il en va de même pour les hommes. Environ la moitié des hommes est rationnelle et l’autre moitié est irrationnelle.</p>\r\n<p>En réalité, la plupart d’entre nous montrent un mélange d’approche planifiée et d’approche spontanée, bien que l’équilibre entre elles puisse varier.</p>\r\n<p style=\"text-align: center;\">Influence de l’environnement</p>\r\n<p>Il convient de noter qu’en plus de la propension innée, la manifestation de la rationalité/irrationalité chez une personne est fortement influencée par son environnement. Par exemple, si une personne est rationnelle et que ses parents sont irrationnels, alors une telle personne montrera certaines tendances acquises à l’irrationalité.</p>\r\n<p>Le type Spontané ou Planificateur d’un pays a également une forte influence sur le comportement humain. Il y a des pays avec une forte prédominance d’une approche rationnelle (planifiée) : Allemagne, Chine, Grande-Bretagne, USA, Pologne, Ukraine. Dans de tels pays, une personne ayant une tendance innée à l’irrationalité aura de nombreux traits rationnels dans son comportement. Inversement, si une personne ayant une tendance innée à la rationalité vit dans des pays comme l’Inde, la Russie ou le Japon, où l’approche irrationnelle (spontanée) prévaut, il peut y avoir de nombreux traits irrationnels dans son comportement.</p>\r\n<p style=\"text-align: center;\"> <strong><span>Conflits et malentendus  </span></strong></p>\r\n<p>En raison de la grande différence d’approche, des conflits et des malentendus peuvent survenir entre les types Planificateurs et Spontanés.</p>\r\n<p>* <u>L’aménagement de la maison</u>. Les types Planificateurs sont plus enclins à organiser l’espace et à suivre certaines règles sur leur territoire. Ils ont un système spécial pour placer les aliments dans le réfrigérateur, la vaisselle sur les étagères, les cintres dans les placards ou les images sur les murs. Ils surveillent l’ordre dans le placement des choses. Les types Spontanés dans la vie quotidienne sont moins structurés. Ils se caractérisent par une plus grande liberté dans l’organisation de l’espace. Ils perçoivent les règles comme des restrictions. Aussi ils ne comprennent pas pourquoi les autres rendent les choses si compliquées en plaçant les choses dans un ordre strict.</p>\r\n<p>* <u>Clarté de la communication</u>. Voici un exemple de malentendus entre l’approche planifiée et spontanée du livre d’Ichak Adizes (<a href=\"#link1\">1</a>).</p>\r\n<p><em>Le mari de type (E) rentre à la maison un soir et dit à sa femme : « Je suis tellement épuisé. Nous avons besoin de vacances.<br />Elle, de type (A), demande: “Tu le penses vraiment?”<br />Il répond : “Oui.”<br />Qu’est-ce qu’un type (A) commencera immédiatement à faire dès qu’il entendra le mot “oui” ? Il va commencer à s’organiser : ont-ils les bons vêtements ? Où est la valise ? Qui va arroser les plantes en leur absence ? Qui va s’occuper du chien ? Il se prépare.<br />Mais son mari rentre à la maison le lendemain soir et dit : “Qu’est-ce que tu fous ?”<br />“Je m’organise pour nos vacances.”<br />“ Qu’est-ce que tu veux dire par vacances ? Tu ne sais pas combien de travail j’ai à faire ? ”<br />“Mais tu as dit ‘oui\'”, répond-elle, étonnée.<br />“Je n’ai pas dit ‘oui’ [le mot commençant en haut et se terminant en bas – ce qui signifie oui]”, dit-il, agacé. J’ai dit “oui” [en commençant par le ton bas et se terminant en haut – ce qui signifie peut-être] !”</em></p>\r\n<p><em>Vous voyez, pour un type (E), un “oui” signifie en fait “pourquoi pas?” Ce n’est pas un vrai “oui!” Mais pour un type (A), il est très difficile de dire “oui” sans s’engager (c’est pratiquement comme donner naissance). Donc s’il dit finalement “oui”, il le pense vraiment.<br />Ce simple malentendu fait que les (A) et les (E) ont du mal à communiquer et à s’entendre. En fait, le (A) décide souvent que le (E) est un menteur, que sa parole n’est pas digne de confiance.</em></p>\r\n<p>A votre avis, lequel a une approche planifiée et lequel a une approche spontanée ?</p>\r\n<p>* <u>Dépenses</u>. Les types Planificateurs ont tendance à faire des achats planifiés, à contrôler les dépenses et à économiser. Les types Spontanés, au contraire, ne sont pas enclins à la planification. Ils aiment saisir les opportunités et ne sont pas enclins à limiter leurs besoins. Il peut sembler au type Planificateur que le type Spontané dépense de l’argent de manière très imprudente. Qu’il ne tient pas de comptabilité des finances et qu’il ne sait pas comment épargner. Et pour le type Spontané, le type Planificateur peut sembler avare, puisqu’il a tendance à garder la sphère financière sous contrôle.</p>\r\n<p>* <u>Activité conjointe</u>. Les types Planificateurs veulent des accords préliminaires. Ils peuvent éprouver des tensions jusqu’à ce que le problème soit résolu et jusqu’à ce que la décision soit prise. Cependant, les Spontanés ne sont pas pressés de faire des promesses car ils ne savent pas comment les circonstances vont évoluer. Ils veulent avoir le libre choix. Les types Spontanés sont agacés par les obligations et l’inflexibilité du partenaire. Les Planificateurs sont agacés par l’irresponsabilité et l’insouciance du partenaire. Il peut être difficile pour un tel couple de s’entendre sur des activités communes.</p>\r\n<p style=\"text-align: center;\">FAIRE FACE AUX CONFLITS</p>\r\n<p>Comment améliorer les interactions avec les types <strong><em>Planificateurs</em></strong>.</p>\r\n<p>* Les <em>Planificateurs</em> ont généralement un plan pour la journée, et si quelque chose d’inattendu, voire d’agréable, se produit soudainement, cela les agace, car cela perturbe leurs plans. Par conséquent, il est préférable d’avertir à l’avance les types Planificateurs des changements, afin qu’ils aient le temps de s’adapter. Les types Planificateurs n’aiment pas que vous vous mettiez d’accord sur quelque chose et que vous le changiez à la dernière minute. Alors essayez de vous en tenir à vos accords.</p>\r\n<p>* Les types <em>Planificateurs</em> sont généralement concentrés sur un objectif ou une tâche et peuvent se mettre en colère s’ils sont distraits dans leur travail.</p>\r\n<p>* Essayez d’exprimer clairement votre position, car les <em>Planificateurs</em> ne tolèrent pas l’incertitude. Ne parlez pas de manière ambiguë ou allégorique, cela leur provoque de la méfiance à votre égard.</p>\r\n<p>…</p>\r\n<p style=\"text-align: right;\"><em>L\'article traduite en français par fred Lacroix de l\'Institut Ennéagramme de Lyon.</em></p>\r\n<p>*     *     *</p>\r\n<p><a id=\"link1\"></a>1 - Adizes, I. (2004). Leading the leaders: how to enrich your style of management and handle people whose style is different from yours. Santa Barbara, CA: Adizes Institute Publications.</p>\r\n<p></p>\r\n<p></p>\r\n<p></p>\r\n<p></p>\r\n<p></p>', '1', '29', '2023-08-15 09:39:49', '309', '', '2023-08-15 10:10:17', '309', NULL, NULL, '2023-08-15 09:39:49', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '10', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'fr-FR', ''),
('76', '211', 'ratio-irratio_en', 'ratio-irratio-en', '<h2 style=\"text-align: center;\"><strong>PLANNED AND SPONTANEOUS APPROACHES</strong></h2>\r\n<p>There are two opposite person’s approaches to life: planned and spontaneous.</p>\r\n<p>People who are dominated by a <em><strong>planned</strong></em> approach to life prefer an orderly, structured environment with a certain system of regulations. They are organized and consistent, make sure that everything goes according to plan, feel at ease when everything is known in advance. Their strategy is PLANNING AND CONTROL.</p>\r\n<p>People who have a predominantly <strong><em>spontaneous</em> </strong>approach to life are focused on direct perception. They believe that life is changeable and unpredictable, are open to new information and experience, act situationally, according to circumstances. Their strategy is to BE FLEXIBLE AND LIVE IN THE FLOW.</p>\r\n<p>The table below shows the typical characteristics of the two approaches.</p>\r\n', '\r\n<p> <a href=\"images/typo/En/ratio_irrac_tabl_color_en.jpg\" class=\"jcepopup\" data-mediabox=\"1\" data-mediabox-width=\"100%\"><img src=\"images/typo/En/ratio_irrac_tabl_color_en.jpg\" alt=\"\" width=\"450\" style=\"display: block; margin-left: auto; margin-right: auto;\" /></a></p>\r\n<p>People with the <strong><em>planned </em></strong>approach tend to have a regular rhythm of life, like to have a plan for all occasions, have clear goals and consistently approach them. They can focus on one task for a long time temporarily limiting other needs and without being distracted.</p>\r\n<p>People with the <strong><em>spontaneous</em> </strong>approach prefer a flexible rhythm of life, can make plans, but rarely stick to them. They do not tend to concentrate on one thing for a long time, their attention easily switches to new information.</p>\r\n<p>Due to the tendency to in-the-moment perception, people with the <strong><em>spontaneous </em></strong>approach easily adapt to changing situations and quickly pick up new ideas. People with the <strong><em>planned </em></strong>approach also like changes, but changes must be planned. If circumstances change, they need time to get used to them and re-arrange their plans.</p>\r\n<p><em>Example. Thomas and Claire decided to go to the cinema. Thomas (who has a spontaneous approach) is convinced that tickets can be purchased at the venue. And if they are not there, the plan can be changed: watch another movie or go to a cafe. Life will throw them the best option. However, Claire (who has a planned approach) is sure that tickets must be purchased in advance so that everything goes according to plan.</em></p>\r\n<p><strong><em>Planning </em></strong>types tend to be categorical in their judgments, strive for clarity and closure, summing up intermediate results. Their statements are unambiguous: “yes” is “yes”, and “no” is “no”.<span> </span><strong><em>Spontaneous</em></strong><span> </span>types like to have an open choice, they avoid closure and categorical statements. By \"yes\" or \"no\" they often mean \"maybe\".</p>\r\n<p>Attitude to rules, restrictions and obligations   </p>\r\n<p>People with the<span> </span><strong><em>planned</em></strong><span> </span>approach value order and reasonable restrictions, tend to keep agreements, easily tune in to established rules and procedures, abide by them, and expect others to do the same. Rules, laws and order provide them with a sense of security and stability.</p>\r\n<p>People with the<span> </span><strong><em>spontaneous</em></strong><span> </span>approach value a sense of freedom and the ability to act spontaneously. They prefer a flexible lifestyle without rules and restrictions, they try not to bind themselves with obligations and agreements. Rigid adherence to the schedule limits their creativity.</p>\r\n<p>What approach is typical for you?</p>\r\n<p>Do you clearly express your position, avoid ambiguity, tend to arrange for activities ahead of time, do not like to change your decisions (<em>planned</em><span> </span>approach)? Or vice versa, do you act without feeling a need to organise beforehand, do you avoid being categorical, your decisions are not final, because circumstances may change (<em>spontaneous</em><span> </span>approach)?</p>\r\n<p>In relationships, do you prefer to play by the rules and stick to agreements (<em>planned</em><span> </span>approach)? Or do you try not to bind yourself with obligations and agreements, a sense of freedom is very important to you (<em>spontaneous</em><span> </span>approach)?</p>\r\n<p>The benefits and pitfalls </p>\r\n<p>These are some of the benefits and pitfalls of the spontaneous and planned approaches. Neither is right or wrong – it depends on what is the most effective behaviour for the circumstances.</p>\r\n<p>People with the PLANNED approach.</p>\r\n<p>Benefits:<br />* Can focus on one goal for a long time without being distracted;<br />* Value order, laws and rules, tend to comply with agreements;<br />* Consistent, systematic, tend to complete tasks;</p>\r\n<p>Potential pitfalls:<br />* Inflexible, may become stressed if things do not go as planned;<br />* Fixation on a certain task or emotion, difficult to switch from one thing to another;</p>\r\n<p>People with the SPONTANEOUS approach.</p>\r\n<p>Benefits:<br />* Respond flexibly and in a timely manner to changes, easily adapt to new circumstances;<br />* Stay open to new things, are not limited by stereotypes;<br />* Creativity, unconventional approach;</p>\r\n<p>Potential pitfalls:<br />* Difficult to complete things, inconsistent, unorganized;<br />* Often change their views, decisions and promises. They don\'t always mean literally what they say.</p>\r\n<p>While we have a natural tendency to respond and operate in certain ways, we can flex our approach depending on our experience and the needs of the situation.</p>\r\n<p style=\"text-align: center;\"><strong>Rationality and irrationality</strong></p>\r\n<p>Planned and spontaneous approaches are similar to the Carl Jung\'s concepts of rationality and irrationality. He was the first to divide all types of people into two groups: Rational and Irrational.</p>\r\n<p>In the general population, preferences for rationality and irrationality are probably split roughly 50/50.</p>\r\n<p>Many believe that women are irrational. Since the distribution of mental attitudes between the sexes is even, roughly half of the women are rational (planning), and half are irrational (spontaneous). The same goes for men. Approximately half of men are rational, and half are irrational.</p>\r\n<p>In reality, most of us show a mixture of both planned approach and spontaneous approach, though the balance between them might vary.</p>\r\n<p>It should be noted that in addition to innate propensity, the manifestation of rationality/irrationality in a person is strongly influenced by his environment. For example, if a person is rational, and his parents are irrational, then such a person will show certain acquired tendencies towards irrationality.</p>\r\n<p>The integral type of nation or country also has a strong influence on human behavior. There are countries with a strong predominance of a rational (planned) approach: Germany, China, Great Britain, USA, Poland, Ukraine. In such countries, a person with an innate tendency to irrationality will have many rational traits in his behavior. Conversely, if a person with an innate tendency to rationality lives in countries such as India, Russia or Japan, in which the irrational (spontaneous) approach prevails, there may be many irrational traits in his behavior.</p>\r\n<p style=\"text-align: center;\"><strong>Conflicts and misunderstandings </strong>   </p>\r\n<p>Due to the big difference in approaches, conflicts and misunderstandings can arise between planning and spontaneous types.</p>\r\n<p>*<span> </span><u>Shared household</u>. Planning types are more inclined to organizing space and following certain rules on the territory. They have a special system for placing food in the refrigerator, dishes on the shelves, hangers in the closets or pictures on the walls, they monitor the order in the placement of things. Spontaneous types in everyday life are less structured, they are characterized by greater freedom in the organization of space, they perceive rules as restrictions. They don\'t understand why others make things so complicated by placing things in a strict order.</p>\r\n<p>*<span> </span><u>Clarity in statements</u>. Here’s an example of misunderstandings between the planned and spontaneous approach from the book of Ichak Adizes (<a href=\"#link1\">1</a>).</p>\r\n<p><em>The (E)-type husband comes home one night and says to his wife, “I’m so exhausted. We need a vacation.”<br />She asks, “Do you really mean it?”<br />He says, “Yes.”<br />What will an (A) immediately start doing, the moment she hears the word<span> </span></em><em>\"yes\"? She\'ll start</em><em><span> </span>organizing: Do they have the right clothes? Where is the suitcase? Who’s going to water the plants in their absence?</em><em> </em><em>Who\'s going to take care of the dog? She\'s getting ready.<br />But her husband comes home the next night and says, \"What on earth are you doing?\"<br />\"I\'m organizing for our vacation.”<br />\"What do you mean, vacation? Don’t you know how much work I have to do?“<br />\"But you said ‘yes’,\" she replies, astonished.<br />\"I did not say \'yes’ [the word starting out pitched high and ending low – meaning yes],” he says, annoyed. I said ‘yes’ [starting out pitched low and ending high – meaning maybe]!”</em></p>\r\n<p><em>You see, for an (E), a “yes” actually means “why not?” It is not a real “yes!”  But for (A), it is very difficult to say \"yes\" - it is practically like giving birth - so if he finally says \"yes”, he really means it.<br />This simple misunderstanding causes (A)s and (E)s to have difficulty communicating and getting along. In fact, the (A) often decides that the (E) is a liar, that his word is not to be trusted.</em></p>\r\n<p>In your opinion, which of the two has a planned approach and which has spontaneous one?</p>\r\n<p>*<span> </span><u>Expenses</u>. Planning types tend to make planned purchases, control expenses, and save. Spontaneous types, on the contrary, are not prone to planning, they like to catch opportunities and are not inclined to limit their needs. It may seem to the planning type that the spontaneous type spends money very recklessly, does not keep accounting of finances, and does not know how to save. And to the spontaneous type, the planning type may seem stingy, since he tends to keep the financial sphere under control.</p>\r\n<p>*<span> </span><u>Joint</u><u><span> </span></u><u>activity</u>. Planning types want preliminary agreements, they may experience tension until the issue is closed and until the decision is made. However, the spontaneous ones are not in a hurry to make promises because they don\'t know how the circumstances will develop, they want to have an open choice. Spontaneous types are annoyed by the obligations and inflexibility of the partner. The planning ones are annoyed by the irresponsibility and carelessness of the partner. It can be difficult for such a couple to agree on joint activities.</p>\r\n<p>Here’s an example of misunderstandings in international business environment from the book of Richard D. Lewis <span>(<a href=\"#link2\">2</a>).</span></p>\r\n<p><em>The word contract translates easily from language to language, but it has many interpretations. To a Swiss, Scandinavian, American or Brit, a contract is a formal document that has been signed and should be adhered to. Signatures give it a sense of finality. But a Japanese businessperson regards a contract as a starting document to be rewritten and modified as circumstances require… The American calls the Japanese unethical if the latter breaks a contract. The Japanese says it is unethical for the American to apply the terms of the contract if things have changed. </em></p>\r\n<p style=\"text-align: center;\">DEALING WITH CONFLICT</p>\r\n<p>How to improve interactions with<span> </span><strong><em>planning</em></strong><span> </span>types.</p>\r\n<p>*<span> </span><em>Planning</em><span> </span>types usually have a plan for the day, and if something unexpected, even pleasant, suddenly happens, it annoys them, because it disrupts their plans. Therefore, it is better to warn planning types about changes in advance, so they have time to adjust.<span> </span><em>Planning</em><span> </span>types don\'t like it if you agree on something and then change it at the last minute, so try to stick to your agreements.</p>\r\n<p>*<span> </span><em>Planning</em><span> </span>types are usually focused on some goal or some task, and can get angry if they are distracted from their work.</p>\r\n<p>* Try to express your position clearly, because<span> </span><em>planning</em><span> </span>types do not tolerate uncertainty. Do not speak ambiguously or allegorically, it causes distrust in them.</p>\r\n<p>...</p>\r\n<p>*     *     *</p>\r\n<p><a id=\"link1\"></a>1 - Adizes, I. (2004). Leading the leaders: how to enrich your style of management and handle people whose style is different from yours. Santa Barbara, CA: Adizes Institute Publications.</p>\r\n<p><a id=\"link2\"></a>2 – Richard D. Lewis. When Cultures Collide: Managing successfully across cultures. Different Languages, Different Worlds. London 1996. Copyright Richard D Lewis. <a href=\"http://www.crossculture.com\" target=\"_blank\" rel=\"noopener\">www.crossculture.com</a></p>\r\n<p>*     *     *</p>\r\n<p style=\"text-align: center;\"> Correlation between <strong>ENNEAGRAM</strong> and <strong>JUNGIAN</strong> TYPOLOGY: let\'s explore together</p>\r\n<p style=\"text-align: center;\">Poll: Are you more planned or spontaneous?</p>\r\n<p>After reading the article, you could indicate your approach (planned or spontaneous) and indicate your Enneagram type in the poll here <a href=\"https://app.questionnaireweb.com/form/166762/s/?id=JTlBbiU5NW4lOTclQjA%3D&amp;a=JTk1byU5N28lOUMlQUI%3D\" target=\"_blank\" rel=\"noopener\">https://app.questionnaireweb.com/form/166762/</a></p>\r\n<p></p>\r\n<p><em>Last updating </em><em>31.</em><em>10.202</em><em>3</em></p>', '1', '25', '2023-08-15 10:19:28', '309', '', '2023-10-31 12:13:23', '309', NULL, NULL, '2023-08-15 10:19:28', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '23', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('77', '214', 'contact fr', 'contact-fr', '<h1 style=\"text-align: center;\"><strong>Contacts</strong></h1>\r\n<p>Ukraine, Lviv</p>\r\n<p><span>email: </span>typology7rays ( @ ) outlook.com</p>\r\n<p>Facebook -<span> </span><a href=\"https://www.facebook.com/typosynthesefr/\" target=\"_blank\" rel=\"noopener noreferrer\">www.facebook.com/typosynthesefr</a></p>\r\n<p><strong>Qui sommes-nous ?</strong></p>\r\n<p><span>Andriy Zabava - psychologue, consultant</span></p>\r\n<p>Angélique Zabava - <span>consultante en typologie</span></p>', '', '1', '27', '2023-12-03 08:37:44', '309', '', '2023-12-10 09:36:35', '309', NULL, NULL, '2023-12-03 08:37:44', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '7', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'fr-FR', ''),
('78', '215', 'contact en', 'contact-en', '<h2 style=\"text-align: center;\"><strong>Contact</strong></h2>\r\n<p>Ukraine, Lviv</p>\r\n<p><span>email:&nbsp;</span>typology7rays (&nbsp;@ ) outlook.com</p>\r\n<p>Instagram - <a href=\"https://www.instagram.com/typosynthesis/\" target=\"_blank\" rel=\"noopener\">www.instagram.com/typosynthesis/</a></p>\r\n<p>Facebook -<span>&nbsp;</span><a href=\"https://www.facebook.com/typosenglish\" target=\"_blank\" rel=\"noopener noreferrer\">www.facebook.com/typosenglish</a></p>\r\n<p><strong>About Us</strong></p>\r\n<p>Andrii Zabava</p>\r\n<p>Anzhelika Zabava - researcher and consultant in personal developing from Lviv, Ukraine. In 2003, she received a certificate of Specialist in Psychiatry from Lviv Medical University. She uses different approaches in her work: Psychosynthesis, Typology, NLP. Her work is focused on enabling people to discover their deep resources and to walk the path of personal change. Anzhelika spent several years working as Socionics Master Practitioner. She is co-founder of Typosynthesis approach.</p>\r\n<p><img src=\"images/typo/karetnuy_dvir_2024-05.jpg\" alt=\"karetnuy dvir 2024 05\" width=\"400\" style=\"display: block; margin-left: auto; margin-right: auto;\" /></p>', '', '1', '23', '2023-12-03 09:19:16', '309', '', '2024-12-01 12:32:48', '309', NULL, NULL, '2023-12-03 09:19:16', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '9', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('79', '216', 'Dualities in Jungian typology', 'dualities-in-jungian-typology', '<h1 style=\"text-align: center;\"><img src=\"images/typo/8_funkciy_kvitka_main.jpg\" alt=\"\" width=\"170\" style=\"float: left;\">DUALITIES IN JUNGIAN TYPOLOGY  </h1>\r\n<p>The world is built on universal dualities or pairs of opposites: light - darkness, heat - cold, male - female, creation - destruction, active - passive, up - down, etc. Human nature is such that from any integral phenomenon he can perceive only one pole of it. Only after experiencing the two poles of duality can a person realize the integrity of a certain phenomenon and advance in his development. A person can realize that light and darkness are parts of one whole, that there is no struggle or conflict between them.</p>\r\n<p>Universal dualities in everyday life are experienced by the human psyche as psychological states and attitudes, such as “aggressor-victim”, “euphoria-depression”, “greatness-insignificance”, “good-evil”, “material-spiritual”, etc.</p>\r\n', '\r\n<p style=\"text-align: center;\">Jungian typology is also built on dualities, it is based on the following pairs of opposites: <br>Feeling - Thinking, <br>Sensation - Intuition, <br>Rationality - Irrationality, <br>Extraversion - Introversion.</p>\r\n<p>The key element of the Jungian typology is the four psychical functions: Sensation, Feeling, Thinking, and Intuition, and we might also call them four types of intelligence.</p>\r\n<p><strong>Four intelligences</strong> – <strong>four psychical functions</strong>:<br>• PHYSICAL (or BODY) intelligence – function SENSATION;<br>• MENTAL intelligence – function THINKING;<br>• EMOTIONAL intelligence – function FEELING (or EMOTIONS);<br>• SPIRITUAL intelligence – function INTUITION. The Jungian function of Intuition has much in common with descriptions of Spiritual intelligence.</p>\r\n<p>• People with predominant <strong>SENSATION </strong>function are well versed in the physical (material) sphere of life, are inclined to interact with physical objects, and are able to work with their hands (making things). They easily identify their own bodily sensations, are tuned to perceive visual-spatial-kinesthetic information (movement, force, external appearance of objects, physical health, physical beauty, color, consistency, taste, temperature, etc.) and are well oriented in space.</p>\r\n<p>• People with the predominant function of <strong>FEELING </strong>(or emotions) are well oriented in the interpersonal sphere, are versed in relationships, in sympathies and antipathies between people, easily identify their own emotional state and the state of others, are attuned to communication with others. They are inclined to evaluate people and their behavior according to the criteria of \"good - bad\", \"like - dislike\" (acceptance or rejection).</p>\r\n<p>• People who have a predominant function of <strong>THINKING </strong>are well versed in in the sphere of thought, logic, objective facts and patterns, are tuned to intellectual knowledge of objects, analysis, establishment of regularities and cause-effect relationships. They have a clear idea of their goals and know how to prioritize. They are distinguished by precise formulations and attraction to facts and evidence.</p>\r\n<p>• People with predominant function of <strong>INTUITION </strong>are well versed in the world of ideas, inner meanings of objects, trends, perspectives, unmanifested potentialities, they feel time cycles, the flow of time, the past and the future, the interconnectedness of all things. They have a developed imagination, are perceptive, insightful, inclined to reveal the hidden, are able to perceive the content of the collective and individual unconscious.</p>\r\n<p><img src=\"images/typo/4_fymkcii_kolo.jpg\" alt=\"\" width=\"250\" style=\"float: right;\"></p>\r\n<p>In Jung\'s model of typology, the four psychical functions are represented as <strong>dualities</strong>: SENSATION is opposite to INTUITION, and FEELING is opposite to THINKING.</p>\r\n<p>These dualities are not just opposites, they are complementary and interdependent. Just as without light there is no shadow, so without Intuition there is no Sensation, and without Thinking there is no Feeling. Changes in one function cause changes in the opposite function and vice versa.</p>\r\n<p>Besides, these two pairs of functions are characterized by different parameters. The pair Sensation - Intuition are irrational functions, while the pair Feeling - Thinking are rational.</p>\r\n<p><em>It is worth noting that the Jungian term \"rationality\" is identical to planning, and the term \"irrationality\" is identical to spontaneous. More on this here <a href=\"psyholistic.top/en/4-styles/76-ratio-irratio-en\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></p>\r\n<p>Another basic parameter in Jung’s typology is the <strong>duality EXTRAVERSION - INTROVERSION</strong>.</p>\r\n<p>Carl Jung found that any of the four basic psychic functions can have introverted or extraverted orientation depending on the direction of a person\'s attention: to external objects or inward. Accordingly, each of the four functions has two variants: extraverted and introverted, and together there are eight psychic functions: 4 introverted and 4 extraverted.</p>\r\n<p><img src=\"images/typo/8_funkciy_kvitka.jpg\" alt=\"\" width=\"250\" style=\"float: right;\"><br>• Sensation Extraverted - Se <br>• Sensation Introverted – Si<br>• Feeling Extraverted - Fe<br>• Feeling Introverted – Fi<br>• Thinking Extraverted - Te<br>• Thinking Introverted - Ti<br>• Intuition Extraverted – Ne<br>• Intuition Introverted – Ni</p>\r\n<p>Extraversion - Introversion are widely used terms, but far from what Carl Jung meant by them. Jungian Extraversion - Introversion is not the same as gregarious - reserved. An introvert can be more sociable than an extrovert. In addition, there are 4 types of introverts and 4 types of extroverts, each with their own characteristics.</p>\r\n<p><strong>All eight functions are present in the psyche of each person, but they have different degrees of development. One of the functions always surpasses the others in strength, speed of reaction and meaningfulness of this reaction. It is called the main one.</strong></p>\r\n<p>Carl Jung wrote: <em>“Just as a lion strikes down his enemy or his prey with his fore-paw, in which his strength resides, and not with his tail like the crocodile, so our habitual reactions are normally characterized by the application of our most trustworthy and efficient <strong>function</strong>; it is an expression of our strength. However, this does not prevent our reacting occasionally in a way that reveals our specific weakness. The predominance of a <strong>function</strong> leads us to construct or to seek out certain situations while we avoid others, and therefore to have experiences that are peculiar to us and different from those of other people. An intelligent man will make his adaptation to the world through his intelligence, and not in the manner of a sixth-rate pugilist, even though now and then, in a fit of rage, he may make use of his fists. In the struggle for existence and adaptation everyone instinctively uses his most developed <strong>function</strong>, which thus becomes the criterion of his habitual reactions.”</em> (<a href=\"#jung\">1</a>)</p>\r\n<p><strong>The type of person is determined by the main psychic function. </strong>If the main (dominant) function is Sensation Extraverted, then the type is called Sensing Extraverted (Se), if the main function is Feeling Introverted, then the type is called Feeling Introverted (Fi), etc.</p>\r\n<p>The basic elements of Jung\'s typology are eight psychological types. They are innate and do not change during life.</p>\r\n<p style=\"text-align: center; text-indent: 1px;\"><img src=\"images/typo/8_prototypes_kvitka.jpg\" alt=\"\" width=\"500\" style=\"display: block; margin-left: auto; margin-right: auto;\"></p>\r\n<p style=\"text-indent: 1px; text-align: left;\">Each psychotype can have both strengths and weaknesses.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\">* The strong side of the <strong>Se</strong> type is courage, determination, the ability to physically confront opponents and take the lead of others in critical situations. The weak side is the impulsiveness of actions without thinking the consequences through.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\">* The strong side of <strong>Si</strong> type is the ability to create physical comfort and coziness, care for good health, reconciliation of conflicting parties. The weak side is inertia, avoidance of discomfort and psychological tension.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\">* The strong side of <strong>Fe</strong> type is feeling the emotional state of others, ability to establish emotional connection with others, to provide emotional support, to inspire. The weak side is hyperbolization of feelings and their contradiction.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\">* The strong side of <strong>Fi</strong> type is empathy, ordering a huge amount of connections, establishing rules of communication and moral standards. The weak side is conservatism and condemnation of those who do not share his or her values.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\">* The strong side of <strong>Te</strong> type is the ability to manage resources and find effective ways to achieve practical results, introduction of new technologies. The weakness is that the achievement of goals is more important than relations with people, as well as the focus on quick results.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\">* The strong side of <strong>Ti</strong> type is the ability to analyze, get to the bottom of problems, establish cause and effect relationships, find patterns and create systems. The weakness is the rejection of facts that may violate one’s theory/concept, as well as emotional coldness and detachment.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\">* The strong side of <strong>Ne</strong> type is inventiveness, the ability to find a way out of different situations, the capacity to see potential opportunities and the interconnectedness of all things. The weak side is excessive fantasizing, changeability and impracticality.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\">* The strong side of <strong>Ni</strong> type is the feeling of the hidden, unconscious, the inner state of others, the flow of time, premonition and foresight of the development of events. The weak side is unwillingness to act, uncertainty, over-sensitivity.</p>\r\n<p style=\"text-indent: 1px; text-align: left;\">Once we have learned to discern the qualities of a type and know which qualities in us are stronger and which are weaker, then we can try to develop stronger ones and work on what\'s hindering us.</p>\r\n<p style=\"text-align: center;\"><em>*       *       *       *        *       </em></p>\r\n<p style=\"text-align: left;\"><a id=\"jung\"></a>1 - A lecture delivered at the Congress of Swiss Psychiatrists, Zurich, 1928, and published as “Psychologische Typologie” in Seelenprobleme der Gegenwart (Zurich, 1931)</p>\r\n<p style=\"text-align: left;\"><em>Last updating 20.04.2024</em></p>\r\n<p style=\"text-align: right;\"><em>Original text in Ukrainian here<span> </span><a href=\"https://7promeniv.com.ua/korotki-opysy-typiv/3050-dualnosti-u-typolohii-yunha.html\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></p>', '1', '26', '2024-04-01 09:45:58', '309', '', '2026-01-15 11:31:37', '308', NULL, NULL, '2024-04-01 09:45:58', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"float_intro\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\",\"float_fulltext\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '31', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('80', '218', 'Se in different typological models', 'se-in-different-typological-models', '<h2 style=\"text-align: center;\"><strong>SENSATION EXTRAVERTED TYPE - SE - IN DIFFERENT TYPOLOGICAL MODELS</strong></h2>\r\n<p><span>Descriptions of the Sensation Extraverted Type can be found under different names in different typological models:<br /><strong>•&nbsp;</strong>Choleric temperament&nbsp;(according to some authors) <br /><strong>•&nbsp;</strong><a href=\"#mars\">Mars</a> - planetary typology<br /></span><span><strong>• </strong><a href=\"#keirsey\">Artisans</a> – David Keirsey<br /><strong>• </strong><a href=\"#arche\">Warrior</a>, Amazon, Queen – female archetypes<br /><strong>•&nbsp;</strong>Type 8 – Enneagram<br /><strong>•&nbsp;</strong><a href=\"#jung\">Type Se</a> – Carl Jung</span></p>\r\n<p><strong>✅&nbsp;</strong><strong>Choleric temperament</strong>&nbsp;</p>\r\n<p><strong>•&nbsp;Choleric temperament by Rev Bowen – Waldorf pedagogy</strong><span>&nbsp;</span>- Simply&nbsp;Waldorf&nbsp;<a href=\"https://www.simplywaldorf.com/post/the-waldorf-temperaments\" target=\"_blank\" rel=\"noopener\">www.simplywaldorf.com</a></p>\r\n<p>With a fiery will, the choleric temperament wants to take charge of situations and to lead groups toward a goal--that \"goal\" being the choleric\'s vision or solution. It does not need to hear everyone else\'s ideas. It does not need to spend time away from the world in contemplation. It is aimed at action and once it has seen a goal, whether it is a tug-of-war game or to summit Denali, it sets all its efforts an achieving it and will doggedly adhere to this goal, persevering through great hardships if needed. After all, such challenges only reveal the great power and virtue of such a being. The choleric temperament will speak its mind, sometimes with painful and unsympathetic candor. It will not even consider backing down from confrontations, and sometimes seeks them with relish. The choleric finishes every task, usually as fast as possible. Was it the wisest course of action? The choleric does not take the time to consider this for there are now other tasks and the choleric struggles when idle. It feels that time is lost, that one is only worth what one does.&nbsp;</p>\r\n', '\r\n<p>Much of this picture above is an immature version.&nbsp;</p>\r\n<p>The mature choleric is a true leader. It sees the vision, and even allows for input and buy-in from the group. It allows time for contemplation so that we work \"smarter not harder\", but it does not allow for contemplations to lead to inactivity. It does not allow for the group process to supersede the need to actually accomplish the goals at hand. The choleric can pull others along and indeed blaze the path. It never sees obstacles, only the next challenge. It relishes the idea that there are things to be overcome. It sees that when we face obstacles together, we not only become stronger individually, but as a community. The choleric, fully matured, puts all of its fiery power and will into service, balanced between self and others. This is the one who would not let you give up on some dream. This is the one who volunteers at the community soup kitchen.&nbsp;</p>\r\n<p><strong>• Choleric temperament by Rebecca Altman&nbsp;&nbsp;</strong><a href=\"https://wonderbotanica.com/library/on-fire\" target=\"_blank\" rel=\"noopener\">wonderbotanica.com</a></p>\r\n<p>Cholerics move forward facing everything in their path with a passion, bravery and intensity that ignites the world around them. Cholerics can be combative. They love a challenge and to push forwards against resistance. When they meet it, they get to summon that inner fire to push through it, and it is when they feel this fire that they feel the most alive… To those who are not choleric, this constant pushing can feel aggressive.&nbsp;</p>\r\n<p>Where others spend time researching, make sure that all the pieces are in place before embarking on something new, cholerics start first and figure it out later… they need to be doing something, a project, always, or they will languish…&nbsp; Cholerics do not do very well with being still for long periods of time, and often need a lot of physical activity, as well as to be progressing towards things... Holding a choleric back from their course, stopping them moving, they start to self-combust from within… Picture a cheetah with its prey in sight, as it bends its legs to launch itself forwards, and then someone slaps a leash on it so that it can’t release all that energy.</p>\r\n<p>In balance:&nbsp;<br />-The in balance choleric is enthusiastic and driven. Inspiring to those around them, and generally helping to move projects forward.&nbsp;<br />-Incredibly encouraging, if you take an idea to them they’ll help you run with it, provide feedback and ideas to help make it better.<br />Out of balance:&nbsp;<br />-Will become extremely combative in arguments.&nbsp;<br />-Can be incredibly bossy.<br />-The need to be doing something can get out of control, instead of taking necessary down-time in between projects, the imbalanced choleric will constantly be working towards bigger and bigger things.</p>\r\n<p style=\"text-align: center;\">* &nbsp; &nbsp; * &nbsp; &nbsp; *</p>\r\n<p><span><strong><a id=\"mars\"></a>✅ Mars - planetary typology</strong> - anthroposophical view &nbsp;<a href=\"https://busbi.home.xs4all.nl/mars.html#mars\" target=\"_blank\" rel=\"noopener\">busbi.home.xs4all.nl</a></span></p>\r\n<p><span>Mars is obviously as strong as an oak in his will power. He is a fighter and will fight for his ideas either physically or verbally. You can picture the past with hordes of Mongols hurtling across the plains wildly overrunning all opposition. Energy in times of peace must be used to construct something with. Mars is a builder, dynamic, mobile, enthusiastic. He looks for projects and throws himself into them completely. He does not understand when others do not work with the same unrelenting fire. With his enthusiasm he often gets people to do things they did not know they could do.<br />Problems are made to be solved. Because Mars is a short term thinker he solves problems in the present and near future. There are too many things to be done right now. The future can take care of itself. Philosophers are daydreamers to him; they do nothing practical. </span></p>\r\n<p><span>His feelings can change quickly according to mood. He is straight-forward and impulsive. Quick to fury, quickly back to working with enthusiasm - like on the planet Mars there are sudden ferocious sandstorms which end as quickly.</span></p>\r\n<p style=\"text-align: center;\"><span>* &nbsp; &nbsp; * &nbsp; &nbsp; *</span></p>\r\n<p><span><strong><a id=\"keirsey\"></a>✅ Artisans – David Keirsey</strong> <strong>\"Please Understand Me II\", </strong>1998.</span></p>\r\n<p><span>Artisans see themselves, and wish to be seen by others, as bold, daring, venturesome — audacious… They need to be potent, to be felt as a strong presence, and they want to affect the course of events. Artisans hunger to have a piece of the action, to make a splash, to make something happen, to hit the big time, whether in the world of art or corporate business, on the battlefield or ball field, on stage or in the political arena. This is why so many professional politicians are Artisans: the world of politics allows not only for maneuvering, excitement, and risk — but for powerful social impact.&nbsp;</span></p>\r\n<p><span>Artisans do not care to take tickets at the gate, or sit in the bleachers, or referee the game. They must be in the game, at the very center of things where the action is… To an Artisan, there\'s no time like the present, so we\'d better make the most of it, better seize the day, strike while the iron is hot… Oblivious to the past and the future, they can concentrate all their powers on a clear and present opportunity… However, there\'s a price to pay for living so intently in the moment. Since Artisans do not reflect very much on their errors or analyze their mistakes to any great extent.</span></p>\r\n<p><span>Of all the styles Artisans are best able to respond quickly and flexibly to a changing environment… This is why Artisans work so well in a crisis; new situations demand new actions, and earlier commitments often have to be abandoned — with regret, perhaps, but still abandoned. Today is today, and yesterday\'s arrangements must give way in the face of more urgent demands.</span></p>\r\n<p><span>Artisans spend a good deal of their time seeking stimulation because they need it. As much as possible, they live in their five senses, and they seem to like their music a little louder than the other types, their clothes a little more colorful, and their food and drink a little stronger.</span></p>\r\n<p><span>Artisans are impulsive. They like being that way. To be impulsive, spontaneous, is to be really alive... Artisans are the world\'s great risk-takers... Action cannot be saved for tomorrow. For Artisans, to wait is psychological death, no matter how dangerous the action... Artisans, of all the types, are most likely to answer the call to wander, and they can sever social or family ties more easily than others. The Artisan can abruptly abandon either an activity or a relationship, walking away without a backward glance.</span></p>\r\n<p style=\"text-align: center;\"><span>* &nbsp; &nbsp; * &nbsp; &nbsp; *</span></p>\r\n<p><span><strong><a id=\"arche\"></a>✅ Warrior, Amazon, Queen – female archetypes</strong></span></p>\r\n<p><span><strong>• The Warrior - female archetype by Chantelle Raven&nbsp;</strong><a href=\"https://embodiedawakeningacademy.com/the-feminine-archetypal-wheel/\" target=\"_blank\" rel=\"noopener\">embodiedawakeningacademy.com</a></span></p>\r\n<p><span>The Warrior Woman archetype is independent and self-contained and highly capable of making her way in the world. She is focused, ambitious, assertive, goal-oriented and self-sufficient. She relates to the men in her life as companions, co-workers and allies. Whilst tribe and community are important to her, she is also quite content to be on her own. She will always gravitate towards professions that enable her to be autonomous and not have to answer to anyone. She seeks her own counsel, often dedicating her life to a cause that she is very passionate about. She is grounded and connected to her own source of power. She claims her space in the world with confidence and with an air of sovereignty, trusting herself completely. Her no’s are honored with the same ease as her yes’s. She does not need to explain herself nor does she complain. She is not interested in being a people pleaser or a victim. She does not need a man, she is whole unto herself yet she welcomes those who serve an authentic purpose in her life. She can take care of herself physically.<br />She will not stand for anyone putting her down, disrespecting her or her loved ones, humiliating her or trying to make her subservient.<br />Warrior Dark Shadow: &nbsp;intimidating, critical, judgmental toward weakness in others, quick to anger, bossy. She can also keep others at an emotional distance with her powerful air of authority.<br />Warrior Wound: Her heart. Her strong masculine can conceal her vulnerability and make it difficult for her to be in her feminine.</span></p>\r\n<p style=\"text-align: center;\">* &nbsp; &nbsp; * &nbsp; &nbsp; *</p>\r\n<p><strong><a id=\"jung\"></a>✅ Type Sensation Extraverted – Carl Gustav Jung \"Psychological Types\", </strong>1921.</p>\r\n<p>No other human type can equal the extraverted sensation-type in realism… His life is an accumulation of actual experience with concrete objects.<br />His aim is concrete enjoyment, and his morality is similarly orientated. … It by no means follows that he is just sensual or gross, for he may differentiate his sensation to the finest pitch of aesthetic purity without being the least unfaithful, even in his most abstract sensations, to his principle of objective sensation.</p>\r\n<p>Upon the lower levels this is the man of tangible reality, with little tendency either for reflection or commanding purpose. To sense the object, to have and if possible to enjoy sensations, is his constant motive… He has no ideals related to ideas — he has, therefore, no sort of ground for maintaining a hostile attitude towards the reality of things and facts.</p>\r\n<p>But the more sensation predominates, so that the sensing subject disappears behind the sensation, the more unsatisfactory does this type become. Either he develops into a crude pleasure-seeker or he becomes an unscrupulous, designing sybarite. Although the object is entirely indispensable to him, yet, as something existing in and through itself, it is none the less depreciated. It is ruthlessly violated and essentially ignored, since now its sole use is to stimulate sensation.&nbsp;<br />When his attitude reaches an abnormal one-sidedness, he is in danger of falling just as deeply into the arms of the unconscious as he consciously clings to the object.</p>\r\n<p style=\"text-align: right;\"><em>Text in Ukrainian is here<span>&nbsp;</span><a href=\"https://7promeniv.com.ua/korotki-opysy-typiv/3058-se-u-riznykh-typolohichnykh-modeliakh.html\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></p>', '1', '31', '2024-04-29 14:40:17', '309', '', '2024-10-31 06:28:51', '309', NULL, NULL, '2024-04-29 14:40:17', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '45', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', '');
/**ABDB**/INSERT INTO `#__content`  VALUES 
('81', '219', 'levels of harmony ', 'levels-of-harmony', '<h1 style=\"text-align: center;\"><strong>JUNGIAN TYPES IN DIFFERENT LEVELS OF HARMONY</strong><br><strong>(modern descriptions)</strong></h1>\r\n<p style=\"text-align: right;\"><em>Українською тут <a href=\"https://7promeniv.com.ua/korotki-opysy-typiv/3109-typy-yunha-na-riznykh-rivniakh-harmoniinosti.html\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></p>\r\n<p style=\"text-align: justify;\">For each of the eight types Carl Jung identified several levels of psychological harmony-disharmony and noted, what neurosis is inherent to this or that type, and also described destructive behavior of a type in the lower levels. <span>(</span><em>More on this here<span> </span><a href=\"en/8-types/82-jungian-typology-levels-of-harmony\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em><span>)</span></p>\r\n<p style=\"text-align: justify;\">Modern researchers distinguish six levels of psychological harmony (from total harmony to strong disharmony, from balance to imbalance):<br>1 - PUREST MANIFESTATION OF FUNCTION - manifestation of the type integrally and without distortions due to the process of individuation.<br>2 - SOCIAL ROLE - a person\'s strengths resonate with the corresponding demand from society. (More on this here <a href=\"en/8-types/85-social-roles\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a>)<br>3 - NEUROTIC ROLE - a person wants to be useful to society with its strengths, and in return expects support for one’s self-esteem.<br>4 - MANIPULATION - Through manipulation, a person tries to shake out desirable behavior from people in order to support one’s self-esteem.<br>5 - AGGRESSIVE IMPOSITION - forcibly dragging others into one\'s destructive scenario.<br>6 - SELF-DESTRUCTIVE DISAPPOINTMENT - the loss of hope that someone will support his or her self-esteem. Disappearance of any goals and motivations.</p>\r\n', '\r\n<p style=\"text-align: justify;\">The level descriptions apply equally to both men and women.</p>\r\n<p style=\"text-align: center;\"><a href=\"#se\">Se</a>   ---   <a href=\"#si\">Si</a>   ---   Fe   ---   Fi   ---   Te   ---   Ti   ---   <a href=\"#ne\">Ne</a>   ---   <a href=\"#ni\">Ni</a></p>\r\n<p style=\"text-align: justify;\">*       *       *       *        * </p>\r\n<p style=\"text-align: justify;\"><a id=\"se\"></a>Se type - Sensation Extraverted</p>\r\n<p style=\"text-align: justify;\"><img src=\"images/typo/En/8types/Se_levels_en.jpg\" alt=\"\" width=\"400\" height=\"512\" style=\"margin: 15px; float: right;\"></p>\r\n<p style=\"text-align: justify;\"><strong><strong>• </strong>SENSING Extraverted</strong> type focuses on physical reality, is well versed in the world of material objects, confidently makes his way in the physical world, is practical and pragmatic, characterized by high physical activity, independence, decisive overcoming of obstacles, ability to confront.</p>\r\n<p style=\"text-align: justify;\">As the Se type moves through the levels of harmony, his behavior changes to the opposite.</p>\r\n<p style=\"text-align: justify;\">While the harmonious type Se upholds justice, protects the weak and has a high level of self-control, the unbalanced type Se intimidates the weak, seizes other people\'s property and follows his instincts.</p>\r\n<p style=\"text-align: justify;\">Let\'s consider in detail the most vivid manifestations of Se type at different levels of harmony.</p>\r\n<p style=\"text-align: justify;\">1 <strong>HELMSMAN </strong>- Destroys old outdated systems to prepare for the building of a new and better one. Overthrows oppressors. Takes on difficult challenging goals, has a large-scale vision. Translates strong innovative ideas into real form. Able to rally large groups of people around a certain goal, to direct one’s own and others\' will in a certain direction, to lead to a common goal. Truthful and absolutely fearless. His will is subordinate to the Supreme Will.</p>\r\n<p style=\"text-align: justify;\">2 <strong>PROTECTOR </strong>– Focused and determined, always ready for action. In crisis situations keeps calm, takes control and responsibility for others, protects the weak. Fearless, boldly moves forward, easily oriented in a new territory, well assesses the balance of power, quickly takes a leading position in a new environment. Realizes the interests of different social groups (sections of the population, community, corporation or his clan), provides them with resources and protection from external threats. He is not afraid of consequences and does not pay attention to gossip.</p>\r\n<p style=\"text-align: justify;\">3 <strong>DECISIVE </strong>- Determined and bold, acts confidently in the physical realm, loves challenges and resistance, acts impulsively, without hesitation, without thinking the consequences through, is ready to take risks. Seeks to take charge of situations and to lead others, takes initiative, helps to move projects forward. He does not do very well with being still for long periods of time or staying in a closed space. His energy needs an outlet. Able to respond quickly and flexibly to a changing environment, so he works well in a crisis, likes to solve urgent situations. Instantly reacts to any provoking stimuli, can quickly swing from composure to fury and back again.</p>\r\n<p style=\"text-align: justify;\">4 <strong>LASCIVIOUS </strong>- Develops into a crude pleasure-seeker, freely follows his instincts and physical impulses, needs immediate satisfaction of his desires, seeks to own objects on a physical level, squeezes the maximum out of them to stimulate his sensations. Experiences anger and inferiority if it is not possible to quickly take possession of the desired object. Interested only in material things. Becomes an unscrupulous, designing sybarite, lustful, lecherous and insatiable. Can be blinded by jealousy. Money and power give him the opportunity to possess what he wants.</p>\r\n<p style=\"text-align: justify;\">5 <strong>DICTATOR </strong>- Tyranny, forceful retention of power, psychological and physical violence. All problems are solved by force. He strives to subjugate as many people as possible and seize more territories. He loves the feeling of dominance and the ability to own whatever he wants. Avoids weakness and vulnerability, so as not to lose control and power, not to become dependent on others. Cruel, aggressive, vengeful. Bullies the weaker into submission. Takes pleasure in others pain and humiliation. Sees himself as outlaw.  </p>\r\n<p style=\"text-align: justify;\">6 <strong>SAVAGE </strong>- Flout social customs and authorities, will not allow anyone to control himself. Trusts no one, relies only on himself. He is constantly in tension, always expecting an attack and ready to strike back, acts in advance. For no apparent reason, he can get into a towering rage and swing his fists. Can go to open provocations and create dangerous situations in the right place. His life scenario is a struggle for survival and protection from a dangerous world.</p>\r\n<p style=\"text-align: center;\">*       *       *       *        * </p>\r\n<p><a id=\"si\"></a>Si type - Sensation Introverted</p>\r\n<p style=\"text-align: justify;\"><img src=\"images/typo/En/8types/Si_levels_en.jpg\" alt=\"\" width=\"400\" height=\"512\" style=\"margin: 15px; float: right;\"></p>\r\n<p>• <strong>SENSING Introverted</strong> type focuses on physical reality, is well versed in the world of material objects, loves working with his hands, recognizes subtle physical sensations, calm, unhurried, and adaptable, able to create a harmonious and comfort environment.</p>\r\n<p>As the Si type moves through the levels of harmony, his behavior changes to the opposite.</p>\r\n<p>While the harmonious type Si creates a calming and welcoming atmosphere, unites people and helps resolve conflicts, the unbalanced type Si avoids people, irritated and tense he causes conflicts himself.</p>\r\n<p>Let\'s consider in detail the most vivid manifestations of Si type at different levels of harmony.</p>\r\n<p>1 <strong>MEDIATOR</strong> - Values differences of opinion, perceives conflicts and tensions as a natural part of interaction, helps other people understand different perspectives. Smoothes relations between antagonistic groups or individuals, helps them move towards win-win solutions. Respects both sides of the dispute, combines different points of view, bringing the fighting parties closer together and guiding the participants of the conflict towards reconciliation. Harmonizes the toughest situations. Remains calm in a crisis, bringing peace to the atmosphere of general anxiety. His works (music, paintings, etc.) bring harmony, peace and beauty.</p>\r\n<p>2 <strong>SUPPORTER</strong> - Has the ability to bring together people with interesting ideas and unconventional views. Creates an atmosphere where one feels supported to generate ideas and develop creativity. He is a good listener, able to hear everyone\'s position, see multiple perspectives and integrate different points of view. Encourages initiatives and innovations, helps others to put new ideas into practice. Does not support competition within the team, reducing tension and focusing on group cohesion. Helps others integrate into the team, promoting collaboration and creating a sense of equality, community and belonging. Takes care of the physical needs of others. Has a healing and calming influence. Is able to create a harmonious, safe and stable environment, to provide physical and psychological comfort, helps to relax and recuperate.</p>\r\n<p>3 <strong>EVERYMAN</strong> - Humble, laidback and welcoming, he seeks to be accepted by society, has a high ability to integrate and tries to get along with everyone. He has difficulty in understanding his own potentialities, so he prefers go with the flow and not stand out from the crowd, by taking himself back and letting others go first. To avoid conflict and separation he becomes accommodating and has difficulty saying no to people, is reluctant to express one’s own opinion, doesn’t interfere in anything and doesn’t impose anything. His motto is \"Do not rock the boat\". Focused on simple family values, he has a drive to care and to provide for their loved ones. He is practical, hardworking and down-to-earth, knows how to work with his hands. Prone to excessive physical care of others, may become too controlling and overprotective.</p>\r\n<p>4 <strong>HEDONIST</strong> - Focused on his bodily sensations he pursuits sensual pleasure and loves to enjoy good food, wine, and sex. Doesn’t like work and anything that delays gratification is avoided, prone to bad habits, laziness, and gluttony. He prioritizes his own comfort and pleasure above all else. He likes long showers, pampering themselves with face masks, soft slippers and cushions. Physical discomfort causes him to have outbursts of anger, irritation, and resentment. Capricious about comfort, may quarrel with others over household trifles. More interested in the superficial aspects of life than in developing meaningful relationships, he can be dodgy and unreliable.</p>\r\n<p>5 <strong>LACKEY</strong> - Insecure, he doesn’t understand his own potentialities and worth, being a distinct individual is very scary for him. Idealizing others, he maintains a sense of worth through participation, a living through others. The other becomes the center of gravity. He gets unnoticed and can only enjoy others’ successes. Feels devastated or helpless when close relationships end. He goes to great lengths to avoid separation, by adapting to others preferences, saying “yes” to things he does not really want to do, neglecting his own needs. He takes on the daily responsibilities of cooking and cleaning, acting as a servant. His stress and anger grow as his responsibilities increase, but he keeps saying \'I\'m OK\'. He becomes overly reliant on other person, loses one’s own self in an effort to blend in, shows acquiescence in evil and error and allows himself to be exploited.</p>\r\n<p>6 <strong>LULLED</strong> - He strives for peace and harmony, but because of a constant sense of inner tension, he himself provokes conflicts. To wait out periods of conflict he closes up like a clam and withdraws completely. Unable to merge with the other, he feels lost. He increasingly withdraws from life, becoming dissociated, inert and inflexible, indifferent to himself and others. Feels that life is too much for him. Food, online shopping, video games, reading light books, that don’t require much thought, alcohol, tobacco are used by him as a self-distracting maneuver to \"putting oneself asleep\" and self-forgetfulness. Long stretches of time can pass by while he simply stares out the window, or crashes in front of the TV and channel surf. Can lie in bed until noon, wearing baggy clothes and worn out sweats and forgetting to shower for weeks. Feels hopelessness and immerses himself completely in his own fantasy world. Fantasies of peace, harmony, and other people mix with fantasies of anger and vengeance.</p>\r\n<p style=\"text-align: center;\">*       *       *       *        * </p>\r\n<p style=\"text-align: justify;\"><a id=\"ne\"></a>Ne type - Intuition Extraverted</p>\r\n<p style=\"text-align: justify;\"><img src=\"images/typo/En/8types/Ne_levels_en.jpg\" alt=\"\" width=\"400\" height=\"512\" style=\"margin: 15px; float: right;\"></p>\r\n<p><strong><strong>• INTUITI</strong>NG Extraverted</strong> type is well versed in the world of ideas, perspectives, and possibilities, feels comfortable with the unknown, is driven by curiosity, and boldly moves into uncharted territory. Has a developed imagination and out-of-the-box thinking, sees people\'s potential and reveals the hidden talents.</p>\r\n<p>As the Ne type moves through the levels of harmony, his behavior changes to the opposite.</p>\r\n<p> While the harmonious type Ne has a high level of self-organization, sees each person\'s unique gifts and finds ways to optimize these for the good of all, the unbalanced Ne type uses tricks and flattery to take advantage of other people in his own interests, is characterized by impulsiveness and infantile reactions.</p>\r\n<p>Let\'s consider in detail the most vivid manifestations of Ne type at different levels of harmony.</p>\r\n<p>1 <strong>VISIONARY</strong> - Lives ahead of time, he sees new possibilities, illuminates new directions in the development of science, culture and society, initiates positive change, pushing humanity toward advancement and giving impetus to cultural development. He has an ability to see the potential in everyone and everything, to bring new outlooks, that are beyond the horizon of most people’s vision, able to show others a holistic picture of the world. Visionary dispels stagnation, dismantles old ideological systems, helps groups break out of outdated social patterns and beliefs, free themselves from entrenched attitudes and limiting stereotypes. Helps people unleash their potential and find their vocation.</p>\r\n<p>2 <strong>INNOVATOR</strong> - Intuitive, flexible, imaginative, and innovative, he brings new ideas, talks about the wonderful possibilities that a bright future will bring, embodies a new vision, blazes the path in a new sector, going where no one has gone before. Innovator encourages others to search for something new and unexplored, broadens their outlook, helps to see the diversity of possibilities, shows ingenuity in solving problems, inspires others with his optimistic vision. He sees people\'s potential and reveals the hidden talents of others, gives them confidence in their abilities, shows them who they have the potential to be. Has the ability to see the best in all people, even if people don\'t see those qualities in themselves.</p>\r\n<p>3 <strong>CAREFREE</strong> - Has an easy breezy attitude, strives for change, stimulation and variety, cherishes freedom, quickly grasps new ideas, loves to meet new people and try new things, he is curious and is always up for an adventure. He believes that the world is full of opportunity and does not want to miss out on any of it. Carefree moves forward with optimism and an ability to always look on the bright side, at the same time, he is so preoccupied with opportunities that he sees few if any threats. He is good at the big picture, not so much the little details. He develops fantastic and bold, often risky ideas, and then expects others to figure out how to implement them, since he himself can be detached from practical realities. His activities and interests change frequently as he is constantly seeking new experiences. He often has lots of projects on the go at once, tends to get distracted easily and flit from one thing to another, which can lead to a disorganized and disorderly life.</p>\r\n<p>4 <strong>BLAGGER</strong> - Dispersed, inconsistent, impulsive and unpredictable, he is easily enthused but quickly get distracted by something new, starting new projects but never finishing any of them, tends to neglect the practical aspects of life. He has difficulty focusing and has a short attention span on a task. Thanks to his talkativeness and developed imagination, he can chat up anyone but he doesn\'t develop deep friendships, because he wants to remain free, not to feel tied to anything or anyone. He is fun to be around for a bit, but not really trusted. Blagger generates ideas on the run and often contradicts themself, he promises easily but never delivers. He is continually scenting out new possibilities, which he pursues with an equal unconcern both for his own welfare and for that of others, pressing on quite heedless of human considerations, tearing down what has only just been established in his everlasting search for change. He is willing to go to any length to avoid boredom and feeling trapped.</p>\r\n<p>5 <strong>TRICKSTER</strong> - Considers himself to be very talented and creative, expects other people to meet his needs, to help develop his talents, advance his career, implement his ideas. Uses his developed imagination to push his ideas through. Seeks a path to an easy life through trickery and misdirection. Trick others into doing monotonous, hard work instead of oneself. Requires others to provide him with entertainment and a comfortable life, avoids boredom and routine. He can change his mind at any time, has a knack for slipping out of any situation that makes him feel uncomfortable.</p>\r\n<p>6 <strong>VAGABOND</strong> - Leads a nomadic lifestyle and never grows roots. He fears routine and becoming homebound, doesn\'t want to depend on another person or be burdened of material possessions. He wants to be free to respond to impulses and desires as soon as they arise, without delay. His need for freedom from constraints and obligations may be so intense that social or family ties seem like a suffocating burden to him, and he indulges in escapism, walking away without a backward glance. The open road is calling him. The “lost soul” is on an aimless journey without direction, disconnected from others people. The illusory sense of freedom.</p>\r\n<p style=\"text-align: center;\">*       *       *       *        * </p>\r\n<p><a id=\"ni\"></a>Ni type - Intuition Introverted</p>\r\n<p style=\"text-align: justify;\"><img src=\"images/typo/En/8types/Ni_levels_en.jpg\" alt=\"\" width=\"400\" height=\"512\" style=\"margin: 15px; float: right;\"></p>\r\n<p>• <strong>INTUITING Introverted</strong> type is well versed in the world of ideas, is perceptive of underlying, hidden meanings, symbolic significance and flow of time, feels that actions are timely or not, gets strong impressions about how things will play out. Ni type has a developed imagination and out-of-the-box thinking, he trusts his intuition and understands the hidden dynamics of the human psyche, is able to reveal deception and ulterior motives.</p>\r\n<p>As the Ne type moves through the levels of harmony, his behavior changes to the opposite.</p>\r\n<p>While the harmonious type Ni possesses an inner resilience and due to his high level of self-control, can purposefully use his intuition to help others, the unbalanced Ni type chasing after his fantasies, allows his imagination to get out of control, panics and is afraid of everything.</p>\r\n<p>Let\'s consider in detail the most vivid manifestations of Ni type at different levels of harmony.</p>\r\n<p>1 <strong>SEER</strong> - has a strong connection with the superconscious. Works towards the harmonizing of human life, which is impossible without unity and embodied idealism. Understands human nature. Dives into the depths of the human psyche. Helps others understand their inner world, feel connected to their spiritual nature and find its Source. Realizing the illusory nature of the time factor, he feels time cycles well and helps people to recognize a certain aspect of their individuality at the best time for them. Understands the principles underlying events and phenomena, can foresee the development of events and people\'s behavior. He can see the path that will lead to the most favorable outcome for everyone.</p>\r\n<p>2 <strong>INTEGRATOR</strong> – rebels against injustice and serves as champion for vulnerable groups or individuals. Despite the circumstances, possesses an inner resilience that\'s inspiring for other. Realizes that people are weak alone, but together they are a great force. Rallies those sooner down-trodden. Creates and maintains alliances and associations to achieve a common goal: survival, defense, realization of the idea. His insight allows him to see beyond the current situation and anticipate potential issues, warns of possible dangers. Integrator has access to the collective unconscious and is aware of various levels of interaction among people. By striving for harmony and transparency, he dissolves boundaries between people and creates a sense of equality, unity, and belonging. Facilitates group insight and strengthens collective consciousness.</p>\r\n<p>3 <strong>INSIGHTFUL</strong> – receptive to deep, hidden meanings. Notices details, feels the flow of time, anticipates how a situation will unfold over time, and knows how to move away from danger in advance. Cautious in communication, shows friendliness, tries to pacify and disarm others. Does not argue, even if disagreeing, tends to tergiversate instead of answering the direct question to avoid conflict. Takes an individual approach to each person, tunes in to them, is able to listen carefully without judging. Quickly sniffs out lies and hidden motives. Likes to explore negative experiences; one can talk to him about painful feelings and cry together. INSIGHTFUL indecisive, often lacks the self-confidence to take action in the physical world. May think everything through in his mind, but never actually start putting his ideas into reality. Prone to anxiety, exaggerates threats. Tries to rally support from others.</p>\r\n<p>4 <strong>DRIFTING IN PHANTASIES</strong> – spends hours daydreaming, perceiving the unconscious images, produced in such inexhaustible abundance by imagination. Observing how the picture changes, unfolds further, and fades he moves from image to image in the sensation of being ‘spaced out’, light, floating etc. He may see himself as almost magical creature. The real world is less interesting to him than the inner landscapes he creates for himself. He gives himself up to fruitless phantasies showing a total disregard of his livelihood, avoiding any responsibility or commitment. Does not feel inclined to enter into a deep relationship with other people, likes to spend time on his own. Considers himself special, insightful, different from others and therefore deserves special treatment. Dwells on his experiences, demonstrates hypersensitivity and suffering. Takes offense and provokes others to force them to take responsibility for his life, act in his interests and supply him with financial support.</p>\r\n<p>5 <strong>LOYALIST</strong> – believes that he does not possess the internal resources to handle life’s challenges and physically defend himself, is filled with a nameless anxiety. Depends excessively on the other as a result of a sense of undervaluing himself. Becomes extremely vulnerable if isolated from external sources of support. Willing to go along with abuse in order to be one of the group. Has a tendency to play the victim in order to attract a \'savior\'. He lets others to make decisions for him, hands over power, responsibility, and control of his life to others. Demonstrates devotion, compliance, helpfulness, self-sacrifice to loved ones or his group. He is drawn to systems, alliances, and groups that contain strong authoritarian elements. Loyalist is inclined towards hero worship and desires to identify with the powerful figure.</p>\r\n<p> 6 <strong>HELPLESS</strong> - an attitude of superiority exists along with a bad self-image. When his claim of specialness is frustrated, he becomes bitter, cynical, and pessimistic, playing the role of a ‘misunderstood genius’, blames others for his problems and sees the world as ‘against’ him. Searches for hidden meanings in the statements and actions of others. When his imagination races out of control, he escalates a small misunderstanding into an epic struggle, may strike out at real or imagined enemies and retaliate against those who have \'abandoned\' him or \'demanded too much.\' Aggression and fear appear in continual interchange. He imagines scenes of disaster, feels panicky and helpless. Loathes himself and hates others for failing to save him. May find himself wading in the depths of despair, self-pity, and depression. </p>\r\n<p>*       *       *       *        * </p>\r\n<p>Level-by-level descriptions of eight Jungian types were developed in 2020-2021 by the ‘Typosynthesis’ team. All descriptions are here in Ukrainian <a href=\"https://7promeniv.com.ua/typy-i-arkhetypy\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p style=\"text-align: justify;\"><em>Last updating 17.09.2025</em></p>', '1', '26', '2024-05-16 09:56:42', '309', '', '2026-01-15 10:41:48', '308', NULL, NULL, '2024-05-16 09:56:42', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '106', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('82', '220', 'jungian typology levels of harmony', 'jungian-typology-levels-of-harmony', '<h1 style=\"text-align: center;\"><strong>LEVELS OF PSYCHOLOGICAL HARMONY IN JUNGIAN TYPOLOGY</strong></h1>\r\n<p style=\"text-align: center;\">Depending on the level of inner harmony, a person can perceive the external world differently:<br />The world is beautiful;<br />The world is good;<br />The world is ordinary;<br />The world is hostile;&nbsp;<br />The world is scary.</p>\r\n<p>At a high level of harmony, a person perceives the world as good or beautiful, he is optimistic, inclined to mutually beneficial cooperation, he has developed empathy, accepts himself and others, has a high level of energy and recovers quickly from stress.</p>\r\n<p>With internal disharmony, a person spends his energy on inner conflicts.&nbsp;He is constantly tense, takes a defensive position, is not ready to cooperate and does not trust others.&nbsp;</p>\r\n<p>In general, only people of the same level or neighboring levels can communicate with each other normally.&nbsp;A person who perceives the world as hostile cannot understand a person for whom the world is beautiful.&nbsp;</p>\r\n<p>Different types of people have different types of inner conflicts and different reactions to stressors. Some types are prone to anger, others to self-pity, some are prone to stupor and detachment, and others to feeling guilt and shame.</p>\r\n<p>Carlos Castaneda writes: <em>“Don Juan asked me to tell him what had been the most natural reaction I had in moments of stress, frustration and disappointment before I became an apprentice. He said that his own reaction had been wrath. I told him that mine had been self-pity.”</em> (<a href=\"#kastaneda\">1</a>)</p>\r\n', '\r\n<p>Jungian typology describes eight psychological types of people. The type of person is determined by the main psychic function. (<em>More on this here <a href=\"en/8-types/79-dualities-in-jungian-typology\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em>)</p>\r\n<p>Carl Jung wrote: <em>“The conscious attitude (main psychical function) is always in the nature of a Weltanschauung, if it is not explicitly a religion. <strong>It is this that makes the type problem so important. The opposition between the types is not merely an external conflict between men, it is the source of endless inner conflicts</strong>; the cause not only of external disputes and dislikes, but of nervous ills and psychic suffering.”</em> (<a href=\"#jung2\">2</a>)</p>\r\n<p>For each of the eight types Carl Jung identified several levels of psychological harmony and indicated, what neurosis* is inherent to this or that type, as well as described destructive behavior of a type in the lower levels.</p>\r\n<p>Behavior of a person of a certain type at different levels of harmony is so different that it may seem that we are talking about different types of people. Familiarization with levels of psychological harmony-disharmony helps to understand how development or degradation occurs within each type.</p>\r\n<p>Here is a brief example of how Carl Jung described the levels of psychological harmony- disharmony for Se type:</p>\r\n<p><em>“No other human type can equal the extraverted sensation-type in realism. … His life is an accumulation of actual experience with concrete objects.</em><br /><em>His aim is concrete enjoyment, and his morality is similarly orientated. … It by no means follows that he is just sensual or gross, for he may differentiate his sensation to the finest pitch of aesthetic purity.&nbsp;</em><br /><em>Upon the <strong>lower levels</strong> this is the man of tangible reality, with little tendency either for reflection or commanding purpose. To sense the object, to have and if possible to enjoy sensations, is his constant motive. … He has no ideals related to ideas — he has, therefore, no sort of ground for maintaining a hostile attitude towards the reality of things and facts.</em><br /><em>But the <strong>more sensation predominates</strong>, so that the sensing subject disappears behind the sensation, the <strong>more unsatisfactory does this type become</strong>. Either he develops into a crude pleasure-seeker or he becomes an unscrupulous, designing sybarite. Although the object is entirely indispensable to him, yet, as something existing in and through itself, it is none the less depreciated. It is ruthlessly violated and essentially ignored, since now its sole use is to stimulate sensation.&nbsp;</em><br /><em>When his attitude (main psychical function) reaches an abnormal one-sidedness, he is in danger of falling just as deeply into the arms of the unconscious as he consciously clings to the object.”</em> (<a href=\"#jung3\">3</a>)</p>\r\n<p>Knowing the levels of harmony of each of the eight types helps to predict a person’s behavior and the nature of interaction with him.</p>\r\n<p>The degree of psychological harmony of a person can be divided into different number of levels.</p>\r\n<p>The Enneagram typology describes 9 levels of development for each type:<br />* <strong>HEALTHY levels</strong>: Liberation; Psychological capacity; Social value;<br />* <strong>AVERAGE levels</strong>: Fixation; Interpersonal control; Overcompensation;<br />* <strong>UNHEALTHY levels</strong>: Violation; Obsession and compulsion; Pathological destructiveness. (Sourse <a href=\"https://www.enneagraminstitute.com/levels-of-development/\" target=\"_blank\" rel=\"noopener\">www.enneagraminstitute.com</a>)</p>\r\n<p><em>“It is almost impossible to make generalizations about the types without taking the Levels into consideration, because as each type deteriorates down the Levels, many of its characteristics become their opposite.</em><br /><em>While our basic type does not change, the Level at which we are operating changes all the time. We may move up and down several Levels of our type in a single day within a certain “bandwidth” or range of habitual behaviors. We may wake up in a balanced, healthy state, but have a bad argument with a colleague and fall two or three Levels. Even though our state can radically change in a short time, we are not a different personality type—we are simply manifesting different behaviors at different Levels of our type.” </em>(<a href=\"#ennea4\">4</a>)</p>\r\n<p>American philosopher and writer on transpersonal psychology Ken Wilber praised the levels of development described in the book “The Wisdom of the Enneagram”:</p>\r\n<p><em>“By combining the horizontal types of the Enneagram with a system of vertical levels of awareness, Riso and Hudson have produced one of the first truly integrated models of the human psyche. In addition to the importance of this pioneering work itself, it goes to point up the utter inadequacy of anything less than a full-spectrum model of human growth and development.”</em> (<a href=\"#ennea5\">5</a>)</p>\r\n<p>Few people are familiar with Jung\'s typology and the levels of harmony of Jungian types, because the book “Psychological Types” is written in a complex language, which is difficult to understand even for specialists. In addition, at the time of writing the book, many psychological terms did not exist yet, and Carl Jung had to create and introduce new terms himself. Most people learned about Jungian typology through MBTI and socionics. However these modern typological models describe only average behavior of types, the levels of psychological harmony-disharmony of a person are not taken into account in these models. In addition, MBTI describes not 8, but 16 types.</p>\r\n<p>We suggest you familiarize yourself with modern descriptions of Jungian eight types, written in simple, easy-to-understand language. These descriptions include six levels of psychological harmony of a type (from total harmony to strong disharmony, from balance to imbalance):<br /><strong>• PUEST MANIFESTATION OF FUNCTION</strong> - manifestation of the type integrally and without distortions due to the process of individuation.<br /><strong>• SOCIAL ROLE</strong> - a person\'s strengths resonate with the corresponding demand from society. (More on this here <a href=\"en/8-types/85-social-roles\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a>)<br /><strong>• NEUROTIC ROLE</strong> - a person wants to be useful to society with its strengths, and in return expects support for one’s self-esteem.<br /><strong>• MANIPULATION</strong> - Through manipulation, a person tries to shake out desirable behavior from people in order to support one’s self-esteem.<br /><strong>• AGGRESSIVE IMPOSITION</strong> - forcibly dragging others into one\'s destructive scenario.<br /><strong>• SELF-DESTRUCTIVE DISAPPOINTMENT</strong> - the loss of hope that someone will support his or her self-esteem. Disappearance of any goals and motivations.</p>\r\n<p style=\"text-align: center;\"><a href=\"en/8-types/levels#se\" target=\"_blank\" rel=\"noopener\">Se</a> --- <a href=\"en/8-types/levels#si\" target=\"_blank\">Si</a> --- Fe --- Fi --- Te --- Ti --- <a href=\"en/8-types/levels#ne\" target=\"_blank\" rel=\"noopener\">Ne</a> --- <a href=\"psyholistic.top/en/8-types/levels#ni\" target=\"_blank\">Ni</a></p>\r\n<p>These levels make crucial distinctions within each type, adding a “vertical” dimension to an otherwise “horizontal” system.</p>\r\n<p style=\"text-align: center; text-indent: 1px;\"><a href=\"images/typo/En/8types/8_types_levels_en.jpg\" class=\"jcepopup\" data-mediabox=\"1\" data-mediabox-width=\"100%\"><img src=\"images/typo/En/8types/8_types_levels_en.jpg\" alt=\"\" width=\"500\" style=\"display: block; margin-left: auto; margin-right: auto;\" /></a></p>\r\n<p>* &nbsp; &nbsp; &nbsp; * &nbsp; &nbsp; &nbsp; * &nbsp; &nbsp; &nbsp; * &nbsp; &nbsp; &nbsp; *</p>\r\n<p>*While diagnosis “Neurosis” was removed from the \"Diagnostic and Statistical Manual of Mental Disorders\" in 1980, the term is still often used informally to describe behaviors related to stress and anxiety.</p>\r\n<p><a id=\"kastaneda\"></a>1 - Carlos Castaneda: Tales of Power. Part three. The Sorcerers explanation. The strategy of a Sorcerer. 1974</p>\r\n<p><a id=\"jung2\"></a>2 - Psychological Types. A lecture delivered by Carl Jung, Territet, Switzerland, 1923.</p>\r\n<p><a id=\"jung3\"></a>3 - Carl Jung “Psychological Types”, 1921. General description of the types. The extraverted sensation type.</p>\r\n<p><a id=\"ennea4\"></a>4 - Don Richard Riso, Russ Hudson. The Wisdom of the Enneagram, 1999. Chapter 6: Dynamics and variations. The levels of development</p>\r\n<p><a id=\"ennea5\"></a>5 - Don Richard Riso, Russ Hudson. The Wisdom of the Enneagram, 1999.</p>\r\n<p><em>Last updating 02.06.2024 </em></p>\r\n<p style=\"text-align: right;\"><em>Original text in Ukrainian here<span>&nbsp;</span><a href=\"https://7promeniv.com.ua/korotki-opysy-typiv/3055-rivni-rozvytku-iunh.html\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></p>', '1', '26', '2024-06-02 15:22:09', '309', '', '2025-10-23 10:03:00', '309', '309', '2026-01-15 09:35:27', '2024-06-02 15:22:09', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '26', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('83', '228', 'se female portrait ', 'se-female-portrait', '<h1 style=\"text-align: center;\"><strong>SE - FEMALE PORTRAIT </strong></h1>\r\n<p>Jungian SENSATION Extraverted Type (Se) can be found under different names in different typological models. The female image of the Se type is vividly represented in the archetypes of the Amazon, the Queen, the Warrioress, Artemis, the Huntress, the Wild Woman.</p>\r\n<p><em>The following description of the Amazon represents the characteristics that unite all of the aforementioned female archetypes with the Jungian Type Se:</em></p>\r\n<p><strong>The AMAZON archetype</strong> personifies an independent, self-sufficient, ambitious and goal-oriented woman highly capable of making her way in the world, to seek her own goals on terrain of her own choosing. She is characterized by high energy and activity levels. She is grounded and connected to her own source of power.</p>\r\n<p>The Amazon is a natural leader. She is a powerhouse who changes her environment, shaping it to her goals. She is competitive, and committed to the causes she cares about, always standing up for what she believes in. She is confident in taking charge, whether it’s in her romantic relationship, her business, or with her family.</p>\r\n', '\r\n<p>She will always gravitate towards professions that enable her to be autonomous and not have to answer to anyone. She does not need to explain herself nor does she complain, to be a people pleaser or a victim. She relies on no one but herself.</p>\r\n<p>The Amazon does not need masculine approval. Her identity and sense of worth is based on who she is and what she does and not whom she is married to. She relates to the men in her life as companions, co-workers and allies. Any type of relationship she sets up must be absolutely equal and must leave room for her sense of independence and pursuit of her interests.</p>\r\n<p>She will not stand for anyone putting her down, humiliating her or trying to make her subservient, disrespecting her or her loved ones. She is the Defender of orphans and widows, the broken and downtrodden. Her assertive and high-energy nature inspire others to get up and tackle the challenges in their own lives.</p>\r\n<p>Shadow: intimidating, critical, judgmental toward weakness in others, quick to anger, bossy.<br />Wound: Her heart. Her strong masculine can conceal her vulnerability and make it difficult for her to be in her feminine.</p>\r\n<p>Sources:&nbsp;<a href=\"https://embodiedawakeningacademy.com/the-feminine-archetypal-wheel/\" target=\"_blank\" rel=\"noopener\">embodiedawakeningacademy.com</a>,&nbsp;<a href=\"https://isayabelle.com/artemis-as-a-back-to-nature-archetype\" target=\"_blank\" rel=\"noopener\">isayabelle.com</a>&nbsp;,&nbsp;<a href=\"https://www.yogitimes.com/article/feminine-archetypes-female-women-quiz-examples\" target=\"_blank\" rel=\"noopener\">www.yogitimes.com</a>,&nbsp;<a href=\"https://revoloon.com/shanijay/divine-feminine-archetypes\" target=\"_blank\" rel=\"noopener\">revoloon.com</a>,&nbsp;<a href=\"https://prezi.com/4njw7jg4dinm/amazonian-warrior-archetype/\" target=\"_blank\" rel=\"noopener\">prezi.com</a></p>\r\n<p><strong>• The Warrior - female archetype by Chantelle Raven&nbsp;</strong><a href=\"https://embodiedawakeningacademy.com/the-feminine-archetypal-wheel/\" target=\"_blank\" rel=\"noopener\">embodiedawakeningacademy.com</a></p>\r\n<p>The Warrior Woman archetype is independent and self-contained and highly capable of making her way in the world. She is focused, ambitious, assertive, goal-oriented and self-sufficient. She relates to the men in her life as companions, co-workers and allies. Whilst tribe and community are important to her, she is also quite content to be on her own. She can take care of herself physically. She will always gravitate towards professions that enable her to be autonomous and not have to answer to anyone. She seeks her own counsel, often dedicating her life to a cause that she is very passionate about. She is grounded and connected to her own source of power. She claims her space in the world with confidence and with an air of sovereignty, trusting herself completely. Her no’s are honored with the same ease as her yes’s. She does not need to explain herself nor does she complain. She is not interested in being a people pleaser or a victim.&nbsp;<br />She will not stand for anyone putting her down, disrespecting her or her loved ones, humiliating her or trying to make her subservient.<br />Warrior Dark Shadow: &nbsp;intimidating, critical, judgmental toward weakness in others, quick to anger, bossy. She can also keep others at an emotional distance with her powerful air of authority.<br />Warrior Wound: Her heart. Her strong masculine can conceal her vulnerability and make it difficult for her to be in her feminine.</p>', '1', '31', '2024-06-22 09:08:16', '309', '', '2024-07-03 12:47:27', '309', NULL, NULL, '2024-06-22 09:08:16', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '13', '2', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('84', '230', 'Si in different typological models', 'si-in-different-typological-models', '<h1 style=\"text-align: center;\"><strong>SENSATION INTROVERTED TYPE - SI - IN DIFFERENT TYPOLOGICAL MODELS</strong></h1>\r\n<p>Jungian SENSATION Introverted Type (Si) can be found under different names in different typological models:<br />• Caregiver, Sensualist, Artist – archetypes<br />• <a href=\"#taurus\">Taurus</a> - Zodiac Sign Personality Traits <br />• Hygge lifestyle<br />• Type 9 – Enneagram<br />• <a href=\"#kapha\">Kapha dosha</a> – Ayurveda<br />• Si type&nbsp; – Carl Jung</p>\r\n', '\r\n<p><strong>✅&nbsp;Caregiver, Sensualist, Artist – archetypes</strong></p>\r\n<p style=\"text-align: center;\">*&nbsp; &nbsp; &nbsp; &nbsp; *&nbsp; &nbsp; &nbsp; &nbsp; *</p>\r\n<p><strong>✅</strong> <a id=\"taurus\"></a><strong>Taurus - Zodiac Sign Personality Traits</strong></p>\r\n<p>Taureans have a heightened appreciation for physical pleasures and a deep connection to the senses, whether through touch, taste, or aesthetics. Dependable, patient, and deeply appreciative of life\'s finer things, they have an innate ability to create a warm and welcoming atmosphere. Taureans are interested in physical manifestations of beauty, like art and fashion. Aesthetics and how they physically appear in the world matter to them. They have a sense of what looks good and suits them.<br />To enjoy life to the fullest, this sign is all about slowing down and seeking comfort. Their reputation for being a homebody, married to the couch comes from their need to decompress and relax. Really, they\'d spend all day blissing out in a spa or a bubble bath. At the same time, these earth signs know the value of a dollar. Taureans aren’t afraid to roll up their sleeves and work hard to earn big rewards.<br />Taureans are steadfast and very set in their ways, and their love of stability and security means that they\'re slow to change their minds, switch course or accept new ideas.</p>\r\n<p>Friends. Taureans love to host and cook for friends. They are loyal, generous and always willing to lend a hand of friendship. Many of their friendships begin in childhood with a tendency to last them a lifetime.</p>\r\n<p>Relationship. Taureans\' ultimate date night is spent inside — primarily around the dining room table, indulging in gourmet comfort foods, and the couch, cozying up, snuggling, and making out. Taureans\' signature leisurely pace shows up in the bedroom. They rarely put any pressure on their partner and feel like sex is something to be enjoyed.<br />Taureans are interested in merging completely with a partner. They need to feel loved, comforted, and, above all, stable in a relationship. They\'re not ones for drama.</p>\r\n<p>Family. Home and matters of the family are very important to every Taurus. Taureans love kids, they are nurturing and reliable parents.</p>\r\n<p>Career. At work, Taureans are thorough and methodical, preferring to work on one task at a time rather than juggling several projects. Taureans love working with their hands, they thrive with hands-on tasks like farming, botany and agriculture, but their Venusian influence makes artistry (think illustration, interior design or fashion-related fields) an equally fulfilling profession. Taurus can be an excellent cook, gardener, and artist.</p>\r\n<p>(Sourses&nbsp;<a href=\"https://www.allure.com/story/taurus-zodiac-sign-personality-traits\" target=\"_blank\" rel=\"noopener\">www.allure.com</a>&nbsp;,&nbsp;<a href=\"https://www.vice.com/en/article/jg5pd4/taurus-personality-traits-everything-you-need-to-know\" target=\"_blank\" rel=\"noopener\">www.vice.com</a>&nbsp;,&nbsp;<a href=\"https://www.mindbodygreen.com/articles/taurus-101-personality-traits-compatability-and-more\" target=\"_blank\" rel=\"noopener\">www.mindbodygreen.com</a>&nbsp;,&nbsp;<a href=\"https://www.glamourmagazine.co.uk/article/taurus-sign-traits-personality\" target=\"_blank\" rel=\"noopener\">www.glamourmagazine.co.uk</a>&nbsp;,&nbsp;<a href=\"https://www.zodiacsign.com/zodiac-signs/taurus/\" target=\"_blank\" rel=\"noopener\">www.zodiacsign.com</a>&nbsp;,&nbsp;<a href=\"https://www.instyle.com/taurus-zodiac-sign-5393418\" target=\"_blank\" rel=\"noopener\">www.instyle.com</a>,&nbsp;<a href=\"https://www.purewow.com/wellness/taurus-personality\" target=\"_blank\" rel=\"noopener\">www.purewow.com</a>&nbsp;)</p>\r\n<p>*&nbsp; &nbsp; &nbsp; &nbsp; *&nbsp; &nbsp; &nbsp; &nbsp; *</p>\r\n<p><strong>✅<a id=\"kapha\"></a>&nbsp;Kapha dosha – Ayurveda</strong></p>\r\n<p>People with a predominant Kapha dosha are calm, composed, stable, peaceful, and unhurried. They have a propensity to be sluggish in their decision-making processes; they want to consider all choices. They are excellent listeners, easygoing and laidback, caring and patient, they are difficult to aggravate. Above all else, Kaphas value inner tranquillity, peace and harmony. They also prioritise their family and friends, good food, and the pleasant things in life. There\'s no better supporter than a friendly Kapha individual. And they may often ignore their needs to accommodate other people.</p>\r\n<p>Even though Kapha are not afraid of hard work, they tend to avoid it when they can. They prefer comfortable surroundings. They are grounded and given to rootedness in a particular place, and tend to rarely give into changes. Too much Kapha energy might cause them to get caught in a rut and not know how to get out.</p>\r\n<p>If Kapha dosha gets the upper hand, people become inflexible and increasingly cut back the radius of their existence. They perceive the intense movements and changes of everyday life as exhausting. The result is that they increasingly withdraw from life, shutting themselves off and becoming emotionally and spiritually isolated from their surroundings. It does not take long for boredom to set in. And this is accompanied by food cravings and an uncontrollable desire to consume sweet things, fatty foods, cheese, sausage products. The result is obvious: weight gain and excessive fat in the tissues. Every Kapha type will recognise the phases of internal withdrawal, the desire to be alone and to laze about, the instinctive need to wait out periods of conflict. But once this natural regeneration phase has mutated into a typical Kapha depression, the individual can feel that life is too much for them and they immerse themselves completely in their own fantasy world.</p>\r\n<p>(Sourses&nbsp;<a href=\"https://kairalicenters.com/unlocking-the-secrets-of-kapha-dosha-a-comprehensive-guide/\" target=\"_blank\" rel=\"noopener\">kairalicenters.com</a>&nbsp;,&nbsp;<a href=\"https://www.keralaayurveda.biz/blog/kapha-dosha-guide-everything-you-need-to-know\" target=\"_blank\" rel=\"noopener\">www.keralaayurveda.biz</a>&nbsp;,&nbsp;<a href=\"https://beyogi.com/an-introduction-kapha-dosha/\" target=\"_blank\" rel=\"noopener\">beyogi.com</a>&nbsp;,&nbsp;<a href=\"https://somatheeram.org/en/kapha/\" target=\"_blank\" rel=\"noopener\">somatheeram.org</a>&nbsp;)</p>\r\n<p>*&nbsp; &nbsp; &nbsp; &nbsp; *&nbsp; &nbsp; &nbsp; &nbsp; *</p>\r\n<p style=\"text-align: right;\"><em>Text in Ukrainian is here &gt;&gt;&gt; </em></p>', '1', '32', '2024-07-03 12:50:27', '309', '', '2024-07-18 04:30:17', '309', NULL, NULL, '2024-07-03 12:50:27', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '22', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('85', '231', 'Social roles', 'social-roles', '<h1 style=\"text-align: center;\"><strong>SOCIAL ROLES</strong></h1>\r\n<p style=\"text-align: right;\"><em>Українською тут <a href=\"https://7promeniv.com.ua/korotki-opysy-typiv/2669-sotsialni-roli.html\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></p>\r\n<p style=\"text-align: center;\">How each of Jung’s 8 personality types manifests in social life</p>\r\n<p style=\"text-align: justify;\">The social role is a kind of social portrait of a psychologically mature person of a certain type, who constructively uses his qualities both for his own social adaptation and for the common good. Each of the 8 types is characterized by innate predispositions to a particular activity. A person\'s strengths resonate with the corresponding demand from society – this is the main condition for the successful realization of a person\'s vocation and for feeling happy in his or her place.</p>\r\n<p style=\"text-align: justify;\">Each of the eight social roles is a natural consequence of the manifestation of one of eight Jungian psychic functions.</p>\r\n<p>A person\'s increasing maturation or increasing stress have a significant influence on how the person is expressing his or her type. If a person has a lot of internal conflicts, then a huge part of his or her efforts and energy is spent on these conflicts, so he does not have the strength to realize his potential for good of society and to fulfill a social role. Such a person’s social role is distorted by manipulation and various destructive neurotic games. Each type has his own manipulations.</p>\r\n<p>WHEN A SOCIAL ROLE BECOMES NEUROTIC</p>\r\n<p>When a person is identified with his social role, he/she begins to feel uncomfortable without that role. He/she may feel that others need him only in this role.</p>\r\n', '\r\n<p>The neurotic role is always like running in a circle, in which a person drives himself/herself, and then does not know how to get out of it. This pattern of behavior is accompanied by loss of energy, physical and mental exhaustion.</p>\r\n<p>A characteristic feature of the neurotic social role is that the person stops listening to his or her own deepest needs and instead lives the goals and needs of others. At the same time, the person believes that he or she only gives and does not require anything in return. Such help to others is often unsolicited and even intrusive, and resembles interference in the lives of others in order to get something from them. There is always a so-called hidden benefit behind outwardly selfless behavior. The neurotic role works on the principle of “giving in order to get.”</p>\r\n<p>However, the expression \"giving in order to get\" does not imply equal mutual assistance “You give me, I give you”, a favor for a favor, but a disproportionate exchange: “I give you social assistance, and you support my self-esteem for this.”</p>\r\n<p>Eight Social Roles</p>\r\n<p>•&nbsp;<strong>Decisive PATRON</strong> – takes an active position, yearns to affect the course of events, considers himself responsible for what is happening, remains calm in difficult situations and takes charge of others, quickly makes important decisions and acts confidently in urgent situations. Patron strongly defends his people, does not hesitate to throw himself into melee and conflicts, stands up for the weak and defenseless. Helps others to act in the physical world, to assert their rights, gives them confidence in their own strength, energizes, supports them financially, helps to overcome obstacles, moves heavy projects forward, leads the group to a common goal. Patron puts all his strength into what he does, expects fidelity and subordination from others. Avoids any manifestation of his weakness in public so as not to lose the loyalty of others or be betrayed. Fears being weak and dependent on others.</p>\r\n<p>•&nbsp;<strong>Peaceful SUPPORTER</strong> – recognize the smallest changes in his physical state, which allows him to understand and respond to the physical needs of others. He strives to feed and warm everyone, helps others to relax and regain their strength. Supporter creates a friendly peaceful environment in which people feel free and comfortable, without tension and competition, helps others to integrate into the group. Able to listen and to hear everyone\'s position, Supporter helps others to understand different points of view and find common ground, he smooths conflicts and encourages cooperation. Supports various initiatives, is attentive to practical details, helps to put new ideas into practice. Strives for unity with everyone, is afraid of separation, so avoids conflicts, hides his anger and tension, tries to reconcile and calm everyone down, expects others to maintain friendly peaceful relations with him and get along with each other.</p>\r\n<p>•&nbsp;<strong>Sociable CHEERLEADER</strong> – easily identifies the emotional state of others, is able to provide emotional support: cheer up, say something nice, entertain, ignite, inspire. Cheerleader is able to overcome the restraint and indifference of the interlocutor, encourages emotional interaction. Enjoys working with people and for people, feels responsible for the emotional state of others, wants to help everyone. Cheerleader is never cold and indifferent, easily comes into contact with strangers, always reacts to being addressed, is interested in the problems of others, shows affection, actively engages others in communication. Expects admiration and gratitude from others for his support. Hides his problems from others, afraid that if he talks about his needs, he will disappoint others and will no longer be needed.</p>\r\n<p>• <strong>Social EDUCATOR</strong> – takes responsibility for the stability and well-being of the community, regulates ties in social groups or family, maintains and preserves the traditions and values of the group. Regulates his activities according to social norms in use, puts aside his emotions to better serve the interests of society. Always knows what is good and what is bad. Educator, by his precept and his own example, helps those who have gone astray, instills a love of decency and responsibility, helps them to understand moral issues, to treat others politely, maintain long-term relationships, and act for the good of society. Provides moral support to those have found themselves in a difficult situation or who have lost faith in people (the seriously ill, victims of violence, refugees, the disabled). Tries to do everything impeccably. Expects others to respect him, follow his instructions and recognize his moral authority. Is afraid of condemnation of others for his wrong actions and “unworthy” desires.</p>\r\n<p>•&nbsp;<strong>Efficient HERO</strong> – Takes responsibility for the effectiveness of projects, develops algorithms of actions to achieve practical results in the shortest time, notices vulnerabilities in various projects and finds a way to eliminate them. Has good organizational skills, engages others in business interactions, organizes workflow, and convincingly explains the practicality and benefits of various projects and initiatives. Gives actionable advice on how to make the best use of resources and get things done efficiently. The hero is activated in situations requiring a fast intellectual reaction and achievement of a visible results. He enthusiastically takes action to solve the issue if he is sure that he can handle it quickly and come out of the situation as a hero, while demonstrating his intelligence and gumption. Demonstrates his success and efficiency in all spheres, is afraid to look like a loser. Hides his failures, setbacks and incompetence.</p>\r\n<p>• <strong>Cautious EXPERT</strong> – feels an obligation to maintain order and justice, to find answers to all questions and to convey knowledge to others. He wants life to be planned, understandable and fit into a certain system. Expert dives deep in the study of the issue, analyzes data thoroughly for a long time, looks for cause-and-effect relationships and patterns, organizes information, reveals logical inconsistencies and disturbance of structure, shares his conclusions and vision with others. Maintains composure in emotionally charged situations. Is able to present his thoughts clearly and consistently, demonstrates relative objectivity, accuracy and directness in statements. Expects others to listen attentively and recognize that his understanding is correct. Is afraid of not finding the answer to a question and avoids situations in which he may appear incompetent.</p>\r\n<p>•&nbsp;<strong>Optimistic INVENTOR</strong> – sees the diversity of opportunities and people\'s potential, shows ingenuity in solving problems, and inspires others with his optimistic vision. His carefree, curious and free-spirited nature dispels stagnation, breaks up the heaviness, and helps others break free from old, entrenched patterns and beliefs. Inventor is full of exciting ideas and talks about the wonderful possibilities that a bright future will bring. He encourages others to search for something new and unexplored, broadens their outlook, helps them see the diversity of possibilities, reveals the hidden talents of others, and gives them confidence in their abilities. He wants life to be easy and carefree, is afraid to face pain and restrictions. Demonstrates activity and optimism, hides boredom and need for support.</p>\r\n<p>• <strong>Devoted FORECASTER</strong> – Understands human nature, is able to read people, can sniff out their hidden motives and fears, encourages others to explore their inner world. Able to listen carefully to another without judging, resonates with his or her deep world, reflects it, helps to reveal the hidden. Thanks to developed intuition, gets strong impressions about how things will play out, well assesses the prospects of projects and suggests the best time for action. Realizes that people are weak alone, but together they are a great force. Creates and maintains alliances and associations to achieve a common goal: survival, defense, realization of the idea. Shows great loyalty to loved ones or his group, attentive to their needs, foresees consequences of their actions and warns of possible dangers. Satisfied when others appreciate him and listen to his words. Afraid of losing subtle perception and being left without the support of others.</p>\r\n<p style=\"text-align: center;\">* * *</p>\r\n<p style=\"text-align: left;\">Usually an individual has several social roles, which he or she manifests depending on the situation.</p>\r\n<p style=\"text-align: center; text-indent: 1px;\"><a href=\"images/typo/En/8types/Jung_soc_roli_en.jpg\" class=\"jcepopup\" data-mediabox=\"1\" data-mediabox-width=\"100%\"><img src=\"images/typo/En/8types/Jung_soc_roli_en.jpg\" alt=\"\" width=\"70%\" /></a></p>\r\n<p>&nbsp;</p>\r\n<p><em>Last updated 29.10.2024</em></p>\r\n<p>&nbsp;</p>', '1', '26', '2024-10-29 07:29:44', '309', '', '2024-10-29 09:21:55', '309', NULL, NULL, '2024-10-29 07:29:44', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '17', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('86', '233', 'Ne in different typological models', 'ne-in-different-typological-models', '<h2 style=\"text-align: center;\"><strong>INTUITION EXTRAVERTED TYPE - NE - IN DIFFERENT TYPOLOGICAL MODELS</strong></h2>\r\n<p><span>Descriptions of the Intuition Extraverted Type can be found under different names in different typological models:<br /><strong>• </strong><a href=\"#temper\">Sanguine temperament</a> - according to some authors<br /><strong>• </strong><a href=\"#adizes\">E-role (Arsonist)</a> -&nbsp;Ichak Adizes<br />• <a href=\"#vata\">Vata dosha</a> – Ayurveda<br />• Aquarius and Geminis zodiac signs’ personality traits<br />• Visionary, Explorer, Pioneer archetypes</span><br />•&nbsp;Type 7 – Enneagram<br />•&nbsp;<a href=\"#jungne\">Type Ne</a> – Carl Jung</p>\r\n<p>✅&nbsp;<a id=\"temper\"></a><strong>Sanguine temperament&nbsp;</strong></p>\r\n<p>•<strong> Sanguine temperament by Rev Bowen – Waldorf pedagogy&nbsp;- Simply&nbsp;Waldorf&nbsp;<a href=\"https://www.simplywaldorf.com/post/the-waldorf-temperaments\" target=\"_blank\" rel=\"noopener\">www.simplywaldorf.com</a></strong></p>\r\n<p>Physically, these people are often slender and long. Some often walk on their toes or with a noticeable bounce.</p>\r\n<p>The sanguine temperament is seen in those people who are excited to wake up, to do new things, to meet new people, to go new places, to start a new project. Sanguines are light and gay. They easily adapt and move on from one thing to the next.</p>\r\n', '\r\n<p>Sanguines will start new projects, but rarely finish any of them. They love to meet new people, but they don\'t naturally develop deep friendships, because they are always moving on. They love to explore, but they rarely have the grounded stability that comes with \"sending down roots\" and being integral in a group or community. They love making plans, but often fail to follow through with them because they prefer \"being spontaneous\" and \"living in the moment\". They are joyous and excited and thus they sometimes ignore deeper or more difficult emotions--within themselves and within others. If left in this state, the adult with strong sanguine tendencies can be seen as \"air-headed\", lacking substance, and even superficial. They are fun to be around for a bit, but not really trusted, not really someone you can depend on. Long term commitments in relationship can be especially difficult.</p>\r\n<p>When the sanguine temperament is balanced by the other temperaments, though, this person is a ray of light and hope. Sanguines bring positivity and new outlooks. They bring folks together. Their can-do energy creates a current that sweeps others along. They can be the types of leaders that see the good in others, that see each person\'s unique gifts and finds ways to optimize these for the good of all.</p>\r\n<p>• <strong>Sanguine temperament by Rebecca Altman&nbsp;&nbsp;<a href=\"https://wonderbotanica.com/library/on-air\" target=\"_blank\" rel=\"noopener\">wonderbotanica.com</a></strong></p>\r\n<p>Sanguines move quickly, talk quickly, and are very expressive. They are full of ideas, and quick to grasp concepts. They are perfectly capable of re-assessing their opinion on something, and even changing it. Sanguines may have trouble spending hours sitting in one place and paying attention the whole time. This air of exploration is how the sanguine approaches life. They love trying new restaurants, new places, new hiking trails, new people. Making friends with strangers is a great sanguine skill.</p>\r\n<p>In balance, the sanguine is a true delight to be around: witty, fun, outgoing, charming, charismatic. The ability to ease the spirits of those around them with a burst of laughter, a giggle, a tinkling sound that dispels stagnation, breaks up the heaviness, and reminds us all of the joy and beauty in life. That light, giggling, joyful revelry is a place of comfort, and while sanguines can exist in other places (like serious topics, grief, loss, disappointment), they need to get back there to feel like themselves. This isn’t the same as avoidance of the ‘dark’ in life. I’m talking about a lightness of spirit that’s inherent, that isn’t necessarily afraid of heaviness, but doesn’t feel at its most comfortable dwelling there. Lifting spirits, easing burdens, their lightness of being affects everyone around them.</p>\r\n<p>Which isn’t to say that the sanguine isn’t capable of commitment. Some of the happiest married people I know are sanguines, but in their marriages they usually have opportunity to go out and enjoy some revelry on occasion. Freedom to revel is not the same as freedom from commitment.</p>\r\n<p>The flip-side to all this freedom is that without a grounding and calming influence, the sanguine can become erratic and ungrounded. They can start to fear the things that balance them out— relationships, commitment, stability. An imbalanced sanguine will interrupt you constantly to talk (usually about themselves), or come from the left field with random statements that hold no bearing on the conversation at hand. Their desire to be the center of attention can lead them to act out, to say wilder and wilder things, and their tendency away from self-reflection can make them look incredibly egotistical.</p>\r\n<p>Out of balance: <br />- Inability to commit to or focus on anything.<br />- Starting projects but never finishing them.</p>\r\n<p>What to know if you are a sanguine: <br />- Wait to speak. It will feel like it’s killing you at first, but you’ll find it displays a level of sensitivity that most people are unaccustomed to from you and they’ll be pleasantly surprised and in turn trust you more.<br />- If you’ve got a big project you want to get done, split it up into small, digestible parts and tackle them separately.</p>\r\n<p style=\"text-align: center;\">* &nbsp; &nbsp; * &nbsp; &nbsp; *</p>\r\n<p>✅&nbsp;<a id=\"adizes\"></a><strong>A leader with the Arsonist mismanagerial style by Ichak Adizes</strong></p>\r\n<p>In a company managed by an Arsonist, Monday mornings are dangerous, because over the weekend the Arsonist has had time to think - and guess what? New directions, new priorities, new goals, new objectives.</p>\r\n<p>An Arsonist habitually works on the “why don’t we?” principle: “Why don’t we do this?” “Why don’t we do that?” But what is a mere question for an Arsonist is assumed to be a decision by his subordinates. Sometimes they believe the boss has made a decision, so they begin to implement it and then they get penalized for acting without authorization. Then, the next time the Arsonist thinks out loud, his subordinates don’t act, thinking that this, too, just an idea. The Arsonist then becomes upset – this time because the staff didn’t implement his instructions. Subordinates feel they can never satisfy him, no matter what they do or don’t do.</p>\r\n<p>Still, the Arsonist is usually very likable, because he is stimulating, enterprising, and full of energy. Working for him can be exciting – until you figure out that no matter what you do the Arsonist will find fault with it, because his priorities are continually changing; before you’ve completed one project, he wants to know why you haven’t made any progress on a new one.</p>\r\n<p>He calls meetings frequently and without warning, whenever he has a great new idea … Do meetings led by an Arsonist have an agenda? If they do, nobody knows what it is. And even if there is one, he violates it anyway, moving from subject to subject at will or raising subjects that were not scheduled to be discussed… In conversation, the Arsonist is emotional and expressive. He uses words like “never”, “always”, “impossible”. He exaggerates in order to really push his ideas through… Because they create on the run, Arsonists often contradict themselves. The mouth is talking, the mind is working, but there isn’t necessarily a connection. He starts with one angle and changes to another angle and then a third angle, and eventually, you can’t follow what he’s saying… Yet not being understood upsets and offends Arsonists.</p>\r\n<p>Arsonist typically will develop fantastic ideas and then expect others to figure out how to implement them. If he is pressed for specifics, he gets annoyed… Details are the Arsonist’s Achilles heel. He tends to ignore details; he works with a big brush on a wide canvas, as if he were looking down from 40,000 feet at a topographical map. For an Arsonist, a million is somewhere between 700,000 and a million and half… Picture the Arsonist as an eagle, flying thousands of feet over the mountains and seeing the big picture but not the small details. From up there everything looks simple; with one movement of its wings it can fly from one boulder to another. The eagle cannot comprehend that down on the ground, in order to make the move from one location to the other, you have to go up and down mountains and canyons.</p>\r\n<p>Because he is bored by details, the Arsonist’s attitude and preferences are to decentralize. But it’s equally important for him to maintain control of the decision-making process. The result is a catch-22 for his subordinates. They are expected to decide – as long as their decisions coincide with the decision he would have made.</p>\r\n<p>Ironically, however, not much happens in a company run by an Arsonist, because he doesn’t like to finalize anything; even in midchange he might change things again in yet another, “better” direction. Every idea leads to another idea.</p>\r\n<p>The Arsonist is so preoccupied with opportunities that he sees few if any threats. He can endanger an organization by recklessly trying to exploit too many opportunities at once and spreading himself and his organization too thin… Arsonist is always talking about all the brilliant innovations he’s going to make. But how much will they cost? “These are details,” he’ll shrug. This is why an Arsonist can build a big company and lose it overnight.</p>\r\n<p style=\"text-align: right;\"><em>Excerpts from Ichak Adizes “The ideal executive” (2004), “Management/Mismanagement styles” (2004).</em></p>\r\n<p style=\"text-align: center;\">* &nbsp; &nbsp; * &nbsp; &nbsp; *</p>\r\n<p>✅<strong> <a id=\"vata\"></a>Vata dosha – Ayurveda</strong></p>\r\n<p><strong>• Vata dosha by Christine Southwell&nbsp;<a href=\"https://makingyouhealthier.com/vata-dosha/\" target=\"_blank\" rel=\"noopener\">makingyouhealthier.com</a><span></span></strong></p>\r\n<p>Goals and Focus. Vata mostly strives for CHANGE, STIMULATION AND VARIETY as their motivation is governed by light and mobile attributes. Vata’s do welcome change and will change jobs easily, seek stimulation from people or things and love a variety in life, work, travel and their partners. They may work long hours but tend to get distracted easily and flit from one thing to another. They will often be busy but not very productive. They will have lots of books or projects on the go at once as they jump around to the next ‘project’. Lack or organisation and mindfulness can lead to an untidy desk or untidy house or kitchen.</p>\r\n<p>Vata people have lots of goals and they keep changing. The imblanced vata type will have diffuculty focusing and will have a short attention span on a task. This often gets mis-diagnosed as ADHD! The out of balance vata will also have diffculty remembering things.</p>\r\n<p>Vata types are likely to be suited to jobs that require creativity, gentle movement and flow such as making or designing things, acting or teaching, dancing, writing, art, photography and travel. They may struggle in high-pressured environments such as stagnant desk work or being on a computer or helpdesk all day. Anyone who hires a vata-type would do well to give them a variety of activities or some interesting research and ensure good work breaks during the day.</p>\r\n<p><strong>• Vata dosha (various sources)</strong></p>\r\n<p>Vata dominated individuals are highly creative, intuitive, brimming with ideas, flexible and communicative. They love excitement, new experiences and are usually the first members of the group to say, “yep, I’m in. Let’s do it!” Vatas love to have a good chat and can take initiative in engaging with others. They make friends easily, as they are interested in many different things and often start new activities that involves different groups of people. They are loved for their power of inspiration, fluidity in thinking, creative and inspiring approach and their ability to change and try new things.</p>\r\n<p>Vata individuals is always up for an adventure and has an easy breezy attitude. They are easily enthused, but run the risk of spreading themselves too thin and getting distracted by something new (and supposedly better) after just a short time. They are quick on the uptake, and quick to forget. They are quick to anger or judge but also quick to forgive and move forward. Their willpower is less well developed. Their mood and energy levels change frequently and they get exhausted easily emotionally and physically. On the upside, their mood can just as quickly change from bad to good and they become upbeat and positive easily.</p>\r\n<p>Their body is usually lean/slim/skinny and they find it difficult to keep weight on – they are the type of person many envy in the fact that they can eat a lot but never gain weight.</p>\r\n<p>The following are some of the most prevalent traits of persons who are Vata dominant:<br />- Their activities and interests change frequently as they constantly seek new experiences<br />- They are very imaginative and tend to be abstract thinkers.<br />- They may be unpredictable.<br />- They become bored with monotonous work and want variation in their life.</p>\r\n<p>People with a dominating Vata excel in professions that require imagination, creativity, and communication. As a result, careers in media, education, research and development, marketing, advertising, and writing may be a good fit. In the workplace, vata types can inspire new and innovative ideas. They think outside of the box and can dream up new operating procedures and ways for the staff to connect outside of the office in team-building excursions and activities.</p>\r\n<p style=\"text-align: center;\">* &nbsp; &nbsp; * &nbsp; &nbsp; *</p>\r\n<p>&nbsp;✅ <a id=\"jungne\"></a><strong>Type Intuition Extraverted – Carl Gustav Jung \"Psychological Types\"</strong>, 1921.</p>\r\n<p>The intuitive is never to be found among the generally recognized reality values, but he is always present where possibilities exist. He has a keen nose for things in the bud pregnant with future promise. He can never exist in stable, long-established conditions of generally acknowledged though limited value: because his eye is constantly ranging for new possibilities, stable conditions have an air of impending suffocation. He seizes hold of new objects and new ways with eager intensity, sometimes with extraordinary enthusiasm, only to abandon them cold-bloodedly, without regard and apparently without remembrance, as soon as their range becomes clearly defined and a promise of any considerable future development no longer clings to them...</p>\r\n<p>It is at once clear, both from the standpoint of political economy and on grounds of general culture, that such a type is uncommonly important. If well-intentioned, with an orientation to life not purely egoistical, he may render exceptional service as the promoter, if not the initiator of every kind of promising enterprise. He is the natural advocate of every minority that holds the seed of future promise. Because of his capacity, when orientated more towards men than things, to make an intuitive diagnosis of their abilities and range of usefulness, he can also \'make\' men. His capacity to inspire his fellow-men with courage, or to kindle enthusiasm for something new, is unrivalled, although he may have forsworn it by the morrow...</p>\r\n<p>The intuitive may squander his life. He spends himself animating men and things, spreading around him an abundance of life -- a life, however, which others live, not he. Were he able to rest with the actual thing, he would gather the fruit of his labours; yet all too soon must he be running after some fresh possibility, quitting his newly planted field, while others reap the harvest. In the end he goes empty away.</p>\r\n<p style=\"text-align: right;\"><em>(C. G. Jung. Psychological Types. X GENERAL DESCRIPTION OF THE TYPES&nbsp;B. The Extraverted Type 8. Intuition 9. The Extraverted Intuitive Type)</em></p>\r\n<p>Just as the <strong>extraverted intuitive</strong> is continually scenting out new possibilities, which he pursues with an equal unconcern both for his own welfare and for that of others, pressing on quite heedless of human considerations, tearing down what has only just been established in his everlasting search for change, so the introverted intuitive moves from image to image, chasing after every possibility in the teeming womb of the unconscious, without establishing any connection between the phenomenon and himself. Just as the world can never become a moral problem for the man who merely senses it, so the world of images is never a moral problem to the intuitive.</p>\r\n<p style=\"text-align: right;\"><em>(C. G. Jung. Psychological Types. X GENERAL DESCRIPTION OF THE TYPES C. The Introverted Type 8. Intuition)</em></p>\r\n<p><em>Last updated 02.12.2024</em></p>\r\n<p style=\"text-align: right;\"><em>Text in Ukrainian is here&nbsp;<a href=\"https://7promeniv.com.ua/korotki-opysy-typiv/3188-ne-u-riznykh-typolohichnykh-modeliakh.html\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></p>', '1', '33', '2024-04-29 14:40:17', '309', '', '2024-12-02 15:43:53', '309', NULL, NULL, '2024-04-29 14:40:17', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '24', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('87', '235', 'Ni in different typological models ', 'ni-in-different-typological-models', '<h2 style=\"text-align: center;\"><strong>INTUITION INTROVERTED TYPE - NI - IN DIFFERENT TYPOLOGICAL MODELS</strong></h2>\r\n<p>Jungian <a href=\"en/8-types/intuition-introverted\" target=\"_blank\" rel=\"noopener\">INTUITION Introverted Type</a> (Ni) can be found under different names in different typological models:<br />• Orphan, Innocent, Artist – archetypes<br />• <a href=\"#rubu\">Pisces</a> - Zodiac Sign Personality Traits<br />• Moon: <a href=\"#lune\">Lunarian personality</a> - planetary typology, Leon Vannier, Joel Friedlander, Susan Zannos<br />•&nbsp;The wound of Abandonment and the Dependent Mask by Lise Bourbeau<br />• <a href=\"#beili\">Ray Four</a> - Seven Rays typology<br />• <a href=\"#gaze\">The noble gases </a>– typology of chemical elements<br />• Type 4,6 – Enneagram<br /><br /></p>\r\n<p style=\"text-align: center;\">*&nbsp; &nbsp; &nbsp; &nbsp; *&nbsp; &nbsp; &nbsp; &nbsp; *</p>\r\n<p>✅ <a id=\"rubu\"></a><strong>Pisces -&nbsp;Zodiac Sign Personality Traits&nbsp;</strong></p>\r\n<p><strong>• Pisces by Annabel Gat and Randon Rosenbohm&nbsp;<a href=\"https://www.vice.com/en/article/pisces-personality-traits-everything-you-need-to-know/\" target=\"_blank\" rel=\"noopener\">www.vice.com</a></strong></p>\r\n<p>Pisces is often referred to as the dreamer of the zodiac… They’re often looking to the future, dreaming of a better way for things to be. They may have a rich fantasy world, which can distract them from everyday life and inspire their art. They may also have a deep connection with the dreams they have at night.</p>\r\n<p>Pisces’s reputation is an interesting one: They are regarded as deep thinkers but are also often labeled as ditzy… Their feelings can be so big that their attention span becomes warped, and they need to be mindful of time and appointments by keeping a planner… As private as Pisces can be, they can also be very hospitable, and they like to have a revolving door of houseguests, neighbors, and visiting family members.</p>\r\n<p>Their symbol is illustrated as two fish swimming in different directions: this bidirectionality reflects Pisces’ many sides. Pisces can have their head in the clouds and be exploring oceanic emotions at the same time. They are also very good at making sense of conflicting information, so they can hold many ideas in their mind at once. They can understand a story from many perspectives. They may hold two perspectives at once and not feel conflicted about it. They know that everyone has their own version of the truth and that each point of view has its own value.</p>\r\n<p>Some astrologers describe Pisces as being wishy-washy or even a doormat, but the shark teeth can come out someone challenges their ability to create art, whether that’s a lover who won’t leave in the morning and let them get to recording their next album, a teacher who doesn’t understand Pisces’s work, or society at large poopooing their process.</p>\r\n<p>Pisces and friendship. They take their friendships, and their participation in social groups, very seriously… Emotional depth is crucial in all their relationships, romantic and platonic. They need to be able to go deep with you, and they value friends who are trustworthy and willing to explore life’s intensity… If you have a Pisces friend, you’ll often find that they can compute your many feelings as if they were a little emotional calculator, spitting out the total sum of your experience back at you, teaching you about connections you hadn’t previously realized, details you had missed, and perspectives that were out of view.</p>\r\n', '\r\n<p>It’s really a mixed bag with Pisces. Some are very confrontation-averse, and if they ghost you, it might be because they are worried about arguing with you. Fish are slippery, and ghosting might be a way that this slippery quality manifests for Pisces… Pisces has a reputation for being passive. This might be one that they have cultivated because they really try to get along with everyone—plus, they’re extremely adaptable, and they know they can make nearly any situation work… If Pisces doesn’t have a strong opinion, they are very flexible, but when Pisces has one, they will stick to it. They can be very stubborn. But this stubbornness doesn’t reveal itself right away. Pisces knows the power of timing. They’ll let you paint the room whatever color you want… and when they don’t pitch in to make the room work, they’ll repaint it the color they’ve chosen after you’ve conceded that you were wrong. This knowledge of timing, the patience to wait, is one of Pisces’s great assets, and their daily routine could be set up around quite a few very long-term goals.</p>\r\n<p>Pisces are often interested in research, eager to dig beneath the surface and find the secrets buried beneath. This may find them studying archeology, psychology, medicine, science, or other subjects that center on research and discovery. Literature also draws romantic Pisces, and art is an obvious choice for this creative water sign… They are attracted to fringe ideas. They are happy to fact-check conspiracy theories, and they’re not afraid of playing with intellectual fire… The intersection between spirituality and quantum physics inspires them… They are deep thinkers and cut out for work in the field of higher thought, education, publishing, or philosophy. They’d love a job with travel perks or that can fly them around the world!</p>\r\n<p><strong><strong>•&nbsp;</strong>Pisces&nbsp;&nbsp;<a href=\"https://www.horoscope.com/zodiac-signs/pisces\" target=\"_blank\" rel=\"noopener\">www.horoscope.com</a></strong></p>\r\n<p>Smart, creative, and deeply intuitive… A Pisces \"knows\" things from deep within, and can often judge whether a person or situation is good or bad… Their great intuition can guide them well, and help them make creative or intellectual leaps other people might not be able to see or consider. \"My Intuition leads me where I need to be.\"… Learning to let go, let things flow, and that nothing can be guaranteed can allow Pisces to change course mid-stream, try new avenues.</p>\r\n<p>Deeply imaginative, Pisces can happily spend hours daydreaming… A Pisces can sometimes seem chilly and reserved to acquaintances, and it may seem hard to pull them out of their shell… Pisces signs are sensitive… They may feel exhausted by large gatherings. One on one gatherings or intimate groups—even if the conversations get intense— are preferable to Pisces.</p>\r\n<p>They have a \"live and let live\" approach when it comes to others, and are accepting and nonjudgmental of all… What other people do is their business, but they\'ll always take the time to listen to them and offer their thoughts and opinions — but only if asked… They have a unique way of seeing the world… The realization that life is so much more than what we see. Pisces sign is in tune with the magic of everyday existence and can find beauty in all situations, even ones that may cause tears… they\'ll let you go to the depths of despair, staying by your side the whole time.</p>\r\n<p>Work. Pisces like to work flexible hours and need an unstructured environment, they can use their intuition and imagination. Pisces tend to do their best work solo… The idea of working in an open-plan office with set hours can make the skin of a Pisces crawl.</p>\r\n<p>Relationship. A relationship with a Pisces is a roller-coaster ride that will make you feel your feelings—even the bad ones—and help you emerge as a better, more honest person… Pisces demands full presence in a relationship, and is especially hurt by any sort of deception. A Pisces demands full honesty and gives the same in return… A Pisces can sometimes \"feel\" your mood, even if you don\'t voice what you\'re feeling or thinking, so being able to meet them where they \"feel\" you is essential. In other words, don\'t say everything\'s fine if it\'s not.<br />Unique and free thinkers, Pisces respect each other\'s space.</p>\r\n<p style=\"text-align: center;\">*&nbsp; &nbsp; &nbsp; &nbsp; *&nbsp; &nbsp; &nbsp; &nbsp; *</p>\r\n<p>✅ <a id=\"lune\"></a><strong>The Lunar Type - Joel Friedlander</strong>, Body Types: The Enneagram of Essence Types, 1993</p>\r\n<p>The Lunar is not a vibrant type, and they won’t grab your attention in passing. The women have a doe-like look, and many don’t want to attract attention. The men seem vulnerable, with a limpid sensitivity that can magnify the feminine element intrinsic to this type.</p>\r\n<p>Lunar feelings, like still waters, run deep… Lunars hide themselves, their ideas, and their activities more than any other type. They’re not compelled, like others, to advertise themselves, and don’t need your approval for motivation. Besides being naturally shy, they doubt you’re interested in them anyway… Lunars wear dark clothes that they hope will make them invisible, or at least anonymous… But to us, the same aloofness gives Lunars an air of mystery; they seem inscrutable, opaque.</p>\r\n<p>We admire Lunars for their persistence, a never-quit approach to something once they’re started. This persistence seems like loyalty, and makes them tough and dependable. Makes them real supporters, tireless workers for the cause.</p>\r\n<p>They squint in the light of publicity or acclaim, and can’t wait to return to the solitude of their studies… The coolness that so infuriates us in Lunars – their ability to ignore us completely, to remain aloof, to hide their feelings – also has another side. You’ll see it in times of stress or danger when others may be tossed about by their emotions and reactions, and when Lunars remain composed, unmoved.</p>\r\n<p>Moods carry them from one extreme to another, from childish expectation to depression, from persistent action to despair… He feels that he’s a person who is bound to fail, and this feeling darkens his entire view of the world… Without some jolt from necessity, or without a favorable circumstance, they slide back into inertia.</p>\r\n<p>It’s easy to like Lunars; you want to protect them. Those tall, judicial types we frequently see with are Saturns searching for someone to protect, someone to save.</p>\r\n<p style=\"text-align: center;\">*&nbsp; &nbsp; &nbsp; &nbsp; *&nbsp; &nbsp; &nbsp; &nbsp; *</p>\r\n<p>✅ <a id=\"beili\"></a><strong>Ray Four - Harmony through Conflict, Alice Bailey - A Treatise on the Seven Rays</strong></p>\r\n<p>Ray four is often called the “ray of struggle” for this ray, the quality of rajas (activity) and tamas (inertia) are so strangely equal in proportion that the nature of the 4th Ray man is torn with the combat… Tamas induces love of ease and pleasure, a hatred of causing pain amounting to moral cowardice, indolence, procrastination, a desire to let things be, to rest and take no thought of the marrows. Rajas is fiery, impatient, ever urging to action. These contrasting forces in the nature make life one perpetual warfare and unrest for the 4th Ray man… It is the ray of the dashing cavalry leader, reckless of risks to himself or his followers. It is the ray of the man who will lead a forlorn hope.</p>\r\n<p>It is pre-eminently the ray of colour, of the artist whose colour is always great, though his drawing will often be defective… If the 4th Ray man is untrained as an artist, a colour sense is sure to appear in other ways, in choice of dress or decorations. In music, Ray four compositions are always full of melody, and the 4th Ray man loves a tune. As a writer or poet, his work will often be brilliant and full of exaggerations and often pessimistic. He will generally talk well and have a sense of humour but he varies between brilliant conversations, and gloomy silences, according to his mood.</p>\r\n<p>The method of approaching the Path will be self-control thus gaining equilibrium amongst warring forces of the nature.</p>\r\n<p>Ray four will work out in the following ways: In the development of the intuition by the means of knowledge of sound vibration, and the higher mathematics.</p>\r\n<p>Their major task is to harmonise the new ideas with the old, so that there can be no dangerous gap. They participate in the bridging process, for they are the true intuitives.</p>\r\n<p style=\"text-align: center;\">*&nbsp; &nbsp; &nbsp; &nbsp; *&nbsp; &nbsp; &nbsp; &nbsp; *</p>\r\n<p>✅<strong> <a id=\"gaze\"></a>The noble gases – typology of chemical elements, Jan Scholten</strong></p>\r\n<p>The noble gases form a family, grouped together not only by their placement in the periodic table but also by a common theme.</p>\r\n<p><strong>The Helium</strong> picture <a href=\"https://qjure.com/remedy/helium/\" target=\"_blank\" rel=\"noopener\">qjure.com</a><br />Autism is a very appropriate word for Helium. They don’t feel like entering this world. They prefer to stay in themselves to experience their own being… Their behaviour makes is very difficult to understand for other people. You can’t get a grip on them, as if they are slipping away through your fingers each time you try and establish contact… they don’t interact with the outside world. It is as if they only act from within themselves.</p>\r\n<p>Picture of <strong>Neon</strong>: he does not feel inclined to enter into a relationship with other people yet. He would rather stay within his own world for a little while. It is as if they want to have a break from all the physical exertion, to enjoy their own values and not have to do anything… They like to be free, not only free from other people, but free in general... This desire shows itself in the sensation of being ‘spaced out’, light, floating etc... They have no other desires, they don’t need food, possessions or company… They feel absent-minded and timeless… They also dreamt that events happened in reverse order, the future coming before the past. Their sense of space is also disturbed: they can be so disorientated that it is not safe for them to drive a car… They don’t know left from right anymore etc.</p>\r\n<p>Picture of <strong>Argon</strong>: They feel happy and carefree. They don’t have to do a lot for their relations and they also leave others free to do what they want… They don’t want to have anything to do with work or duty. It is as if they even deny the existence of duty… they are a bit noncommittal, they don’t really get involved with anyone on a deeper level… They do have contact with their various relations, but they don’t do anything special, they let things take their own course.</p>\r\n<p>Picture of <strong>Krypton</strong>: They have finished their work and now they are having a rest... Guilt is not an issue anymore, even when they are completely idle. They feel inclined to withdraw to a cave or to a monastery… they want to delve into the deeper meaning, the mystical aspects of life.</p>\r\n<p>Picture of <strong>Xenon</strong>: They don’t have to develop any new ideas, they don’t have to support any more ideals, they don’t mind who thinks what, they are free to do as they please… They don’t feel like getting involved in any power struggle. They even deny the existence of power… They may feel like a stranger in their own country. They don’t really feel a very strong connection. Nationalism is a concept that is alien to their way of thinking… They can travel around the world and be invisible.</p>\r\n<p>Picture of <strong>Radon</strong>: They are no longer tied to any organisation or any structure. They are almost a stranger in their own land. People often think of them as estranged from the world… They are like the sage, free of arrogance, free of lust for power.</p>\r\n<p><em>Last updating 06.03.2025</em></p>', '1', '34', '2025-02-23 09:35:41', '309', '', '2025-09-16 06:46:26', '309', NULL, NULL, '2025-02-23 09:35:41', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '26', '1', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', ''),
('88', '236', 'roles sociaux', 'roles-sociaux', '<h2 style=\"text-align: center;\"><strong>LES RÔLES SOCIAUX</strong></h2>\r\n<p style=\"text-align: right;\">English version <a href=\"en/8-types/85-social-roles\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p style=\"text-align: center;\">Comment chacun des 8 types de personnalité de Jung se manifeste dans la vie sociale</p>\r\n<p>Le rôle social est une sorte de portrait social d’une personne, psychologiquement mature, d’un certain type, et qui utilise de manière constructive ses qualités. Elle le fait à la fois pour sa propre adaptation sociale et pour le bien commun. Chacun des 8 types est caractérisé par des prédispositions innées à une activité particulière. Les forces d’une personne résonnent avec la demande correspondante de la société. C’est la condition principale pour la vocation réussie d’une personne, pour qu’elle se sente heureux et à sa place.</p>\r\n<p>Chacun des huit rôles sociaux est une conséquence naturelle de la manifestation de l’une des huit fonctions psychologiques jungiennes.</p>\r\n<p>La maturité croissante ou le stress croissant d’une personne ont une influence significative sur la façon dont la personne exprime son type. Si une personne a beaucoup de conflits internes, alors une grande partie de ses efforts et de son énergie est consacrée à ces conflits. Elle n’a donc pas la force de réaliser son potentiel pour le bien de la société et de remplir un rôle social. Le rôle social d’une telle personne est déformé par la manipulation et divers jeux névrotiques destructeurs. Chaque type a ses propres manipulations.</p>\r\n<p>&nbsp;...</p>\r\n<p>l\'ancien article sur les rôles sociaux est ici <a href=\"https://7promeniv.com.ua/descriptions-de-huit-types/2677-roles-sociaux.html\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></p>\r\n<p style=\"text-align: center; text-indent: 1px;\"><a href=\"images/typo/Fr/8types/Jung_soc_roli_fr.jpg\" class=\"jcepopup\" data-mediabox=\"1\" data-mediabox-width=\"100%\"><img src=\"images/typo/Fr/8types/Jung_soc_roli_fr.jpg\" alt=\"\" width=\"70%\" /></a></p>\r\n<p>&nbsp;</p>\r\n<p><em>Dernière mise à jour 12.03.2025</em></p>', '', '1', '30', '2025-03-12 06:06:51', '309', '', '2025-03-12 06:51:30', '309', NULL, NULL, '2025-03-12 06:06:51', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '5', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'fr-FR', ''),
('90', '238', 'Ni male portrait', 'ni-male-portrait', '<h2 style=\"text-align: center;\"><strong>NI - MALE PORTRAIT&nbsp;&nbsp; </strong></h2>\r\n<p>Intuition Introverted type (Ni) - male portrait</p>\r\n<p>Ni type man is highly intuitive, he is receptive to deep, hidden meanings, and naturally reads between the lines. He quickly sniffs out lies and hidden motives. Notices details, feels the flow of time, anticipates how a situation will unfold over time, and knows how to move away from danger in advance.</p>\r\n<p>Ni takes an individual approach to each person. He is able to listen carefully to another without judging, resonate with his or her deep world, and reflect it, bringing to light what was hidden in the shadows. Likes to explore negative experiences; one can talk to him about painful feelings and cry together. Ni type men often choose the career of a psychologist.</p>\r\n<p>In social settings, Ni man may come across as shy and taciturn. Many have an inconspicuous look and don’t want to attract attention.&nbsp;Ni men often wear dark clothes that they hope will make them anonymous. Their reserved facade often hides their passionate and sensitive inner turmoil.&nbsp;This inner focus makes them mysterious and enigmatic to many people. You can’t get a grip on them, as if they are slipping away through your fingers. Vagueness and elusiveness are very characteristic of Ni men.</p>\r\n<p>Ni type men are prone to an <a href=\"en/4-styles\" target=\"_blank\" rel=\"noopener\">INTEGRATING interaction style</a>. People with this style are&nbsp;cautious in communication. They show diplomacy, avoid being direct and categorical in their statements. Do not argue, even if disagreeing, tend to&nbsp;tergiversate&nbsp;instead of answering the direct question to avoid conflict. They do not oppose openly something. If they don\'t want to do something, they passively resist or discreetly sabotage.</p>\r\n', '\r\n<p>People with the Integrating style are&nbsp;spontaneous, flexible, and spur-of-the-moment, they are at ease in the unpredictable, are able to go with the flow and adapt to changes, provided it’s not too fast and too abrupt. All thoughts, ideas, and plans, however final they seem, are subject to last-minute changes when “new data” become available. Therefore, they are not in a hurry to make promises because they don\'t know how the circumstances will develop, they want to have an open choice.&nbsp;They may appear inconsistent, ambiguous, and unpredictable.</p>\r\n<p>Ni types get along well in small groups of people where they are likely to share jokes, ideas, whimsical thought, and many inventive theories. They\'re well with kids. They support each child’s pursuit of his or her own course.</p>\r\n<p>Ni man is a daydreamer who can easily escape into a world of fantasy from the harsh realities of life.&nbsp;In the sensation of being spaced out, light, and floating he perceives the unconscious images, produced in such inexhaustible abundance by&nbsp;his imagination. Balancing the practical demands of the physical world with the allure of his inner realm can be a constant challenge. He often lacks the self-confidence to take action in the physical world.&nbsp;May think everything through in his mind, but never actually start putting his ideas into reality.</p>\r\n<p>Prone to take a passive approach to life he largely prefers to let events decide for him. Doesn’t interfere in anything and doesn’t impose anything. He has an unhurried pace, hesitates for a long time before making a decision. Avoids risks. Without external impulse or external motivation, he can remain in a state of inertia for a long time.</p>\r\n<p>Ni type men can move forward with confidence if they feel that they have sufficient backup. They realize that people are weak alone, but together they are a great force. Therefore, Ni type people tend to join together with others, maintain alliances and associations to achieve a common goal: survival, defense, realization of the idea.</p>\r\n<p>The men with this type of personality often are a bundle of opposites. They are both strong and weak, fearful and courageous, defenders and provokers, group people and soloists. The Ni male often seem vulnerable and anxious, which can magnify the feminine element.</p>\r\n<p>Such men can be seen by others, particularly macho traditionalists, as too gentle, even wimpy. To counter the image of being weak and feel safe, many of them enhance physical strength and physical attractiveness by spending time in gyms.</p>\r\n<p><strong>Relationship</strong>. Ni man doesn’t share his inner world with just anyone. He needs to sense trust, and authenticity before opening up.&nbsp;He demands full honesty from his mate and gives the same in return. Thanks to his developed intuition, he quickly realizes when someone is being dishonest. he’ll sense if you’re forcing things or playing games.</p>\r\n<p>When he falls in love, he’ll remain faithful and devoted. He’ll include his mate in his creative pursuits and look for ways to support her dreams. Ni type man respects other\'s space, he leaves his partner free to do what she wants: \"whatever you want to do is fine.\" He’s more comfortable letting his mate take the lead in relationship. He feels at ease near grounded, practical woman connected to the material world who can bring him back from his reveries to earth and provide him with a sense of stability and security.</p>\r\n<p>Ni man is open to experimentation <strong>in the bedroom</strong>. He needs forceful pressure and confrontation, he wants his partner to conquer and subdue him. Thanks to his creativity and nonjudgmental nature he’s down to try just about any fantasy of his partner.</p>\r\n<p>&nbsp;</p>\r\n<p><em>Last updating 02.12.2025</em></p>\r\n<p style=\"text-align: right;\"><em>Українською тут&nbsp;<a href=\"https://7promeniv.com.ua/korotki-opysy-typiv/3212-ni-cholovichyi-portret\" target=\"_blank\" rel=\"noopener\">&gt;&gt;&gt;</a></em></p>', '1', '34', '2025-11-30 17:07:49', '309', '', '2025-12-02 06:45:40', '309', NULL, NULL, '2025-11-30 17:07:49', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"flags\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '13', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', 'en-GB', '');/**ABDB**/
