/* jce - 2.9.97 | 2025-12-15 | https://www.joomlacontenteditor.net | Source: https://github.com/widgetfactory/jce | Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved | GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html */
var tinyMCEPopup = {
    init: function() {
        var tinymce = this.getWin().tinymce || !1;
        this.editor = !!tinymce && tinymce.EditorManager.activeEditor;
    },
    getLang: function(n, dv) {
        var lang = jQuery.Plugin.getLanguage();
        return jQuery.Plugin.i18n[lang + ".dlg." + n] || dv;
    },
    getWin: function() {
        return !window.frameElement && window.dialogArguments || opener || parent || top;
    },
    getParam: function(n, v) {
        if (this.editor) return this.editor.getParam(n, v);
    },
    storeSelection: function() {
        this.editor.windowManager.bookmark = this.editor.selection.getBookmark(1);
    },
    restoreSelection: function() {
        this.editor.selection.moveToBookmark(this.editor.windowManager.bookmark);
    },
    execCommand: function(cmd, ui, val, a) {
        return (a = a || {}).skip_focus = 1, this.restoreSelection(), this.editor.execCommand(cmd, ui, val, a);
    },
    addI18n: function(p, o) {
        var win = this.getWin();
        return (win.tinyMCE || jQuery.Plugin).addI18n(p, o);
    }
};

function debounce(callback, time) {
    var timer, func = function() {
        var args = arguments;
        clearTimeout(timer), timer = setTimeout(function() {
            callback.apply(this, args);
        }, time);
    };
    return func.stop = function() {
        clearTimeout(timer);
    }, func;
}

function hasCustomEditorInit(ed) {
    return !(!window.parent || !window.parent.widgetkit || -1 === ed.id.indexOf("wk_")) || -1 !== ed.id.indexOf("sppb-editor-");
}

tinyMCEPopup.init(), window.tinyMCE = {
    addI18n: function(p, o) {
        return tinyMCEPopup.addI18n(p, o);
    }
}, function($) {
    window.SourceEditor = {
        options: {
            format: !0,
            width: "100%",
            height: "100%",
            theme: "codemirror",
            font_size: "",
            load: function() {},
            change: function() {},
            fullscreen: !1,
            editor: {},
            format_options: {}
        },
        init: function(options, content, selection) {
            var self = this;
            $.extend(this.options, options), $(document).ready(function() {
                self.options.format && (content = self._format(content)), self._load(content);
            });
        },
        execCommand: function(cmd) {
            var args, fn = this[cmd] || function() {};
            return 1 < arguments.length && (args = Array.prototype.slice.call(arguments, 1)), 
            fn.apply(this, args);
        },
        formatHTML: function(html, options) {
            return options = $.extend({
                max_char: 0,
                wrap_line_length: 0,
                inline: [ "a", "abbr", "b", "bdi", "bdo", "br", "cite", "code", "data", "del", "dfn", "em", "i", "img", "ins", "kbd", "keygen", "map", "mark", "math", "meter", "noscript", "output", "progress", "q", "ruby", "s", "samp", "small", "span", "strong", "sub", "sup", "time", "u", "var", "wbr", "text", "acronym", "big", "strike", "tt" ]
            }, this.options.format_options), html = "undefined" != typeof html_beautify ? html_beautify(html, options) : html;
        },
        _format: function(html, validate) {
            return this.formatHTML(html);
        },
        _load: function(content, selection) {
            var cm, settings, source, o = this.options;
            window.CodeMirror && ("codemirror" == o.theme && (o.theme = "default"), 
            settings = {
                mode: "text/html",
                theme: o.theme,
                indentWithTabs: !0,
                smartIndent: !0,
                tabMode: "indent",
                styleActiveLine: !0,
                highlightSelectionMatches: !!o.selection_match,
                autoCloseTags: !!o.tag_closing,
                foldGutter: !0,
                gutters: [ "CodeMirror-linenumbers", "CodeMirror-foldgutter" ],
                widget: "..."
            }, (cm = CodeMirror($(".source-editor-container").get(0), settings)).activeLine = 0, 
            cm.setWrap = function(s) {
                cm.setOption("lineWrapping", s);
                try {
                    cm.focus();
                } catch (e) {}
            }, o.font_size && (/px/.test(o.font_size) || (o.font_size += "px"), 
            cm.getWrapperElement().style.fontSize = o.font_size), cm.showGutter = function(s) {
                cm.setOption("lineNumbers", s);
                try {
                    cm.focus();
                } catch (e) {}
            }, cm.highlight = function(s) {
                var c = cm.getCursor();
                s ? cm.setOption("mode", "text/html") : cm.setOption("mode", "text/plain"), 
                cm.setCursor(c);
                try {
                    cm.focus();
                } catch (e) {}
            }, cm.resize = function(w, h, init) {
                cm.setSize(w || null, h);
            }, cm.showInvisibles = function(s) {}, cm.setContent = function(v) {
                cm.setValue(v);
                try {
                    cm.focus();
                } catch (e) {}
            }, cm.insertContent = function(v) {
                return cm.replaceSelection(v);
            }, cm.getContent = function() {
                return cm.getValue().replace(/^\s*|\s*$/g, "");
            }, cm.getSearchState = function() {
                return cm.state.search || (cm.state.search = new function() {
                    this.posFrom = this.posTo = this.query = null, this.marked = [];
                }());
            }, cm.clearSearch = function() {
                cm.operation(function() {
                    var state = cm.getSearchState(cm);
                    if (state.query) {
                        state.query = null;
                        for (var i = 0; i < state.marked.length; ++i) state.marked[i].clear();
                        state.marked.length = 0, cm.removeOverlay(state.overlay);
                    }
                });
            }, cm.search = function(query, rev, re) {
                function getSearchCursor(cm, query, pos) {
                    return cm.getSearchCursor(query, pos, "string" == typeof query && query == query.toLowerCase());
                }
                function findNext(cm, rev) {
                    cm.operation(function() {
                        var state = cm.getSearchState(), cursor = getSearchCursor(cm, state.query, rev ? state.posFrom : state.posTo);
                        (cursor.find(rev) || (cursor = getSearchCursor(cm, state.query, rev ? CodeMirror.Pos(cm.lastLine()) : CodeMirror.Pos(cm.firstLine(), 0))).find(rev)) && (cm.setSelection(cursor.pos.from, cursor.pos.to), 
                        state.posFrom = cursor.pos.from, state.posTo = cursor.pos.to, 
                        cm.scrollIntoView(cursor.pos.from));
                    });
                }
                re && (query = new RegExp(query)), cm.getSearchState(cm).query !== query && cm.clearSearch(), 
                function(cm, rev, query) {
                    var state = cm.getSearchState(cm);
                    state.query ? findNext(cm, rev) : query && (state.query = query, 
                    cm.removeOverlay(state.overlay), state.overlay = function(query) {
                        return "string" == typeof query ? {
                            token: function(stream) {
                                if (stream.match(query)) return "searching";
                                stream.next(), stream.skipTo(query.charAt(0)) || stream.skipToEnd();
                            }
                        } : {
                            token: function(stream) {
                                if (stream.match(query)) return "searching";
                                for (;!stream.eol() && (stream.next(), !stream.match(query, !1)); );
                            }
                        };
                    }(state.query), cm.addOverlay(state.overlay), state.posFrom = state.posTo = cm.getCursor(), 
                    findNext(cm, rev));
                }(cm, rev, query);
            }, cm.replace = function(query, text, all, re) {
                function getSearchCursor(cm, query, pos) {
                    return cm.getSearchCursor(query, pos, "string" == typeof query && query == query.toLowerCase());
                }
                if (re && (query = new RegExp(query)), all) for (var cursor = getSearchCursor(cm, query); cursor.findNext(); ) if ("string" != typeof query) {
                    var match = cm.getRange(cursor.from(), cursor.to()).match(query);
                    if (!match) return;
                    cursor.replace(text.replace(/\$(\d)/g, function(w, i) {
                        return match[i];
                    }));
                } else cursor.replace(text); else {
                    cm.clearSearch();
                    cursor = getSearchCursor(cm, query, cm.getCursor());
                    !function() {
                        var match, start = cursor.pos.from;
                        !(match = cursor.findNext()) && (cursor = cm.getSearchCursor(query), 
                        !start || !(match = cursor.findNext()) || cursor.pos.from.line == start.line && cursor.pos.from.ch == start.ch) || (cm.setSelection(cursor.pos.from, cursor.pos.to), 
                        function(match) {
                            cursor.replace("string" == typeof query ? text : text.replace(/\$(\d)/, function(w, i) {
                                return match[i];
                            }));
                        }(match), cm.setCursor(cursor.pos.to), cm.scrollIntoView(cursor.pos.to)), 
                        cm.focus();
                    }();
                }
            }, cm.format = function() {
                CodeMirror.commands.selectAll(cm);
                var range = {
                    from: cm.getCursor(!0),
                    to: cm.getCursor(!1)
                };
                cm.autoFormatRange(range.from, range.to);
            }, cm.setCursorPos = function(pos) {
                cm.setCursor({
                    line: pos,
                    ch: 0
                }, {
                    scroll: !1
                });
                var doc = cm.getDoc(), cursor = doc.getCursor(), doc = doc.getLine(cursor.line);
                cm.setCursor({
                    line: pos,
                    ch: doc.length
                }, {
                    scroll: !0
                }), cm.activeLine = pos;
            }, cm.getCursorPos = function() {
                return cm.getCursor().line || cm.activeLine || 1;
            }, cm.on("mousedown", function() {
                window.setTimeout(function() {
                    cm.activeLine = cm.getCursor().line;
                }, 10);
            }), cm.on("keyup", function() {
                window.setTimeout(function() {
                    cm.activeLine = cm.getCursor().line;
                }, 10);
            }), o.font_size && (/[^\D]/.test(o.font_size) && (o.font_size += "px"), 
            cm.getWrapperElement().style.fontSize = o.font_size), this.editor = cm, 
            this._loaded(content), selection && cm.search(selection), cm.on("change", function(e, obj) {
                o.change.call();
            }), settings = o.editor, (source = settings.plugins.source) && hasCustomEditorInit(settings) && (content = debounce(function(e) {
                var value;
                cm.isActive && (value = (value = cm.getValue()).replace(/^\s*|\s*$/g, ""), 
                source.save(value, !0));
            }, 300), cm.on("change", content), cm.on("blur", content)), cm.refresh(), 
            cm.isActive = !0);
        },
        _loaded: function(content) {
            var o = this.options;
            this.setContent(content), this.wrap(!!o.wrap), this.linenumbers(!!o.linenumbers), 
            o.load.call(), this.focus();
        },
        search: function(find, rev, re) {
            return this.editor.search(find, rev, re);
        },
        replace: function(find, replace, all, re) {
            return this.editor.replace(find, replace, all, re);
        },
        clearSearch: function() {
            return this.editor.clearSearch();
        },
        getSelection: function() {
            return this.editor.getSelection();
        },
        setSelection: function(line, value) {
            return this.editor.setSelection({
                line: line,
                ch: 0
            }, {
                line: line,
                ch: value.length
            });
        },
        wrap: function(s) {
            return this.editor.setWrap(s);
        },
        linenumbers: function(s) {
            return this.editor.showGutter(s);
        },
        highlight: function(s) {
            return this.editor.highlight(s);
        },
        setContent: function(v, format) {
            return format && (v = this._format(v)), this.editor.setContent(v);
        },
        insertContent: function(v) {
            return this.editor.insertContent(v);
        },
        getContent: function() {
            return this.editor.getContent();
        },
        save: function() {
            return this.editor.getContent();
        },
        showInvisibles: function(s) {
            return this.editor.showInvisibles(s);
        },
        setCursor: function(line) {
            return this.editor.setCursorPos(line);
        },
        getCursorPos: function() {
            return this.editor.getCursorPos();
        },
        resize: function(w, h, init) {},
        focus: function() {
            return this.editor.focus();
        },
        undo: function() {
            return this.editor.undo(), this.focus(), this.editor.historySize().redo;
        },
        redo: function() {
            return this.editor.redo(), this.focus(), this.editor.historySize().redo;
        },
        indent: function() {},
        getContainer: function() {
            return this.container || null;
        },
        format: function() {
            var html = this.getContent(), html = this._format(html);
            this.setContent(html);
        },
        fullscreen: function() {
            var ed = tinyMCEPopup.editor;
            if (ed) return ed.execCommand("mceFullScreen", !1);
        },
        setActive: function(state) {
            this.editor.isActive = !!state;
        }
    };
}(jQuery);