<?php 
/**
 * @package Module EB Ajax Search for Joomla!
 * @version 2.1: mod_ebajaxsearch.php Oct 2025
 * @author url: https://www/extnbakers.com
 * @copyright Copyright (C) 2022 extnbakers.com. All rights reserved.
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html 
**/
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\HTML\HTMLHelper;
class JFormFieldSPcategories extends FormField {
	protected $type = 'SPcategories';
	public function getInput() { // added class hidden in fieldset
		if(JVERSION < 4){
			require_once dirname(__FILE__) . './../helper.php';
		}
		$db = Factory::getDbo();
		$db->getQuery(true);
		$query = "SHOW TABLES LIKE '#__sppagebuilder'";
		$db->setQuery($query);
		    try
		    {
		        // If it fails, it will throw a RuntimeException
		        $result = $db->loadResult(); 
		        $db1 = Factory::getDbo();
				$query6 = $db1->getQuery(true);
				$query6
	            ->select('id as value, title as title')
	            ->from('#__categories')
	            ->where('published=1 AND extension="com_sppagebuilder"');
	            $db1->setQuery($query6);
	            $db1->execute();
	            $num_rows = $db1->getNumRows();
	            $results6 = $db1->loadObjectList();
	            $options = array();
		        if($results6!=''){
		            foreach ($results6 as $list) {
		                $options[] = array(
		                    'id'   => $list->value,
		                    'id'   => $list->value,
		                    'name' => $list->title
		                );
		            }
		        }
		        $attribs = 'multiple="multiple" class="multipleCategories"';
				return HTMLHelper::_('select.genericlist', $options, 'jform[params][spcatid][]', $attribs, 'id', 'name', $this->value, $this->id);
		    }
		    catch (RuntimeException $e)
		    {
		    	$search_in_sppage = $this->form->getValue('search_in_sppage', 'params');
		    	if($search_in_sppage){
		    		Factory::getApplication()->enqueueMessage(JText::_('MOD_SEARCHAJAX_FIELD_SP_NOT_EXITS'), 'error');
		    	}
		        $options = array();
		        $attribs = 'multiple="multiple" class="multipleCategories"';
				return HTMLHelper::_('select.genericlist', $options, 'jform[params][spcatid][]', $attribs, 'id', 'name', $this->value, $this->id);
			}
	}
}